/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.core.PacketTestException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Random;

public class PacketTestSegmentHeader
extends PacketTest {
    private String testcase;
    public static final int testsPerField = 10;
    public static int testoffset = 0;

    public static void prepare() {
        Random ran = new Random();
        testoffset = ran.nextInt(10);
    }

    public void run() {
        this.addMessage("Initialized", 'I', "Test startet with 10 tests per loop and an testoffset of " + testoffset);
        try {
            this.testSegmentLength();
            this.testSegmentOffset();
            this.testNoOfParts();
            this.testSegmentNumber();
            this.testSegmentKind();
            this.testMessageType();
            this.testSqlmode();
            this.testProducer();
            this.testCommitImediately();
            this.testIgnoreCostwarning();
            this.testPrepare();
            this.testWithInfo();
            this.testMassCmd();
            this.testParseAgain();
            this.testOptions();
            this.testFill();
        }
        catch (TestDatabaseException ex) {
            ex.printStackTrace();
        }
    }

    public void testSegmentLength() throws TestDatabaseException {
        this.testcase = "Segment Length";
        this.printDebugtestcase();
        int pos = 56;
        int len = 4;
        long size = (long)Math.pow(256.0, 4.0);
        int[] packets = new int[]{4};
        this.turn(packets, 56, 4, 0L);
        this.turn(packets, 56, 4, 1L);
        this.turn(packets, 56, 4, 7L);
        this.turn(packets, 56, 4, 8L);
        this.turn(packets, 56, 4, 9L);
        this.turn(packets, 56, 4, 7L);
        this.turn(packets, 56, 4, Integer.MIN_VALUE);
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 56, 4, 0L);
        this.turn(packets1, 56, 4, 1L);
        this.turn(packets1, 56, 4, 7L);
        this.turn(packets1, 56, 4, 8L);
        this.turn(packets1, 56, 4, 9L);
        this.turn(packets1, 56, 4, 7L);
        this.turn(packets1, 56, 4, Integer.MIN_VALUE);
    }

    public void testSegmentOffset() throws TestDatabaseException {
        this.testcase = "Segment Offset";
        this.printDebugtestcase();
        int pos = 60;
        int len = 4;
        long size = (long)Math.pow(256.0, 4.0);
        int[] packets = new int[]{4};
        this.turn(packets, 60, 4, 0L);
        this.turn(packets, 60, 4, 1L);
        this.turn(packets, 60, 4, 2L);
        this.turn(packets, 60, 4, 3L);
        this.turn(packets, 60, 4, 256L);
        this.turn(packets, 60, 4, 65536L);
        this.turn(packets, 60, 4, 0x1000000L);
        this.turn(packets, 60, 4, Integer.MIN_VALUE);
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 60, 4, 0L);
        this.turn(packets1, 60, 4, 1L);
        this.turn(packets1, 60, 4, 2L);
        this.turn(packets1, 60, 4, 3L);
        this.turn(packets1, 60, 4, 256L);
        this.turn(packets1, 60, 4, 65536L);
        this.turn(packets1, 60, 4, 0x1000000L);
        this.turn(packets1, 60, 4, Integer.MIN_VALUE);
    }

    public void testNoOfParts() throws TestDatabaseException {
        this.testcase = "No Of Parts";
        this.printDebugtestcase();
        int pos = 64;
        int len = 2;
        long size = (long)Math.pow(256.0, 2.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 64, 2, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 64, 2, i2);
            i2 += size / 10L;
        }
    }

    public void testSegmentNumber() throws TestDatabaseException {
        this.testcase = "Segment Number";
        this.printDebugtestcase();
        int pos = 66;
        int len = 2;
        long size = (long)Math.pow(256.0, 2.0);
        int[] packets = new int[]{4};
        this.turn(packets, 66, 2, 0L);
        this.turn(packets, 66, 2, 1L);
        this.turn(packets, 66, 2, 2L);
        this.turn(packets, 66, 2, 3L);
        this.turn(packets, 66, 2, -1L);
        long i = 4 + testoffset;
        while (i < size) {
            this.turn(packets, 66, 2, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 66, 2, 0L);
        this.turn(packets1, 66, 2, 1L);
        this.turn(packets1, 66, 2, 2L);
        this.turn(packets1, 66, 2, 3L);
        this.turn(packets1, 66, 2, -1L);
        long i2 = 4 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 66, 2, i2);
            i2 += size / 10L;
        }
    }

    public void testSegmentKind() throws TestDatabaseException {
        this.testcase = "Segment Kind";
        this.printDebugtestcase();
        int pos = 68;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets1 = new int[]{4, 5, 6};
        this.turn(packets1, 68, 1, 1L);
        this.turn(packets1, 68, 1, 2L);
        this.turn(packets1, 68, 1, 0L);
        this.turn(packets1, 68, 1, 3L);
        long i = 4 + testoffset;
        while (i < size) {
            this.turn(packets1, 68, 1, i);
            i += size / 10L;
        }
    }

    public void testMessageType() throws TestDatabaseException {
        this.testcase = "Message Type";
        this.printDebugtestcase();
        int pos = 69;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        long i = 0L;
        while (i < 51L) {
            this.turn(packets, 69, 1, i);
            ++i;
        }
        i = 52 + testoffset;
        while (i < size) {
            this.turn(packets, 69, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = 0L;
        while (i2 < 51L) {
            this.turn(packets1, 69, 1, i2);
            ++i2;
        }
        i2 = 52 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 69, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testSqlmode() throws TestDatabaseException {
        this.testcase = "Sqlmode";
        this.printDebugtestcase();
        int pos = 70;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        long i = 0L;
        while (i < 6L) {
            this.turn(packets, 70, 1, i);
            ++i;
        }
        i = 7 + testoffset;
        while (i < size) {
            this.turn(packets, 70, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = 0L;
        while (i2 < 6L) {
            this.turn(packets1, 70, 1, i2);
            ++i2;
        }
        i2 = 7 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 70, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testProducer() throws TestDatabaseException {
        this.testcase = "Producer";
        this.printDebugtestcase();
        int pos = 71;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 71, 1, 1L);
        this.turn(packets, 71, 1, 2L);
        this.turn(packets, 71, 1, 4L);
        this.turn(packets, 71, 1, 0L);
        this.turn(packets, 71, 1, 3L);
        this.turn(packets, 71, 1, 5L);
        long i = 6 + testoffset;
        while (i < size) {
            this.turn(packets, 71, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 71, 1, 1L);
        this.turn(packets1, 71, 1, 2L);
        this.turn(packets1, 71, 1, 4L);
        this.turn(packets1, 71, 1, 0L);
        this.turn(packets1, 71, 1, 3L);
        this.turn(packets1, 71, 1, 5L);
        long i2 = 6 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 71, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testCommitImediately() throws TestDatabaseException {
        this.testcase = "Commit Imediately";
        this.printDebugtestcase();
        int pos = 72;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 72, 1, 0L);
        this.turn(packets, 72, 1, 1L);
        this.turn(packets, 72, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 72, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 72, 1, 0L);
        this.turn(packets1, 72, 1, 1L);
        this.turn(packets1, 72, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 72, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testIgnoreCostwarning() throws TestDatabaseException {
        this.testcase = "Ignore Costwarning";
        this.printDebugtestcase();
        int pos = 73;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 73, 1, 0L);
        this.turn(packets, 73, 1, 1L);
        this.turn(packets, 73, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 73, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 73, 1, 0L);
        this.turn(packets1, 73, 1, 1L);
        this.turn(packets1, 73, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 73, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testPrepare() throws TestDatabaseException {
        this.testcase = "Prepare";
        this.printDebugtestcase();
        int pos = 74;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 74, 1, 0L);
        this.turn(packets, 74, 1, 1L);
        this.turn(packets, 74, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 74, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 74, 1, 0L);
        this.turn(packets1, 74, 1, 1L);
        this.turn(packets1, 74, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 74, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testWithInfo() throws TestDatabaseException {
        this.testcase = "With Info";
        this.printDebugtestcase();
        int pos = 75;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 75, 1, 0L);
        this.turn(packets, 75, 1, 1L);
        this.turn(packets, 75, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 75, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 75, 1, 0L);
        this.turn(packets1, 75, 1, 1L);
        this.turn(packets1, 75, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 75, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testMassCmd() throws TestDatabaseException {
        this.testcase = "Mass Cmd";
        this.printDebugtestcase();
        int pos = 76;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 76, 1, 0L);
        this.turn(packets, 76, 1, 1L);
        this.turn(packets, 76, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 76, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 76, 1, 0L);
        this.turn(packets1, 76, 1, 1L);
        this.turn(packets1, 76, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 76, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testParseAgain() throws TestDatabaseException {
        this.testcase = "Parse Again";
        this.printDebugtestcase();
        int pos = 77;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 77, 1, 0L);
        this.turn(packets, 77, 1, 1L);
        this.turn(packets, 77, 1, 2L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 77, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 77, 1, 0L);
        this.turn(packets1, 77, 1, 1L);
        this.turn(packets1, 77, 1, 2L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 77, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testOptions() throws TestDatabaseException {
        this.testcase = "Options";
        this.printDebugtestcase();
        int pos = 78;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 78, 1, 0L);
        this.turn(packets, 78, 1, 1L);
        this.turn(packets, 78, 1, 2L);
        this.turn(packets, 78, 1, 4L);
        this.turn(packets, 78, 1, 8L);
        this.turn(packets, 78, 1, 16L);
        this.turn(packets, 78, 1, 32L);
        this.turn(packets, 78, 1, 64L);
        this.turn(packets, 78, 1, 128L);
        long i = 3 + testoffset;
        while (i < size) {
            this.turn(packets, 78, 1, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 78, 1, 0L);
        this.turn(packets1, 78, 1, 1L);
        this.turn(packets1, 78, 1, 2L);
        this.turn(packets1, 78, 1, 4L);
        this.turn(packets1, 78, 1, 8L);
        this.turn(packets1, 78, 1, 16L);
        this.turn(packets1, 78, 1, 32L);
        this.turn(packets1, 78, 1, 64L);
        this.turn(packets1, 78, 1, 128L);
        long i2 = 3 + testoffset;
        while (i2 < size) {
            this.turn(packets1, 78, 1, i2);
            i2 += size / 10L;
        }
    }

    public void testFill() throws TestDatabaseException {
        this.testcase = "Fill";
        this.printDebugtestcase();
        int pos = 79;
        int len = 7;
        long size = (long)Math.pow(256.0, 7.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 79, 7, i);
            this.turn(packets, 84, 7, i);
            this.turn(packets, 89, 7, i);
            i += size / 10L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 79, 7, i2);
            this.turn(packets1, 84, 7, i2);
            this.turn(packets1, 89, 7, i2);
            i2 += size / 10L;
        }
    }

    protected void turn(int[] packets, int pos, int len, long value) throws TestDatabaseException {
        int packetnumber = 1;
        StructuredBytes requestPacket = null;
        if (!this.DATABASE.isWarm()) {
            if (PacketTest.DEBUG) {
                System.out.println("Starting Database");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.DATABASE.start();
        }
        try {
            this.connect();
            requestPacket = this.createInfoRequestPacket();
            if (this.contains(packets, packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.out.write(requestPacket.bytes());
            this.printDebug(true, packetnumber, requestPacket);
            StructuredBytes replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, replyPacket);
            this.packetLayout = PacketTest.getPacketLayoutFromReply(replyPacket, true);
            requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            this.sock.close();
            this.connect();
            requestPacket = this.createDbConnectPacket(this.DBNAME);
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlConnectPacket(TestCase.getUser(), TestCase.getPassword());
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlStatementPacket("select * from users");
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            this.sock.close();
        }
        catch (PacketTestException ptex) {
            this.handleError(ptex, packetnumber, pos, len, value, requestPacket);
        }
        catch (RTEException rteex) {
            this.handleError((Exception)((Object)rteex), packetnumber, pos, len, value, requestPacket);
        }
        catch (IOException ioex) {
            this.handleError(ioex, packetnumber, pos, len, value, requestPacket);
        }
        catch (SQLException sqlex) {
            this.handleError(sqlex, packetnumber, pos, len, value, requestPacket);
        }
    }

    public boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void alterPacket(StructuredBytes packet, int pos, int len, long value) {
        switch (len) {
            case 1: {
                packet.putInt1((int)value, pos);
                break;
            }
            case 2: {
                packet.putInt2((int)value, pos);
                break;
            }
            case 4: {
                packet.putInt4((int)value, pos);
                break;
            }
            case 8: {
                packet.putInt8(value, pos);
                break;
            }
            default: {
                packet.putBytes(this.makeBytes(value, len), pos);
            }
        }
    }

    private void handleError(Exception ex, int packetnumber, int pos, int len, long value, StructuredBytes packet) throws TestDatabaseException {
        boolean dbIsWarm = this.DATABASE.isWarm();
        if (PacketTest.DEBUG) {
            String state = dbIsWarm ? "warm" : "not warm";
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', db is " + state + "\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            System.err.println(message);
        }
        if (!dbIsWarm) {
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', database IS DOWN\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            this.addMessage("DB shot down", 'E', message);
        }
    }

    private byte[] makeBytes(long value, int len) {
        byte[] b = new byte[len];
        int i = 0;
        while (i < len) {
            b[len - i - 1] = (byte)(value % 256L);
            value = (long)Math.floor(value / 256L);
            ++i;
        }
        return b;
    }

    private long chartoint(char[] array) {
        long result = 0L;
        int i = 0;
        while (i < array.length) {
            result = (long)((double)result + (double)array[array.length - i - 1] * Math.pow(256.0, i));
            ++i;
        }
        return result;
    }

    private void printDebug(boolean request, int packetnumber, StructuredBytes packet) {
        if (PacketTest.DEBUG) {
            String kind = request ? "Request" : "Reply";
            System.out.println(String.valueOf(kind) + " " + packetnumber + ": " + new String(packet.bytes()));
        }
    }

    private void printDebugtestcase() {
        if (PacketTest.DEBUG) {
            System.out.println("Starting Testcase " + this.testcase);
        }
    }
}

