/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class SyncReceiveNotification
extends Notification {
    private StreamString myDestName;
    private int myDestType;
    private long myTimeOut;
    private long myConsumerID;
    private boolean myNoWait;

    SyncReceiveNotification() {
        this.myDestName = null;
        this.myDestType = 0;
        this.myTimeOut = 0L;
        this.myNoWait = false;
        this.myConsumerID = -1L;
    }

    public SyncReceiveNotification(String destName, int destType, long timeOut, boolean noWait, long consumerID) {
        super("rec");
        this.myDestName = StreamString.create(destName);
        this.myDestType = destType;
        this.myTimeOut = timeOut;
        this.myNoWait = noWait;
        this.myConsumerID = consumerID;
    }

    public String getDestName() {
        return StreamString.getString(this.myDestName);
    }

    public int getDestType() {
        return this.myDestType;
    }

    public long getTimeOut() {
        return this.myTimeOut;
    }

    public void setTimeOut(long newTimeOut) {
        this.myTimeOut = newTimeOut;
    }

    public boolean getNoWait() {
        return this.myNoWait;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public String toString() {
        return "SyncReceiveNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myDestName = in.readStreamString();
        this.myDestType = in.readInt();
        this.myTimeOut = in.readLong();
        this.myConsumerID = in.readLong();
        this.myNoWait = in.readBoolean();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 18, SendStream.getStreamStringLength(this.myDestName) + 4 + 16 + 1);
        out.writeStreamString(this.myDestName);
        out.writeInt(this.myDestType);
        out.writeLong(this.myTimeOut);
        out.writeLong(this.myConsumerID);
        out.writeBoolean(this.myNoWait);
    }
}

