/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.SendingNotificationCounter;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.util.LinkedList;
import javax.jms.JMSException;

public class NotificationChannel {
    private SendStream myStream;
    private StreamString myClientID;
    private LinkedList myChronologicalList;
    private int myCountSendWithoutQueue;
    private SendingNotificationQueue mySendingQueue;
    private SendingNotificationCounter mySendingCounter;
    private String _user;
    private String _password;
    private static final int MAX_SEND_WITHOUT_QUEUE = 10;

    public NotificationChannel(SendStream out, StreamString clientID, String user, String password, SendingNotificationQueue sendingQueue, SendingNotificationCounter sendingCounter) {
        this.myStream = out;
        this.myClientID = clientID;
        this.myCountSendWithoutQueue = 0;
        this.myChronologicalList = new LinkedList();
        this.mySendingQueue = sendingQueue;
        this.mySendingCounter = sendingCounter;
        this._user = user;
        this._password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(SendNotification notification) {
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            this.myChronologicalList.addLast(notification);
            this.mySendingCounter.incr();
        }
    }

    public void close() throws IOException {
        this.myStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            if (this.myChronologicalList.size() > 0) {
                this.mySendingCounter.decr(this.myChronologicalList.size());
                this.myChronologicalList.clear();
            }
        }
    }

    private SendNotification getFirstNotification() {
        if (this.myChronologicalList.isEmpty()) {
            return null;
        }
        return (SendNotification)this.myChronologicalList.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendNotification removeDeliveredGetNext(SendNotification notification) throws IOException {
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            SendNotification first = (SendNotification)this.myChronologicalList.removeFirst();
            this.mySendingCounter.decr();
            if (notification != first) {
                throw new IOException(Thread.currentThread().getName() + ": notification (id = " + notification.getMessageID() + ") is not first (id = " + first.getMessageID() + ") of channel " + this.myClientID.toString());
            }
            if (this.myChronologicalList.isEmpty()) {
                this.myCountSendWithoutQueue = 0;
                return null;
            }
            if (this.myCountSendWithoutQueue < 10 || this.mySendingQueue.getMessagesToSend() <= 0) {
                SendNotification nextToSend = this.getFirstNotification();
                if (nextToSend.isReadyToSend()) {
                    nextToSend.setIsSending();
                    ++this.myCountSendWithoutQueue;
                    return nextToSend;
                }
                this.myCountSendWithoutQueue = 0;
                return null;
            }
            this.tryInsertFirstIntoSendQueue();
            this.myCountSendWithoutQueue = 0;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(Notification notification) throws IOException {
        JmsThread ownThread = JmsThread.setAction("sending notification to client");
        try {
            SendStream sendStream = this.myStream;
            synchronized (sendStream) {
                notification.sendToClient(this.myStream);
            }
        }
        finally {
            if (ownThread != null) {
                ownThread.resetAction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendNotification sendToClientChronological(Notification notification) throws IOException {
        if (!(notification instanceof MessageNotification)) {
            this.sendToClient(notification);
            return null;
        }
        SendNotification toSend = null;
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            toSend = this.getFirstNotification();
            if (toSend == null) {
                throw new IOException(Thread.currentThread().getName() + ": channel " + this.myClientID.toString() + " is empty");
            }
            MessageNotification msgToSend = (MessageNotification)notification;
            if (msgToSend.getMessage() != null && (toSend.getConsumerID() != msgToSend.getMessageConsumerInfo().getConsumerID() || toSend.getMessageID() != msgToSend.getMessage().getMessageID())) {
                throw new IOException(Thread.currentThread().getName() + ": Notification (id = " + msgToSend.getMessage().getMessageID() + ") is not first (id = " + toSend.getMessageID() + " of channel " + this.myClientID.toString());
            }
        }
        this.sendToClient(notification);
        return this.removeDeliveredGetNext(toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadyToSend(SendNotification newCompletedNotification) throws JMSException {
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            newCompletedNotification.setIsReadyToSend();
            this.tryInsertFirstIntoSendQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryDropNotification(SendNotification notification) {
        LinkedList linkedList = this.myChronologicalList;
        synchronized (linkedList) {
            if (!notification.isSending() && this.myChronologicalList.remove(notification)) {
                this.mySendingCounter.decr();
            }
        }
    }

    private void tryInsertFirstIntoSendQueue() {
        SendNotification first = this.getFirstNotification();
        if (first == null) {
            return;
        }
        if (first.isReadyToSend()) {
            this.mySendingQueue.addMessageToSend(first);
        }
    }

    public String getPassword() {
        return this._password;
    }

    public String getUser() {
        return this._user;
    }
}

