/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.agents.ReceivingException;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;

public class ErrorNotification
extends Notification {
    private Exception myException;
    private String myErrorMessage;

    ErrorNotification() {
        this.myException = null;
        this.myErrorMessage = null;
    }

    public ErrorNotification(String errorMessage) {
        this.myException = null;
        this.myErrorMessage = errorMessage;
    }

    public ErrorNotification(Exception ex) {
        this.myException = ex;
        if (ex instanceof ReceivingException && ((ReceivingException)ex).getException() instanceof SQLException) {
            ex = ((ReceivingException)ex).getException();
        }
        this.myErrorMessage = ex instanceof SQLException ? ex.toString() + "; " + ((SQLException)ex).getSQLState() : this.getStackTraceAsString(ex);
    }

    public String getErrorMessage() {
        if (this.myErrorMessage == null) {
            return this.myException.getMessage();
        }
        return this.myErrorMessage;
    }

    public Exception getException() {
        if (this.myException != null) {
            return this.myException;
        }
        return new Exception(this.myErrorMessage);
    }

    public String toString() {
        return "ErrorNotification: [" + this.getErrorMessage() + "] " + super.toString();
    }

    private String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        if (in.readBoolean()) {
            StreamString exceptionString = in.readStreamString();
            this.myException = exceptionString == null ? null : new Exception(exceptionString.getString());
            this.myErrorMessage = StreamString.getString(in.readStreamString());
        }
        this.myException = (Exception)in.readSerializableObject();
        this.myErrorMessage = in.readString();
    }

    void writeToStream(SendStream out) throws IOException {
        if (out.isNativeStream()) {
            StreamString exceptionString = this.myException == null ? null : new StreamString(this.myException.toString());
            StreamString errorMessage = StreamString.create(this.myErrorMessage);
            super.serialize(out, 10, 1 + SendStream.getStreamStringLength(exceptionString) + SendStream.getStreamStringLength(errorMessage));
            out.writeBoolean(true);
            out.writeStreamString(exceptionString);
            out.writeStreamString(errorMessage);
            return;
        }
        super.serialize(out, 10, -1);
        out.writeBoolean(false);
        out.writeSerializableObject(this.myException);
        out.writeString(this.myErrorMessage);
    }
}

