/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class DeactivateAdminNotification
extends AdminNotification {
    private boolean myRemove;
    private long myConsumerID;
    private StreamString myReceiverClientAddress;
    public static final transient int UNREGISTER_DESTINATION = 0;
    public static final transient int UNSUBSCRIBE_DESTINATION = 1;
    public static final transient int IGNORE_CONSUMER_BY_SENDORDER_POLLING = 2;
    public static final transient int TAKE_INTO_ACCOUNT_CONSUMER_BY_SENDORDER_POLLING = 3;

    DeactivateAdminNotification() {
        this.myRemove = false;
        this.myConsumerID = 0L;
        this.myReceiverClientAddress = null;
    }

    public DeactivateAdminNotification(int type, String receiverClientAddress, boolean remove, long consumerID) {
        super(type);
        this.myConsumerID = consumerID;
        this.myRemove = remove;
        this.myReceiverClientAddress = new StreamString(receiverClientAddress);
    }

    public boolean getRemove() {
        return this.myRemove;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public StreamString getReceiverClientAddress() {
        return this.myReceiverClientAddress;
    }

    public String toString() {
        return "DeactivateAdminNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myRemove = in.readBoolean();
        this.myConsumerID = in.readLong();
        this.myReceiverClientAddress = in.readStreamString();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 5, 9 + SendStream.getStreamStringLength(this.myReceiverClientAddress));
        out.writeBoolean(this.myRemove);
        out.writeLong(this.myConsumerID);
        out.writeStreamString(this.myReceiverClientAddress);
    }
}

