/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendOrderKey;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.util.Vector;

public class ClientEndTransNotification
extends Notification {
    private int myTransientSentCount;
    private int myPersistentSentCount;
    private long myTransactionID;
    private Vector myWriteTransientSendOrderKeys = null;
    private Vector myWritePersistentSendOrderKeys = null;
    private SendOrderKey[] myReadTransientSendOrderKeys = null;
    private SendOrderKey[] myReadPersistentSendOrderKeys = null;
    public static final int ROLLBACK = 0;
    public static final int COMMIT = 1;

    public ClientEndTransNotification() {
        super("ack");
        this.myTransactionID = -1L;
        this.myTransientSentCount = 0;
        this.myPersistentSentCount = 0;
    }

    public ClientEndTransNotification(int initialListCapacity) {
        super("ack");
        this.myWriteTransientSendOrderKeys = new Vector(initialListCapacity);
        this.myWritePersistentSendOrderKeys = new Vector(initialListCapacity);
        this.initForWrite(-1L);
    }

    public void addReceivedMessage(SendOrderKey aSendOrderKey, int modeDelivery) {
        if (modeDelivery == 1) {
            this.myWriteTransientSendOrderKeys.add(aSendOrderKey);
        } else {
            this.myWritePersistentSendOrderKeys.add(aSendOrderKey);
        }
    }

    public void incrSentMessage(int modeDelivery) {
        if (modeDelivery == 1) {
            ++this.myTransientSentCount;
        } else {
            ++this.myPersistentSentCount;
        }
    }

    public void initForWrite(long transactionId) {
        this.myTransactionID = transactionId;
        this.myTransientSentCount = 0;
        this.myPersistentSentCount = 0;
        this.myWriteTransientSendOrderKeys.clear();
        this.myWritePersistentSendOrderKeys.clear();
    }

    public int getPersistentSentCount() {
        return this.myPersistentSentCount;
    }

    public SendOrderKey[] getSendOrderKeys(int modeDelivery) {
        return modeDelivery == 1 ? this.myReadTransientSendOrderKeys : this.myReadPersistentSendOrderKeys;
    }

    public long getTransactionID() {
        return this.myTransactionID;
    }

    public int getTransientSentCount() {
        return this.myTransientSentCount;
    }

    public boolean isEmptyAtClientSide() {
        return this.myTransientSentCount == 0 && this.myPersistentSentCount == 0 && this.myWriteTransientSendOrderKeys.isEmpty() && this.myWritePersistentSendOrderKeys.isEmpty();
    }

    public void setTransactionID(long transactionID) {
        this.myTransactionID = transactionID;
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myTransactionID = in.readLong();
        this.myTransientSentCount = in.readInt();
        this.myPersistentSentCount = in.readInt();
        this.myReadTransientSendOrderKeys = this.readSendOrderKeyList(in);
        this.myReadPersistentSendOrderKeys = this.readSendOrderKeyList(in);
    }

    private SendOrderKey[] readSendOrderKeyList(ReceiveStream in) throws IOException {
        int size = in.readInt();
        if (size < 1) {
            return null;
        }
        SendOrderKey[] list = new SendOrderKey[size];
        for (int i = 0; i < size; ++i) {
            list[i] = SendOrderKey.deserialize(in);
        }
        return list;
    }

    private void writeSendOrderKeyList(SendStream out, Vector sendOrderKeys) throws IOException {
        int size = sendOrderKeys == null ? 0 : sendOrderKeys.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ((SendOrderKey)sendOrderKeys.get(i)).serialize(out);
        }
    }

    void writeToStream(SendStream out) throws IOException {
        int length = 24 + SendOrderKey.getSerializationLength() * this.myWriteTransientSendOrderKeys.size() + SendOrderKey.getSerializationLength() * this.myWritePersistentSendOrderKeys.size();
        super.serialize(out, 9, length);
        out.writeLong(this.myTransactionID);
        out.writeInt(this.myTransientSentCount);
        out.writeInt(this.myPersistentSentCount);
        this.writeSendOrderKeyList(out, this.myWriteTransientSendOrderKeys);
        this.writeSendOrderKeyList(out, this.myWritePersistentSendOrderKeys);
    }
}

