/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;

public class AckOneMessageByClientNotification
extends Notification {
    public static final transient int ROLLBACK = 0;
    public static final transient int COMMIT = 1;
    private long myMessageID;
    private long myConsumerID;
    private byte myDeliveryMode;
    private boolean myIsQueueMessage;

    AckOneMessageByClientNotification() {
        this.myMessageID = 0L;
        this.myConsumerID = 0L;
    }

    public AckOneMessageByClientNotification(int type, int modeDelivery, long messageID, long ConsumerID, boolean isQueueMessage) {
        super(type, "ack");
        this.myMessageID = messageID;
        this.myConsumerID = ConsumerID;
        this.myIsQueueMessage = isQueueMessage;
        this.setDeliveryMode(modeDelivery);
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public int getDeliveryMode() {
        return this.myDeliveryMode;
    }

    public long getMessageID() {
        return this.myMessageID;
    }

    public boolean isQueueMessage() {
        return this.myIsQueueMessage;
    }

    public void setConsumerID(long consumerID) {
        this.myConsumerID = consumerID;
    }

    public void setDeliveryMode(int modeDelivery) {
        this.myDeliveryMode = (byte)modeDelivery;
    }

    public void setIsQueueMessage(boolean isQueueMessage) {
        this.myIsQueueMessage = isQueueMessage;
    }

    public void setMessageID(long messageID) {
        this.myMessageID = messageID;
    }

    public String toString() {
        return "(AckOneMessageByClientNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myDeliveryMode = in.readByte();
        this.myMessageID = in.readLong();
        this.myConsumerID = in.readLong();
        this.myIsQueueMessage = in.readBoolean();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 2, 18);
        out.writeByte(this.myDeliveryMode);
        out.writeLong(this.myMessageID);
        out.writeLong(this.myConsumerID);
        out.writeBoolean(this.myIsQueueMessage);
    }
}

