/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.transientStorage;

import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccess.TableName;
import com.sap.sdb.minDB.util.ErrorMsg;
import com.sap.sdb.msgServer.transientStorage.TableWithIndex;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;

public class DatabaseTables {
    private static Table[] m_table = new Table[6];
    private static int m_maxSendOrders = 0;
    private static long m_maxMessageSpace = 0L;
    private static long m_usedMessageSpace = 0L;
    private static final int JNDI_LOOKUP = 0;
    private static final int MSGSERVER_CONSUMER = 1;
    private static final int MSGSERVER_DESTINATION = 2;
    private static final int MSGSERVER_MESSAGE = 3;
    private static final int MSGSERVER_SENDORDER = 4;
    private static final int MSGSERVER_TRANSACTIONS = 5;
    private static final int MAX_TABLES = 6;
    private static final String MAX_ORDERS_PROPERTY = "maxSendOrders";
    private static final String MAX_MSG_SPACE_PROPERTY = "maxMessageSpace";
    private static final String TABLE_OWNER = "MSGSERVER";
    private static final int RC_TOO_MANY_SEND_ORDERS = -900;
    private static final int RC_MESSAGE_SPACE_EXCEEDED = -900;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkSendOrderLimit() throws SQLException {
        if (m_maxSendOrders > 0) {
            Table sendorderTab;
            Table table = sendorderTab = m_table[4];
            synchronized (table) {
                if (sendorderTab.getRowCount() >= m_maxSendOrders) {
                    throw ErrorMsg.newSQLException("Too many send orders :send order limit = " + m_maxSendOrders, -900);
                }
            }
        }
    }

    private static void createTables() throws SQLException {
        int i;
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<Byte> columnTypeList = new LinkedList<Byte>();
        LinkedList<String> keyColumnNames = new LinkedList<String>();
        TableName tabname = null;
        tabname = new TableName(TABLE_OWNER, "JNDI_LOOKUP");
        columnNames.addLast("NAME");
        columnTypeList.addLast(new Byte(2));
        columnNames.addLast("CONTENT");
        columnTypeList.addLast(new Byte(1));
        keyColumnNames.addLast("NAME");
        DatabaseTables.m_table[0] = new Table(tabname, columnNames, columnTypeList, keyColumnNames);
        columnNames.clear();
        columnTypeList.clear();
        keyColumnNames.clear();
        tabname = new TableName(TABLE_OWNER, "MSGSERVER_CONSUMER");
        columnNames.addLast("ID");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("CLIENT");
        columnTypeList.addLast(new Byte(2));
        columnNames.addLast("DESTINATION");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("TYPE");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("STATE");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("SUBSCRIPTION");
        columnTypeList.addLast(new Byte(2));
        columnNames.addLast("MSGSELECTOR");
        columnTypeList.addLast(new Byte(2));
        columnNames.addLast("NOLOCAL");
        columnTypeList.addLast(new Byte(4));
        keyColumnNames.addLast("ID");
        DatabaseTables.m_table[1] = new Table(tabname, columnNames, columnTypeList, keyColumnNames);
        columnNames.clear();
        columnTypeList.clear();
        keyColumnNames.clear();
        tabname = new TableName(TABLE_OWNER, "MSGSERVER_DESTINATION");
        columnNames.addLast("ID");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("NAME");
        columnTypeList.addLast(new Byte(2));
        columnNames.addLast("IS_QUEUE");
        columnTypeList.addLast(new Byte(4));
        keyColumnNames.addLast("ID");
        DatabaseTables.m_table[2] = new Table(tabname, columnNames, columnTypeList, keyColumnNames);
        columnNames.clear();
        columnTypeList.clear();
        keyColumnNames.clear();
        tabname = new TableName(TABLE_OWNER, "MSGSERVER_MESSAGE");
        columnNames.addLast("ID");
        columnTypeList.addLast(new Byte(4));
        columnNames.addLast("MESSAGE_OBJ");
        columnTypeList.addLast(new Byte(5));
        columnNames.addLast("USED_BYTES");
        columnTypeList.addLast(new Byte(4));
        keyColumnNames.addLast("ID");
        DatabaseTables.m_table[3] = new Table(tabname, columnNames, columnTypeList, keyColumnNames);
        columnNames.clear();
        columnTypeList.clear();
        keyColumnNames.clear();
        tabname = new TableName(TABLE_OWNER, "MSGSERVER_SENDORDER");
        columnNames.addLast("MESSAGE");
        columnNames.addLast("TOPIC_CONSUMER");
        columnNames.addLast("CONSUMER");
        columnNames.addLast("DESTINATION");
        columnNames.addLast("TRANS_SEQUENCE");
        columnNames.addLast("MSG_SEQUENCE");
        columnNames.addLast("IS_QUEUEORDER");
        columnNames.addLast("IS_INPROCESS");
        columnNames.addLast("IS_DELIVERED");
        columnNames.addLast("MSGSERVER_TRANSACTION");
        columnNames.addLast("PRIORITY");
        columnNames.addLast("EXPIRES");
        columnNames.addLast("HAS_ACTIVE_CONSUMER");
        for (i = 0; i < columnNames.size(); ++i) {
            columnTypeList.add(new Byte(4));
        }
        keyColumnNames.addLast("MESSAGE");
        keyColumnNames.addLast("TOPIC_CONSUMER");
        DatabaseTables.m_table[4] = TableWithIndex.getNewTableWithIndex(tabname, columnNames, columnTypeList, keyColumnNames, 11, false, 5, true, 6, true);
        columnNames.clear();
        columnTypeList.clear();
        keyColumnNames.clear();
        tabname = new TableName(TABLE_OWNER, "msgserver_transactionS");
        columnNames.addLast("MESSAGE");
        columnNames.addLast("CONSUMER");
        columnNames.addLast("DESTINATION");
        columnNames.addLast("IS_QUEUEORDER");
        columnNames.addLast("MSGSERVER_TRANSACTION");
        columnNames.addLast("PRIORITY");
        columnNames.addLast("EXPIRES");
        for (i = 0; i < columnNames.size(); ++i) {
            columnTypeList.add(new Byte(4));
        }
        keyColumnNames.addLast("MESSAGE");
        keyColumnNames.addLast("CONSUMER");
        DatabaseTables.m_table[5] = new Table(tabname, columnNames, columnTypeList, keyColumnNames);
    }

    static void decreaseUsedMessageSpace(long releasedBytes) {
        if (releasedBytes <= 0L) {
            return;
        }
        m_usedMessageSpace = m_usedMessageSpace > releasedBytes ? m_usedMessageSpace - releasedBytes : 0L;
    }

    static Table getConsumerTable() {
        return m_table[1];
    }

    static Table getDestinationTable() {
        return m_table[2];
    }

    static Table getLookupTable() {
        return m_table[0];
    }

    static long getMaxMessageSpace() {
        return m_maxMessageSpace;
    }

    static int getMaxSendOrders() {
        return m_maxSendOrders;
    }

    static Table getMessageTable() {
        return m_table[3];
    }

    static TableWithIndex getSendorderTable() {
        return (TableWithIndex)m_table[4];
    }

    static Table getTransactionTable() {
        return m_table[5];
    }

    static long getUsedMessageSpace() {
        return m_usedMessageSpace;
    }

    static void increaseUsedMessageSpace(long usedBytes) throws SQLException {
        long used;
        if (usedBytes <= 0L) {
            return;
        }
        long l = used = Long.MAX_VALUE - usedBytes < m_usedMessageSpace ? Long.MAX_VALUE : usedBytes;
        if (m_maxMessageSpace > 0L && m_usedMessageSpace + used >= m_maxMessageSpace) {
            throw ErrorMsg.newSQLException("Transient message space exceeded: max/used space: " + m_maxMessageSpace / 1024L + "/" + m_usedMessageSpace / 1024L + " KB; message size: " + used + " bytes", -900);
        }
        m_usedMessageSpace += used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printSizeOfTables() {
        for (int i = 0; i < 6; ++i) {
            Table table = m_table[i];
            synchronized (table) {
                System.out.println(m_table[i].getTableName() + ": " + m_table[i].getRowCount() + " row(s)");
                continue;
            }
        }
    }

    static void setLimits(Properties props) {
        long maxMessageSpace;
        int maxSendOrders;
        if (m_maxSendOrders != 0 || m_maxMessageSpace != 0L) {
            return;
        }
        String maxSendOrdersStr = props.getProperty(MAX_ORDERS_PROPERTY);
        String maxMessageSpaceStr = props.getProperty(MAX_MSG_SPACE_PROPERTY);
        if (maxSendOrdersStr != null && (maxSendOrders = Integer.parseInt(maxSendOrdersStr)) > 0) {
            m_maxSendOrders = maxSendOrders;
        }
        if (maxMessageSpaceStr != null && (maxMessageSpace = Long.parseLong(maxMessageSpaceStr)) > 0L) {
            m_maxMessageSpace = maxMessageSpace;
        }
    }

    static {
        try {
            DatabaseTables.createTables();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }
}

