/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.agents.ServerOID;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.SendOrderKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;

public abstract class SendOrderTable {
    private static final int FETCH_PRIORITY = 1;
    private static final int FETCH_TRANS_SEQUENCE = 2;
    private static final int FETCH_MSG_SEQUENCE = 3;
    private static final int FETCH_MESSAGE = 4;
    private static final int FETCH_CONSUMER = 5;
    private static final int FETCH_IS_QUEUEORDER = 6;
    private static final int FETCH_DESTINATION = 7;
    private static final int FETCH_IS_DELIVERED = 8;

    public static ResultSet getResultForBrowser(UserConnection dbConnection, int modeDelivery, long destID, long messageID, boolean queueOrders) throws SQLException {
        DeliveryPreparedStmt stmt = null;
        stmt = queueOrders ? dbConnection.getDeliveryPreparedStmt(65, modeDelivery) : dbConnection.getDeliveryPreparedStmt(66, modeDelivery);
        stmt.setLong(1, destID);
        stmt.setLong(2, messageID);
        DeliveryResultSet result = stmt.executeQuery();
        return result;
    }

    public static void insertOrderForQueue(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID, long destinationID, long transactionID, int priority, long expireTime, int inProc, boolean hasActiveConsumer) throws SQLException {
        DeliveryPreparedStmt stmt = null;
        if (transactionID == -1L) {
            long transSeq = DestinationList.getSequenceNumberForTrans(dbConnection);
            long msgSeq = DestinationList.getSequenceNumberForMsg(dbConnection, destinationID);
            stmt = dbConnection.getDeliveryPreparedStmt(39, modeDelivery);
            stmt.setLong(1, messageID);
            stmt.setLong(2, 0L);
            stmt.setLong(3, consumerID);
            stmt.setLong(4, destinationID);
            stmt.setLong(5, transSeq);
            stmt.setLong(6, msgSeq);
            stmt.setBoolean(7, true);
            stmt.setInt(8, inProc);
            stmt.setBoolean(9, false);
            stmt.setLong(10, transactionID);
            stmt.setInt(11, priority);
            stmt.setLong(12, expireTime);
            stmt.setBoolean(13, hasActiveConsumer);
        } else {
            stmt = dbConnection.getDeliveryPreparedStmt(68, modeDelivery);
            stmt.setLong(1, messageID);
            stmt.setLong(2, 0L);
            stmt.setLong(3, destinationID);
            stmt.setBoolean(4, true);
            stmt.setLong(5, transactionID);
            stmt.setInt(6, priority);
            stmt.setLong(7, expireTime);
        }
        stmt.executeUpdate();
    }

    public static void insertOrderForQueue(UserConnection dbConnection, int modeDelivery, long messageID, long destinationID, long transactionID, int priority, long expireTime, boolean hasActiveConsumer) throws SQLException {
        SendOrderTable.insertOrderForQueue(dbConnection, modeDelivery, messageID, 0L, destinationID, transactionID, priority, expireTime, 0, hasActiveConsumer);
    }

    public static ResultSet getPossibleConsumersForTopic(UserConnection dbConnection, int modeDelivery, long destinationID) throws SQLException {
        DeliveryResultSet retval = null;
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(14, modeDelivery);
        stmt.setLong(1, destinationID);
        retval = stmt.executeQuery();
        return retval;
    }

    public static void insertOrderForTopic(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID, long destinationID, long msgSeq, long transSeq, long transactionID, int priority, long expireTime, int inProc, boolean hasActiveConsumer) throws SQLException {
        DeliveryPreparedStmt stmt = null;
        if (transactionID == -1L) {
            stmt = dbConnection.getDeliveryPreparedStmt(39, modeDelivery);
            stmt.setLong(1, messageID);
            stmt.setLong(2, consumerID);
            stmt.setLong(3, consumerID);
            stmt.setLong(4, destinationID);
            stmt.setLong(5, transSeq);
            stmt.setLong(6, msgSeq);
            stmt.setBoolean(7, false);
            stmt.setInt(8, inProc);
            stmt.setBoolean(9, false);
            stmt.setLong(10, transactionID);
            stmt.setInt(11, priority);
            stmt.setLong(12, expireTime);
            stmt.setBoolean(13, hasActiveConsumer);
        } else {
            stmt = dbConnection.getDeliveryPreparedStmt(68, modeDelivery);
            stmt.setLong(1, messageID);
            stmt.setLong(2, consumerID);
            stmt.setLong(3, destinationID);
            stmt.setBoolean(4, false);
            stmt.setLong(5, transactionID);
            stmt.setInt(6, priority);
            stmt.setLong(7, expireTime);
        }
        stmt.executeUpdate();
    }

    public static boolean setDelivered(UserConnection dbConnection, int modeDelivery, boolean isQueueMessage, long messageID, long consumerID, boolean bAsync) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(49, modeDelivery);
        stmt.setLong(1, messageID);
        if (isQueueMessage) {
            stmt.setLong(2, 0L);
        } else {
            stmt.setLong(2, consumerID);
        }
        if (bAsync) {
            stmt.setInt(3, 1);
        } else {
            stmt.setInt(3, 2);
        }
        int rowCount = stmt.executeUpdate();
        return rowCount == 1;
    }

    public static int setInprocessAndDelivered(UserConnection dbConnection, int modeDelivery, int inProcessType, long newConsumerID, long messageID, long topicConsumerID) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(50, modeDelivery);
        stmt.setInt(1, inProcessType);
        stmt.setLong(2, newConsumerID);
        stmt.setLong(3, messageID);
        stmt.setLong(4, topicConsumerID);
        return stmt.executeUpdate();
    }

    public static int ackMsgListReceivedByClient(UserConnection dbConnection, int modeDelivery, boolean commit, SendOrderKey[] sendOrderKeys) throws JMSException, SQLException {
        if (sendOrderKeys.length < 1) {
            return 0;
        }
        boolean isQueueMessage = sendOrderKeys[0].isQueueMessage();
        int rowCount = 0;
        for (int i = 0; i < sendOrderKeys.length; ++i) {
            if (sendOrderKeys[i].isQueueMessage() != isQueueMessage) {
                throw new JMSException("Transaction contains topic and queue messages (message id: " + sendOrderKeys[i].getMessageID() + ")");
            }
            if (commit) {
                rowCount += SendOrderTable.deleteReceivedOrder(dbConnection, modeDelivery, sendOrderKeys[i].getMessageID(), sendOrderKeys[i].getConsumerID(), isQueueMessage);
                continue;
            }
            rowCount += SendOrderTable.rollbackReceivedOrder(dbConnection, modeDelivery, sendOrderKeys[i].getMessageID(), sendOrderKeys[i].getConsumerID(), isQueueMessage);
        }
        return rowCount;
    }

    public static int ackOneMsgReceivedByClient(UserConnection dbConnection, int modeDelivery, boolean commit, long messageID, long consumerID, boolean isQueueMessage) throws SQLException {
        if (commit) {
            return SendOrderTable.deleteReceivedOrder(dbConnection, modeDelivery, messageID, consumerID, isQueueMessage);
        }
        return SendOrderTable.rollbackReceivedOrder(dbConnection, modeDelivery, messageID, consumerID, isQueueMessage);
    }

    public static int resetQueueOrder(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(57, modeDelivery);
        stmt.setLong(1, messageID);
        stmt.setLong(2, consumerID);
        return stmt.executeUpdate();
    }

    public static int resetQueueOrdersForConsumer(UserConnection dbConnection, int modeDelivery, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(56, modeDelivery);
        stmt.setLong(1, consumerID);
        return stmt.executeUpdate();
    }

    public static int setSendOrdersActiveForQueueDestination(UserConnection dbConnection, int modeDelivery, long destID, boolean isActive) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(48, modeDelivery);
        stmt.setBoolean(1, isActive);
        stmt.setLong(2, destID);
        stmt.setBoolean(3, !isActive);
        return stmt.executeUpdate();
    }

    public static void lockSendOrders(UserConnection dbConnection, int modeDelivery) throws SQLException {
        if (!DBConnectionPool.connectedToSAPDB(modeDelivery)) {
            return;
        }
        DeliveryPreparedStmt lock = dbConnection.getDeliveryPreparedStmt(75, modeDelivery);
        lock.execute();
        JmsThread.setSQLAction("sendOrderTable locked");
    }

    public static int setSendOrdersActiveForTopicConsumer(UserConnection dbConnection, int modeDelivery, long consumerID, boolean isActive) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(47, modeDelivery);
        stmt.setBoolean(1, isActive);
        stmt.setLong(2, consumerID);
        stmt.setBoolean(3, !isActive);
        return stmt.executeUpdate();
    }

    public static int deleteTopicOrdersForConsumer(UserConnection dbConnection, int modeDelivery, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(42, modeDelivery);
        stmt.setLong(1, consumerID);
        return stmt.executeUpdate();
    }

    public static int resetTopicOrdersForConsumer(UserConnection dbConnection, int modeDelivery, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(58, modeDelivery);
        stmt.setLong(1, consumerID);
        return stmt.executeUpdate();
    }

    public static int deleteTopicOrder(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(45, modeDelivery);
        stmt.setLong(1, messageID);
        stmt.setLong(2, consumerID);
        return stmt.executeUpdate();
    }

    public static int resetTopicOrder(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(59, modeDelivery);
        stmt.setLong(1, messageID);
        stmt.setLong(2, consumerID);
        return stmt.executeUpdate();
    }

    public static void recover(UserConnection dbConnection, int modeDelivery) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(55, modeDelivery);
        stmt.executeUpdate();
        stmt = dbConnection.getDeliveryPreparedStmt(54, modeDelivery);
        stmt.executeUpdate();
        stmt = dbConnection.getDeliveryPreparedStmt(70, modeDelivery);
        stmt.executeUpdate();
    }

    public static int deleteAllOrdersWithoutTopicConsumers(UserConnection dbConnection, int modeDelivery) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(44, modeDelivery);
        stmt.setLong(1, ServerOID.getDiffTimeNext(10L));
        int ret1 = stmt.executeUpdate();
        stmt = dbConnection.getDeliveryPreparedStmt(43, modeDelivery);
        stmt.setLong(1, ServerOID.getDiffTimeNext(10L));
        int ret2 = stmt.executeUpdate();
        return ret1 > 0 && ret2 > 0 ? ret1 + ret2 : 0;
    }

    public static int deleteExpiredOrders(UserConnection dbConnection, int modeDelivery, long timestamp) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(40, modeDelivery);
        stmt.setLong(1, timestamp);
        stmt.setLong(2, ServerOID.getDiffTimeNext(10L));
        return stmt.executeUpdate();
    }

    public static int deleteForDestination(UserConnection dbConnection, int modeDelivery, long destID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(46, modeDelivery);
        stmt.setLong(1, destID);
        return stmt.executeUpdate();
    }

    private static int deleteReceivedOrder(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID, boolean isQueueMessage) throws SQLException {
        long topicConsumerID = isQueueMessage ? 0L : consumerID;
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(41, modeDelivery);
        stmt.setLong(1, messageID);
        stmt.setLong(2, topicConsumerID);
        stmt.setLong(3, consumerID);
        int rowCount = stmt.executeUpdate();
        if (rowCount == 0) {
            return rowCount;
        }
        if (isQueueMessage) {
            MessageTable.deleteMessageById(dbConnection, modeDelivery, messageID, isQueueMessage);
        } else {
            MessageTable.deleteReceivedMessageById(dbConnection, modeDelivery, messageID, isQueueMessage);
        }
        return rowCount;
    }

    private static int rollbackReceivedOrder(UserConnection dbConnection, int modeDelivery, long messageID, long consumerID, boolean isQueueMessage) throws SQLException {
        int cmd = isQueueMessage ? 52 : 53;
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(cmd, modeDelivery);
        stmt.setLong(1, messageID);
        stmt.setLong(2, consumerID);
        if (!isQueueMessage) {
            stmt.setLong(3, consumerID);
        }
        return stmt.executeUpdate();
    }

    public static int rollbackSentByClient(UserConnection dbConnection, int modeDelivery, long transactionID) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(69, modeDelivery);
        stmt.setLong(1, transactionID);
        return stmt.executeUpdate();
    }

    public static ResultSet getResultForCommitSentByClient(UserConnection dbConnection, int modeDelivery, long transactionID) throws SQLException {
        DeliveryResultSet result = null;
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return result;
        }
        try {
            DeliveryPreparedStmt stmtSelect = dbConnection.getDeliveryPreparedStmt(71, modeDelivery);
            stmtSelect.setLong(1, transactionID);
            result = stmtSelect.executeQuery();
        }
        catch (SQLException ex) {
            throw new SQLException(ex.toString(), ex.getSQLState());
        }
        return result;
    }

    public static MessageNotification getMarkedMessageForSyncReceive(UserConnection dbConnection, int modeDelivery, boolean isQueueOrder, MessageConsumerInfo consumerInfo) throws JMSException, SQLException {
        MsgSelector messageSelector;
        long destinationID = consumerInfo.getDestinationID();
        long topicConsumerID = isQueueOrder ? 0L : consumerInfo.getConsumerID();
        MsgSelector msgSelector = messageSelector = isQueueOrder ? consumerInfo.getMsgSelector() : null;
        boolean checkMessage = messageSelector == null ? false : !messageSelector.isEmpty();
        boolean selectOneRow = !checkMessage;
        boolean marked = false;
        boolean wasDelivered = false;
        long messageID = -1L;
        ResultSet result = null;
        while (!marked) {
            if (result == null) {
                DeliveryPreparedStmt selectStmt = dbConnection.getDeliveryPreparedStmt(64, modeDelivery);
                selectStmt.setBoolean(1, isQueueOrder);
                selectStmt.setLong(2, destinationID);
                selectStmt.setLong(3, topicConsumerID);
                if (selectOneRow) {
                    selectStmt.setMaxRows(1);
                }
                result = selectStmt.executeQuery();
            }
            if (!result.next()) break;
            messageID = result.getLong(4);
            boolean bl = wasDelivered = result.getInt(5) == 1;
            if (checkMessage && !MessageTable.matches(dbConnection, modeDelivery, messageID, messageSelector)) continue;
            dbConnection.commit();
            int rowCount = SendOrderTable.setInprocessAndDelivered(dbConnection, modeDelivery, 2, consumerInfo.getConsumerID(), messageID, topicConsumerID);
            dbConnection.commit();
            marked = rowCount == 1;
            if (marked || !selectOneRow) continue;
            result.close();
            result = null;
            selectOneRow = false;
        }
        if (result != null) {
            result.close();
        }
        if (!marked) {
            return null;
        }
        MessageImpl message = MessageTable.findByID(dbConnection, modeDelivery, messageID);
        dbConnection.commit();
        if (message == null) {
            throw new JMSException("Message for send order not found (MessageID: " + messageID + ")");
        }
        MessageNotification msgNotification = FreeLists.getMessageNot(message);
        msgNotification.setRedelivered(wasDelivered);
        return msgNotification;
    }

    public static ResultSet selectOrdersForReceive(UserConnection dbConnection, int modeDelivery, int fetchSize) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(63, modeDelivery);
        if (fetchSize < Integer.MAX_VALUE) {
            stmt.setMaxRows(fetchSize);
        }
        if (modeDelivery == 2) {
            JmsThread.setSQLAction("sendOrderTable select");
        }
        return stmt.executeQuery();
    }

    public static int fetchNextOrdersForReceive(ResultSet result, int modeDelivery, SendNotification[] sendList) throws SQLException {
        int countOrders;
        for (countOrders = 0; result.next() && countOrders < sendList.length; ++countOrders) {
            sendList[countOrders] = FreeLists.getSendNotification(result.getLong(4), result.getLong(5), result.getLong(7), modeDelivery, result.getInt(1), result.getLong(2), result.getLong(3), result.getInt(8) == 1, result.getInt(6) == 1);
        }
        return countOrders;
    }

    public static long selectCountSendOrdersForDest(UserConnection dbConnection, long destID, int inProc, boolean isDelivered, int modeDelivery) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(67, modeDelivery);
        stmt.setLong(1, destID);
        stmt.setInt(2, inProc);
        stmt.setBoolean(3, isDelivered);
        DeliveryResultSet result = stmt.executeQuery();
        if (result == null) {
            return 0L;
        }
        if (!result.next()) {
            result.close();
            return 0L;
        }
        long ret = result.getLong(1);
        result.close();
        return ret;
    }
}

