/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.ServerOID;
import com.sap.sdb.msgServer.client.MessageHeaderFields;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.MessageCache;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.database.UserDefMsgPropTable;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import java.sql.SQLException;
import javax.jms.JMSException;

public class MessageTable {
    public static void createMessage(UserConnection dbConnection, MessageImpl aMessage, long destID) throws SQLException, JMSException {
        int userDefPropLen = aMessage.isQueueMessage() ? aMessage.getUserDefPropSize() : 0;
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(26, aMessage.getJMSDeliveryMode());
        stmt.setLong(1, aMessage.getMessageID());
        if (MessageTable.isMessageSavedInMemory(aMessage.getJMSDeliveryMode())) {
            stmt.setObject(2, aMessage);
            stmt.setLong(3, aMessage.getBytesUsed());
            stmt.executeUpdate();
            return;
        }
        byte[] data = aMessage.getMessageContentsBytes();
        int msgSize = aMessage.getMessageContentsSize();
        if (msgSize <= 2048) {
            stmt.setBytes(2, data);
            stmt.setNull(3, 2004);
        } else {
            stmt.setNull(2, 2004);
            stmt.setBytes(3, data);
        }
        stmt.setInt(4, aMessage.getClassType());
        stmt.setLong(5, destID);
        stmt.setLong(6, aMessage.getJMSTimestamp());
        stmt.setLong(7, aMessage.getJMSExpiration());
        stmt.setInt(8, aMessage.getJMSPriority());
        stmt.setString(9, aMessage.getJMSCorrelationID());
        stmt.setString(10, aMessage.getJMSType());
        stmt.setString(11, aMessage.getJMSMessageID());
        stmt.setLong(12, aMessage.getMessageTimeToLive());
        stmt.setInt(13, msgSize);
        stmt.setBoolean(14, aMessage.isQueueMessage());
        stmt.setInt(15, userDefPropLen);
        if (userDefPropLen > 0 && userDefPropLen <= 512) {
            stmt.setBytes(16, aMessage.getUserDefPropBytes());
        } else {
            stmt.setNull(16, 2004);
        }
        stmt.executeUpdate();
        if (userDefPropLen > 512) {
            UserDefMsgPropTable.createMessageProperties(dbConnection, aMessage);
        }
        MessageCache.insert(aMessage);
    }

    public static int deleteAllMessagesWithoutSendOrder(UserConnection dbConnection) throws SQLException {
        long newMax = ServerOID.getDiffTimeNext(3600L);
        int rowCount = MessageTable.deleteUnusedMessages(dbConnection, 2, newMax);
        return rowCount += MessageTable.deleteUnusedMessages(dbConnection, 1, newMax);
    }

    private static int deleteUnusedMessages(UserConnection dbConnection, int modeDelivery, long maxMessageId) throws SQLException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return 0;
        }
        int rowCount = MessageTable.deleteMessage(dbConnection, modeDelivery, 29, maxMessageId);
        if (!MessageTable.isMessageSavedInMemory(modeDelivery)) {
            UserDefMsgPropTable.deleteAllPropsUpToMsg(dbConnection, modeDelivery, maxMessageId);
        }
        return rowCount;
    }

    static void deleteMessageById(UserConnection dbConnection, int modeDelivery, long messageId, boolean isQueueMessage) throws SQLException {
        int rowCount = MessageTable.deleteMessage(dbConnection, modeDelivery, 27, messageId);
        if (rowCount > 0 && isQueueMessage && !MessageTable.isMessageSavedInMemory(modeDelivery)) {
            UserDefMsgPropTable.deletePropsById(dbConnection, modeDelivery, messageId);
        }
    }

    static void deleteReceivedMessageById(UserConnection dbConnection, int modeDelivery, long messageId, boolean isQueueMessage) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(28, modeDelivery);
        stmt.setLong(1, messageId);
        stmt.setLong(2, messageId);
        int rowCount = stmt.executeUpdate();
        if (rowCount > 0 && isQueueMessage && !MessageTable.isMessageSavedInMemory(modeDelivery)) {
            UserDefMsgPropTable.deleteUnusedPropsById(dbConnection, modeDelivery, messageId);
        }
    }

    private static int deleteMessage(UserConnection dbConnection, int modeDelivery, int stmtIndex, long messageId) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(stmtIndex, modeDelivery);
        stmt.setLong(1, messageId);
        return stmt.executeUpdate();
    }

    public static MessageImpl findByID(UserConnection dbConnection, int modeDelivery, long id) throws SQLException, JMSException {
        MessageImpl aMessage = null;
        if (!MessageTable.isMessageSavedInMemory(modeDelivery) && (aMessage = MessageCache.get(id)) != null) {
            aMessage.setJMSDeliveryMode(modeDelivery);
            return aMessage;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(30, modeDelivery);
        stmt.setLong(1, id);
        DeliveryResultSet row = stmt.executeQuery();
        if (row.next()) {
            if (MessageTable.isMessageSavedInMemory(modeDelivery)) {
                aMessage = (MessageImpl)row.getObject(2);
                if (aMessage != null) {
                    aMessage.setJMSDeliveryMode(modeDelivery);
                }
            } else {
                int msgSize = row.getInt(11);
                byte[] data = msgSize <= 2048 ? row.getBytes(1) : row.getBytes(2);
                aMessage = MessageImpl.newMessageUsingSqlColumns(id, row.getInt(12) == 1, row.getInt(3), msgSize, data);
                aMessage.setJMSDeliveryMode(modeDelivery);
                aMessage.setJMSTimestamp(row.getLong(4));
                aMessage.setJMSExpiration(row.getLong(5));
                aMessage.setJMSPriority(row.getInt(6));
                aMessage.setJMSCorrelationID(row.getString(7));
                aMessage.setJMSType(row.getString(8));
                aMessage.setJMSMessageID(row.getString(9));
                aMessage.setMessageTimeToLive(row.getLong(10));
                if (!aMessage.isQueueMessage()) {
                    MessageCache.insert(aMessage);
                }
            }
        }
        row.close();
        row = null;
        return aMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printMemoryUsedSpace() {
        if (!DBConnectionPool.isTransientMemoryUsed()) {
            return "";
        }
        String prefix = "    Transient memory:   ";
        String ret = "";
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(31, 1);
            DeliveryResultSet result = stmt.executeQuery();
            if (result.next()) {
                long usedSpace = result.getLong(2);
                long maxSpace = result.getLong(3);
                ret = ret + "    Transient memory:   messages    = " + result.getLong(1) + Server.lineSep;
                ret = ret + "    Transient memory:   space       = " + usedSpace / 1024L + "/" + maxSpace / 1024L + " KB" + Server.lineSep;
                if (maxSpace > 0L) {
                    ret = ret + "    Transient memory:   used space  = " + usedSpace / (maxSpace / 100L) + "%" + Server.lineSep;
                }
            }
            result.close();
            result = null;
            stmt = dbConnection.getDeliveryPreparedStmt(60, 1);
            result = stmt.executeQuery();
            if (result.next()) {
                long usedOrders = result.getLong(1);
                long maxOrders = result.getLong(2);
                ret = ret + "    Transient memory:   orders      = " + usedOrders + "/" + maxOrders + Server.lineSep;
                if (maxOrders > 0L) {
                    ret = ret + "    Transient memory:   used orders = " + usedOrders / (maxOrders / 100L) + "%" + Server.lineSep;
                }
            }
            result.close();
            result = null;
        }
        catch (SQLException sQLException) {
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
        return ret;
    }

    private static boolean isMessageSavedInMemory(int modeDelivery) {
        return modeDelivery == 1 && DBConnectionPool.isTransientMemoryUsed();
    }

    public static boolean matches(UserConnection dbConnection, int modeDelivery, long messageID, MsgSelector aMsgSelector) throws SQLException, JMSException {
        MessageImpl msg;
        if (aMsgSelector == null) {
            return true;
        }
        if (aMsgSelector.isEmpty()) {
            return true;
        }
        MessageHeaderFields messageHeader = null;
        MessageProperties msgProperties = null;
        if (MessageTable.isMessageSavedInMemory(modeDelivery)) {
            msg = MessageTable.findByID(dbConnection, modeDelivery, messageID);
            if (msg == null) {
                return false;
            }
            messageHeader = msg.getHeaderFields();
            msgProperties = msg.getPropertyList();
        } else {
            msg = MessageCache.get(messageID);
            if (msg != null) {
                messageHeader = msg.getHeaderFields();
                msgProperties = msg.getPropertyList();
            }
        }
        if (messageHeader == null) {
            DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(32, modeDelivery);
            stmt.setLong(1, messageID);
            DeliveryResultSet row = stmt.executeQuery();
            if (row.next()) {
                messageHeader = new MessageHeaderFields();
                messageHeader.setJMSDeliveryMode(modeDelivery);
                messageHeader.setJMSTimestamp(row.getLong(1));
                messageHeader.setJMSPriority(row.getInt(2));
                messageHeader.setJMSCorrelationID(row.getString(3));
                messageHeader.setJMSType(row.getString(4));
                messageHeader.setJMSMessageID(row.getString(5));
                int userDefPropLen = row.getInt(6);
                if (userDefPropLen > 0) {
                    msgProperties = userDefPropLen <= 512 ? UserDefMsgPropTable.initPropertiesFromColumn(row, 7) : UserDefMsgPropTable.selectProperties(dbConnection, modeDelivery, messageID, userDefPropLen);
                }
                if (msgProperties == null) {
                    msgProperties = new MessageProperties();
                }
                msgProperties.setReadOnly();
            }
            if (row != null) {
                row.close();
            }
            row = null;
        }
        if (messageHeader == null) {
            return false;
        }
        return aMsgSelector.matches(messageHeader, msgProperties);
    }
}

