/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.config;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateMsgServerTables {
    private int m_database = 0;
    private String m_databaseType;
    private String m_url;
    private String m_jdbcDriver;
    private String m_msgServerUsername;
    private String m_msgServerPassword;
    private String m_msgSchema;
    private boolean m_noecho = true;
    private boolean m_lookupAndDestinExists = false;
    private static final int MAXDB = 1;
    private static final int MINDB = 2;
    private static final int TRANSIENT_STORAGE = 3;
    private static final int MAXDB_SQL_ERROR_DUPLICATE_KEY = 200;
    private static final int MAXDB_SQL_ERROR_DUPLICATE_TABLE = -6000;
    private static final int MAXDB_SQL_ERROR_DUPLICATE_NAME = -6006;
    private static final int MAXDB_SQL_ERROR_DUPLICATE_INDEX = -6008;
    private static final int MAXDB_MISSING_PRIVILEGE_DBA = -5001;
    private static final String LSEP = System.getProperty("line.separator");

    public void createTables(String jdbcDriver, String url, String msgServerUsername, String msgServerPassword, String msgSchema) throws SQLException {
        this.m_jdbcDriver = jdbcDriver;
        this.m_url = url;
        this.m_msgServerUsername = msgServerUsername;
        this.m_msgServerPassword = msgServerPassword;
        this.m_msgSchema = msgSchema;
        if (DBConnectionPool.isJDBCDriverMaxDB(this.m_jdbcDriver)) {
            this.m_database = 1;
            this.m_databaseType = "persistent";
        } else if (DBConnectionPool.isJDBCDriverMinDB(this.m_jdbcDriver)) {
            this.m_database = 2;
            this.m_databaseType = "transient";
        } else if (DBConnectionPool.isJDBCDriverTransientStorage(this.m_jdbcDriver)) {
            this.m_database = 3;
            this.m_databaseType = "transient";
        }
        this.createTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables() throws SQLException {
        if (this.m_database == 3) {
            return;
        }
        Connection con = DriverManager.getConnection(this.m_url, "\"" + this.m_msgServerUsername + "\"", "\"" + this.m_msgServerPassword + "\"");
        String cmd = null;
        String uniqueToken = this.m_database == 1 ? " UNIQUE" : "";
        String destinationConstraint = this.m_database == 1 ? "," + LSEP + "   CONSTRAINT msgserver_destination_index UNIQUE (name, is_queue)" : "";
        try {
            Statement stmt = con.createStatement();
            con.setAutoCommit(false);
            if (!this.m_noecho) {
                System.out.println();
            }
            System.out.println("creating " + this.m_databaseType + " tables ...");
            if (!this.m_lookupAndDestinExists) {
                this.m_lookupAndDestinExists = true;
                cmd = "CREATE SCHEMA \"" + this.m_msgSchema + "\"";
                if (!this.m_noecho) {
                    System.out.println(LSEP + cmd);
                }
                this.executeIgnoreError(stmt, cmd);
                cmd = "CREATE TABLE \"" + this.m_msgSchema + "\".jndi_lookup" + LSEP + "  (name    CHAR(100) ASCII NOT NULL," + LSEP + "   content LONG BYTE NOT NULL," + LSEP + "   PRIMARY KEY (name))";
                if (!this.m_noecho) {
                    System.out.println(LSEP + cmd);
                }
                this.executeIgnoreError(stmt, cmd);
                cmd = "CREATE TABLE \"" + this.m_msgSchema + "\". msgserver_destination" + LSEP + "  (id       FIXED(20) NOT NULL," + LSEP + "   name     CHAR (80) ASCII NOT NULL," + LSEP + "   is_queue FIXED (1) NOT NULL," + LSEP + "   PRIMARY KEY (id)" + destinationConstraint + ")";
                if (!this.m_noecho) {
                    System.out.println(LSEP + cmd);
                }
                this.executeIgnoreError(stmt, cmd);
                if (this.m_database != 1) {
                    cmd = "CREATE UNIQUE INDEX \"" + this.m_msgSchema + "\".msgserver_destination_index" + LSEP + "    ON \"" + this.m_msgSchema + "\".msgserver_destination (name, is_queue)";
                    if (!this.m_noecho) {
                        System.out.println(LSEP + cmd);
                    }
                    this.executeIgnoreError(stmt, cmd);
                }
            }
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_consumer" + LSEP + "  (id           FIXED(20) NOT NULL," + LSEP + "   client       CHAR (80) ASCII NOT NULL" + uniqueToken + "," + LSEP + "   destination  FIXED(20) NOT NULL," + LSEP + "   type         INTEGER   NOT NULL," + LSEP + "   state        INTEGER," + LSEP + "   subscription CHAR (200)," + LSEP + "   msgSelector  CHAR(1024)," + LSEP + "   nolocal      FIXED(1)," + LSEP + "   PRIMARY KEY (id))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_message" + LSEP + "  (id               FIXED(20) NOT NULL," + LSEP + "   small_message    VARCHAR(2048) BYTE," + LSEP + "   big_message      LONG BYTE," + LSEP + "   messageType      INTEGER   NOT NULL," + LSEP + "   destination      FIXED(20) NOT NULL," + LSEP + "   jmsTimestamp     FIXED(20)," + LSEP + "   jmsExpiration    FIXED(20)," + LSEP + "   jmsPriority      INTEGER," + LSEP + "   jmsCorrelationId VARCHAR(256)," + LSEP + "   jmsType          VARCHAR(256)," + LSEP + "   jmsMessageId     VARCHAR(256)," + LSEP + "   timeToLive       FIXED(20)," + LSEP + "   msgLength        FIXED(20)," + LSEP + "   is_queue_msg     FIXED (1)," + LSEP + "   userDefPropLen   INTEGER," + LSEP + "   small_properties VARCHAR(512) BYTE," + LSEP + "   PRIMARY KEY (id))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_msgproperties" + LSEP + "  (messageId         FIXED(20) NOT NULL," + LSEP + "   medium_properties VARCHAR(2048) BYTE," + LSEP + "   big_properties    LONG BYTE," + LSEP + "   PRIMARY KEY (messageId))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_sendorder" + LSEP + "  (message               FIXED(20) NOT NULL," + LSEP + "   topic_consumer        FIXED(20) NOT NULL," + LSEP + "   consumer              FIXED(20) NOT NULL," + LSEP + "   destination           FIXED(20) NOT NULL," + LSEP + "   trans_sequence        FIXED(20) NOT NULL," + LSEP + "   msg_sequence          FIXED(20) NOT NULL," + LSEP + "   is_queueOrder         FIXED (1) NOT NULL," + LSEP + "   is_inProcess          FIXED (1) NOT NULL," + LSEP + "   is_delivered          FIXED (1) NOT NULL," + LSEP + "   msgserver_transaction FIXED(20) NOT NULL," + LSEP + "   priority              INTEGER   NOT NULL," + LSEP + "   expires               FIXED(20) NOT NULL," + LSEP + "   has_active_consumer   FIXED (1) NOT NULL," + LSEP + " PRIMARY KEY (message, topic_consumer))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_transactions" + LSEP + "  (message               FIXED(20) NOT NULL," + LSEP + "   consumer              FIXED(20) NOT NULL," + LSEP + "   destination           FIXED(20) NOT NULL," + LSEP + "   is_queueOrder         FIXED (1) NOT NULL," + LSEP + "   msgserver_transaction FIXED(20) NOT NULL," + LSEP + "   priority              INTEGER   NOT NULL," + LSEP + "   expires               FIXED(20) NOT NULL," + LSEP + "   PRIMARY KEY (message, consumer))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_dest_auth" + LSEP + "  (dest_id               FIXED(20) NOT NULL," + LSEP + "   dest_user             VARCHAR(128) NOT NULL," + LSEP + "   dest_password         VARCHAR(128) NOT NULL," + LSEP + "   dest_read             FIXED (1) NOT NULL," + LSEP + "   PRIMARY KEY (dest_id, dest_user,dest_password,dest_read))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            cmd = "CREATE TABLE  \"" + this.m_msgSchema + "\".msgserver_tables_version" + LSEP + "   (table_name            CHAR(255) NOT NULL," + LSEP + "   version               CHAR(16) NOT NULL," + LSEP + "   PRIMARY KEY (table_name))";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('jndi_lookup', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_DESTINATION', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_CONSUMER', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_MESSAGE', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_MSGPROPERTIES', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_SENDORDER', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_TRANSACTIONS', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_DEST_AUTH', '" + Server.getVersion() + "')");
            this.executeIgnoreError(stmt, "INSERT INTO \"" + this.m_msgSchema + "\".msgserver_tables_version VALUES ('MSGSERVER_TABLES_VERSION', '" + Server.getVersion() + "')");
            cmd = "CREATE INDEX msgserver_sendorder_index ON \"" + this.m_msgSchema + "\".msgserver_sendorder" + LSEP + "  (priority       DESC," + LSEP + "   trans_sequence ASC," + LSEP + "   msg_sequence   ASC," + LSEP + "   message        ASC)";
            if (!this.m_noecho) {
                System.out.println(LSEP + cmd);
            }
            this.executeIgnoreError(stmt, cmd);
            if (this.m_database == 1) {
                cmd = "CREATE SEQUENCE \"" + this.m_msgSchema + "\".msgserver_seq increment by 1 minvalue 1 maxvalue 9223372036853 nocycle";
                if (!this.m_noecho) {
                    System.out.println(LSEP + cmd);
                }
                this.executeIgnoreError(stmt, cmd);
            }
            con.commit();
            System.out.println("... tables created.");
        }
        finally {
            con.close();
        }
    }

    private void executeIgnoreError(Statement stmt, String cmd) {
        block2: {
            try {
                stmt.execute(cmd);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -6000 || e.getErrorCode() == 200 || e.getErrorCode() == -6006 || e.getErrorCode() == -6008 || e.getErrorCode() == -5001) break block2;
                System.out.println(e.toString());
                System.out.println();
            }
        }
    }
}

