/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.MessageProducerImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.util.DeliveryModeImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class TopicPublisherImpl
extends MessageProducerImpl
implements TopicPublisher {
    public TopicPublisherImpl(Topic topic, SessionImpl session) {
        super(session);
        this.myTopic = topic;
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    public void publish(Message message) throws JMSException {
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        ((MessageImpl)message).setMessageTimeToLive(this.getTimeToLive());
        this.publishInternal((MessageImpl)message, this.myTopic);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPriority(priority);
        this.checkTimeToLive(timeToLive);
        DeliveryModeImpl.checkModeThrowJMSException(deliveryMode);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        ((MessageImpl)message).setMessageTimeToLive(timeToLive);
        this.publishInternal((MessageImpl)message, this.myTopic);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        ((MessageImpl)message).setMessageTimeToLive(this.getTimeToLive());
        this.publishInternal((MessageImpl)message, topic);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPriority(priority);
        this.checkTimeToLive(timeToLive);
        DeliveryModeImpl.checkModeThrowJMSException(deliveryMode);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        ((MessageImpl)message).setMessageTimeToLive(timeToLive);
        this.publishInternal((MessageImpl)message, topic);
    }
}

