/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.client.TopicBrowserEnumeration;
import com.sap.sdb.msgServer.util.BrowserNotification;
import com.sap.sdb.msgServer.util.BrowserRegNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;

public class TopicBrowserImpl {
    private SessionImpl mySession;
    private Topic myTopic;
    private TopicBrowserEnumeration myEnumeration;
    private long myLastMessageID;
    private String myMsgSelector;
    private long myID;

    public TopicBrowserImpl(Topic topic, SessionImpl session, String msgSelector) throws JMSException {
        this.myTopic = topic;
        this.mySession = session;
        this.myEnumeration = new TopicBrowserEnumeration(this);
        this.myLastMessageID = -1L;
        this.myMsgSelector = msgSelector;
        this.myID = ClientOID.getNext();
        BrowserRegNotification aQBReg = new BrowserRegNotification(true, this.myID, msgSelector);
        try {
            this.mySession.getNetworkHandler().requestOK(aQBReg);
        }
        catch (NotificationException ex) {
            throw new JMSException("Could not register TopicBrowser");
        }
        catch (InterruptedException ex) {
            throw new JMSException("Could not register TopicBrowser");
        }
    }

    public void close() throws JMSException {
        this.myEnumeration = null;
        BrowserRegNotification aQBReg = new BrowserRegNotification(false, this.myID, this.myMsgSelector);
        try {
            this.mySession.getNetworkHandler().requestOK(aQBReg);
        }
        catch (NotificationException ex) {
            throw new JMSException("Could not register TopicBrowser");
        }
        catch (InterruptedException ex) {
            throw new JMSException("Could not register TopicBrowser");
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        this.myLastMessageID = -1L;
        return this.myEnumeration;
    }

    public String getMessageSelector() throws JMSException {
        return this.myMsgSelector;
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    protected Message getNextMessage() {
        try {
            BrowserNotification command = new BrowserNotification(this.myTopic.getTopicName(), this.myLastMessageID, this.myID, 1);
            MessageImpl aMessage = this.mySession.getNetworkHandler().requestMessageForBrowser(command);
            if (aMessage != null) {
                this.myLastMessageID = aMessage.getMessageID();
            }
            return aMessage;
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        catch (NotificationException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

