/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.util.DeliveryModeImpl;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Topic;

public class MessageProducerImpl
implements MessageProducer {
    protected Queue myQueue = null;
    protected Topic myTopic = null;
    protected SessionImpl mySession;
    private int myDeliveryMode = 2;
    private int myPriority = 0;
    private long myTimeToLive = 0L;
    private Vector myMessageNotFreelist;

    protected MessageProducerImpl(SessionImpl session) {
        this.mySession = session;
        this.myMessageNotFreelist = new Vector(100);
    }

    public void close() throws JMSException {
        this.mySession.removeMessageProducer(this);
    }

    public int getDeliveryMode() throws JMSException {
        return this.myDeliveryMode;
    }

    public boolean getDisableMessageID() throws JMSException {
        return false;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return false;
    }

    public int getPriority() throws JMSException {
        return this.myPriority;
    }

    public long getTimeToLive() throws JMSException {
        return this.myTimeToLive;
    }

    public void setDeliveryMode(int value) throws JMSException {
        DeliveryModeImpl.checkModeThrowJMSException(value);
        this.myDeliveryMode = value;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        throw new JMSException("Feature not supported: Messages will always receive a Message ID");
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        throw new JMSException("Feature not supported: Messages will always receive a timestamp");
    }

    public void setPriority(int value) throws JMSException {
        this.checkPriority(value);
        this.myPriority = value;
    }

    public void setTimeToLive(long value) throws JMSException {
        this.checkTimeToLive(value);
        this.myTimeToLive = value;
    }

    public SessionImpl getSession() {
        return this.mySession;
    }

    protected void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException("Priority must be a value between 0 and 9");
        }
    }

    protected void checkTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new JMSException("TimeToLive must be greater 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageNotification getMessageNot(int type, MessageImpl message, long transactionID) {
        MessageNotification retval = null;
        Vector vector = this.myMessageNotFreelist;
        synchronized (vector) {
            if (this.myMessageNotFreelist.size() > 0) {
                retval = (MessageNotification)this.myMessageNotFreelist.remove(0);
            }
        }
        if (retval != null) {
            retval.setType(type);
            retval.setTransactionID(transactionID);
            retval.setMessage(message);
        } else {
            retval = new MessageNotification(type, message, transactionID);
        }
        return retval;
    }

    protected void freeMessageNot(MessageNotification not) {
        if (not != null) {
            this.myMessageNotFreelist.add(not);
        }
    }

    public void send(Message message) throws JMSException {
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        ((MessageImpl)message).setMessageTimeToLive(this.getTimeToLive());
        this.sendInternal((MessageImpl)message, this.myQueue);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPriority(priority);
        this.checkTimeToLive(timeToLive);
        DeliveryModeImpl.checkModeThrowJMSException(deliveryMode);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        ((MessageImpl)message).setMessageTimeToLive(timeToLive);
        this.sendInternal((MessageImpl)message, this.myQueue);
    }

    public void send(Destination dest, Message message) throws JMSException {
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        ((MessageImpl)message).setMessageTimeToLive(this.getTimeToLive());
        if (!(dest instanceof Queue)) {
            throw new JMSException("MessageProducer can only send to Queues");
        }
        this.sendInternal((MessageImpl)message, (Queue)dest);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPriority(priority);
        this.checkTimeToLive(timeToLive);
        DeliveryModeImpl.checkModeThrowJMSException(deliveryMode);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        ((MessageImpl)message).setMessageTimeToLive(timeToLive);
        if (dest instanceof Queue) {
            this.sendInternal((MessageImpl)message, (Queue)dest);
        } else {
            this.publishInternal((MessageImpl)message, (Topic)dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(MessageImpl message, Queue queue) throws JMSException {
        if (queue == null) {
            throw new JMSException("Invalid Queue");
        }
        this.checkQueueMessageType(message);
        SessionImpl sessionImpl = this.getSession();
        synchronized (sessionImpl) {
            int type = -1;
            message.setJMSDestination((Destination)queue);
            if (this.mySession.getTransacted()) {
                this.mySession.incrSentTransactionMsg(message.getJMSDeliveryMode());
                type = 0;
            } else if (this.getSession().isImmediateSendAcknowledge()) {
                type = 1;
            } else {
                throw new JMSException("Could not set notification type. Please check session transaction type.");
            }
            MessageNotification notification = this.getMessageNot(type, message, this.mySession.getTransactionID());
            try {
                this.mySession.getNetworkHandler().requestOK(notification);
            }
            catch (NotificationException ex) {
                throw new JMSException("Unable to send a message to the server: " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                throw new JMSException("Unable to send a message to the server: " + ex);
            }
            finally {
                this.freeMessageNot(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishInternal(MessageImpl message, Topic topic) throws JMSException {
        this.checkTopicMessageType(message);
        SessionImpl sessionImpl = this.getSession();
        synchronized (sessionImpl) {
            int type = -1;
            message.setJMSDestination((Destination)topic);
            if (this.getSession().getTransacted()) {
                this.mySession.incrSentTransactionMsg(message.getJMSDeliveryMode());
                type = 2;
            } else if (this.getSession().isImmediateSendAcknowledge()) {
                type = 3;
            } else {
                throw new JMSException("Could not set notification type. Please check session transaction type.");
            }
            MessageNotification notification = this.getMessageNot(type, message, this.mySession.getTransactionID());
            try {
                this.mySession.getNetworkHandler().requestOK(notification);
            }
            catch (NotificationException ex) {
                throw new JMSException("Unable to publish a message to the server:" + ex);
            }
            catch (InterruptedException ex) {
                throw new JMSException("Unable to publish a message to the server:" + ex);
            }
            finally {
                this.freeMessageNot(notification);
            }
        }
    }

    private void checkQueueMessageType(MessageImpl message) throws JMSException {
        if (!message.isQueueMessage()) {
            throw new JMSException("Sending topic message on queue sender not allowed");
        }
    }

    private void checkTopicMessageType(MessageImpl message) throws JMSException {
        if (message.isQueueMessage()) {
            throw new JMSException("Sending queue message on topic publisher not allowed");
        }
    }

    public Destination getDestination() throws JMSException {
        if (this.myQueue != null) {
            return this.myQueue;
        }
        if (this.myTopic != null) {
            return this.myTopic;
        }
        return null;
    }
}

