/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.util.DeliveryModeImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class MessageHeaderFields {
    private boolean myJMSRedelivered = false;
    private int myJMSDeliveryMode = 2;
    private int myJMSPriority = 0;
    private long myJMSExpiration = 0L;
    private long myJMSTimestamp = 0L;
    private StreamString myJMSMessageID = null;
    private StreamString myJMSCorrelationID = null;
    private StreamString myJMSType = null;

    public String getJMSCorrelationID() {
        return StreamString.getString(this.myJMSCorrelationID);
    }

    public int getJMSDeliveryMode() {
        return this.myJMSDeliveryMode;
    }

    public long getJMSExpiration() {
        return this.myJMSExpiration;
    }

    public String getJMSMessageID() {
        return StreamString.getString(this.myJMSMessageID);
    }

    public int getJMSPriority() {
        return this.myJMSPriority;
    }

    public boolean getJMSRedelivered() {
        return this.myJMSRedelivered;
    }

    public long getJMSTimestamp() {
        return this.myJMSTimestamp;
    }

    public String getJMSType() {
        return StreamString.getString(this.myJMSType);
    }

    public void setJMSCorrelationID(String correlationId) {
        this.myJMSCorrelationID = StreamString.create(correlationId);
    }

    public void setJMSDeliveryMode(int value) {
        if (DeliveryModeImpl.isValid(value)) {
            this.myJMSDeliveryMode = value;
        }
    }

    public void setJMSExpiration(long expiration) {
        this.myJMSExpiration = expiration;
    }

    public void setJMSMessageID(String id) {
        this.myJMSMessageID = StreamString.create(id);
    }

    public void setJMSPriority(int priority) {
        this.myJMSPriority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.myJMSRedelivered = redelivered;
    }

    public void setJMSTimestamp(long timestamp) {
        this.myJMSTimestamp = timestamp;
    }

    public void setJMSType(String type) {
        this.myJMSType = StreamString.create(type);
    }

    int getWriteToStreamLength() {
        return 25 + SendStream.getStreamStringLength(this.myJMSMessageID) + SendStream.getStreamStringLength(this.myJMSCorrelationID) + SendStream.getStreamStringLength(this.myJMSType);
    }

    void readFromStream(ReceiveStream in) throws IOException {
        this.myJMSRedelivered = in.readBoolean();
        this.myJMSDeliveryMode = in.readInt();
        this.myJMSPriority = in.readInt();
        this.myJMSExpiration = in.readLong();
        this.myJMSTimestamp = in.readLong();
        this.myJMSMessageID = in.readStreamString();
        this.myJMSCorrelationID = in.readStreamString();
        this.myJMSType = in.readStreamString();
    }

    void writeToStream(SendStream out) throws IOException {
        this.writeToStream(out, this.myJMSRedelivered);
    }

    void writeToStream(SendStream out, boolean redelivered) throws IOException {
        out.writeBoolean(redelivered);
        out.writeInt(this.myJMSDeliveryMode);
        out.writeInt(this.myJMSPriority);
        out.writeLong(this.myJMSExpiration);
        out.writeLong(this.myJMSTimestamp);
        out.writeStreamString(this.myJMSMessageID);
        out.writeStreamString(this.myJMSCorrelationID);
        out.writeStreamString(this.myJMSType);
    }
}

