/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private Hashtable myObjects = new Hashtable();

    public MapMessageImpl() {
        super(2);
    }

    public MapMessageImpl(long messageID, boolean isQueueMessage) {
        super(messageID, isQueueMessage, 2);
    }

    public void clearBody() throws JMSException {
        this.setReadWrite();
        this.myObjects.clear();
    }

    public boolean getBoolean(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        if (data instanceof String) {
            return Boolean.valueOf((String)data);
        }
        if (data == null) {
            return Boolean.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to boolean not possible");
    }

    public byte getByte(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Byte) {
            return (Byte)data;
        }
        if (data instanceof String) {
            return Byte.parseByte((String)data);
        }
        if (data == null) {
            return Byte.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to byte not possible");
    }

    public byte[] getBytes(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to byte[] not possible");
    }

    public char getChar(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Character) {
            return ((Character)data).charValue();
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to char not possible");
    }

    public double getDouble(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Double) {
            return (Double)data;
        }
        if (data instanceof Float) {
            return ((Float)data).doubleValue();
        }
        if (data instanceof String) {
            return Double.parseDouble((String)data);
        }
        if (data == null) {
            return Double.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to double not possible");
    }

    public float getFloat(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Float) {
            return ((Float)data).floatValue();
        }
        if (data instanceof String) {
            return Float.parseFloat((String)data);
        }
        if (data == null) {
            return Float.valueOf((String)data).floatValue();
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to float not possible");
    }

    public int getInt(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue();
        }
        if (data instanceof Byte) {
            return ((Byte)data).intValue();
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        if (data == null) {
            return Integer.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to int not possible");
    }

    public long getLong(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Long) {
            return (Long)data;
        }
        if (data instanceof Integer) {
            return ((Integer)data).longValue();
        }
        if (data instanceof Short) {
            return ((Short)data).longValue();
        }
        if (data instanceof Byte) {
            return ((Byte)data).longValue();
        }
        if (data instanceof String) {
            return Long.parseLong((String)data);
        }
        if (data == null) {
            return Long.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to long not possible");
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.myObjects.keySet());
    }

    public Object getObject(String name) throws JMSException {
        return this.myObjects.get(name);
    }

    public short getShort(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof Short) {
            return (Short)data;
        }
        if (data instanceof String) {
            return Short.parseShort((String)data);
        }
        if (data instanceof Byte) {
            return ((Byte)data).shortValue();
        }
        if (data == null) {
            return Short.valueOf((String)data);
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to long not possible");
    }

    public String getString(String name) throws JMSException {
        Object data = this.myObjects.get(name);
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Boolean) {
            return ((Boolean)data).toString();
        }
        if (data instanceof Short) {
            return ((Short)data).toString();
        }
        if (data instanceof Character) {
            return ((Character)data).toString();
        }
        if (data instanceof Double) {
            return ((Double)data).toString();
        }
        if (data instanceof Float) {
            return ((Float)data).toString();
        }
        if (data instanceof Long) {
            return ((Long)data).toString();
        }
        if (data instanceof Integer) {
            return ((Integer)data).toString();
        }
        if (data instanceof Byte) {
            return ((Byte)data).toString();
        }
        throw new MessageFormatException("Conversion from " + data.getClass().getName() + " to String not possible");
    }

    public boolean itemExists(String name) throws JMSException {
        return this.myObjects.get(name) != null;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Byte(value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkForWrite();
        if (value.length < offset + length) {
            throw new JMSException("byte[] buffer: offset or length invalid");
        }
        byte[] buf = new byte[length];
        System.arraycopy(value, offset, buf, 0, length);
        this.myObjects.put(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Character(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Double(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Float(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Long(value));
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, new Short(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.checkForWrite();
        this.myObjects.put(name, value);
    }

    void readMessageContentsFromStream(ReceiveStream in) throws IOException {
        this.myObjects = in.readHashtable();
    }

    void writeMessageContentsToStream(SendStream out) throws IOException {
        out.writeHashtable(this.myObjects);
    }
}

