/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import java.sql.SQLException;

public class GarbageCollector
extends JmsThread {
    long myGarbageCollectingTime;

    public GarbageCollector(JmsService service, long garbageCollectingTime) throws ServiceException {
        super(service, "GarbageCollector");
        this.myGarbageCollectingTime = garbageCollectingTime;
    }

    public void cleanUp(UserConnection dbConnection) throws ServiceException {
        this.cleanUp(dbConnection, 2);
        this.cleanUp(dbConnection, 1);
    }

    private void cleanUp(UserConnection dbConnection, int modeDelivery) throws ServiceException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return;
        }
        try {
            this.log("- Garbage Collector ----------------------------------------");
            int rowsDeleted = SendOrderTable.deleteExpiredOrders(dbConnection, modeDelivery, JmsService.getTimeStamp());
            this.log("    Deleted expired Orders:                 " + rowsDeleted);
            dbConnection.commit();
            rowsDeleted = SendOrderTable.deleteAllOrdersWithoutTopicConsumers(dbConnection, modeDelivery);
            this.log("    Deleted Orders without Topic Consumers: " + rowsDeleted);
            dbConnection.commit();
            rowsDeleted = MessageTable.deleteAllMessagesWithoutSendOrder(dbConnection);
            this.log("    Deleted Messages without SendOrder:     " + rowsDeleted);
            dbConnection.commit();
            this.log("------------------------------------------------------------");
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new ServiceException("GarbageCollector:cleanUp", ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws Exception {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            this.cleanUp(dbConnection);
            super.performSleep(this.myGarbageCollectingTime);
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    public void setGarbageCollectingTime(long garbageCollectingTime) {
        this.myGarbageCollectingTime = garbageCollectingTime;
        this.interrupt();
    }

    public long getGarbageCollectingTime() {
        return this.myGarbageCollectingTime;
    }
}

