/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccess.ConnectionImpl;
import com.sap.sdb.minDB.dataAccess.DeleteLogentry;
import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.IndexTable;
import com.sap.sdb.minDB.dataAccess.InsertLogentry;
import com.sap.sdb.minDB.dataAccess.Logentry;
import com.sap.sdb.minDB.dataAccess.MultiCharKey;
import com.sap.sdb.minDB.dataAccess.MultiColKey;
import com.sap.sdb.minDB.dataAccess.MultiNumKey;
import com.sap.sdb.minDB.dataAccess.PrimaryCharKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumNumKey;
import com.sap.sdb.minDB.dataAccess.TableName;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccess.UpdateLogentry;
import com.sap.sdb.minDB.dataAccessInterface.ConnectionHandle;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseLogentry;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTable;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTableRow;
import com.sap.sdb.minDB.dataAccessInterface.TableTrigger;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Table
implements DatabaseTable {
    private int m_tableType;
    private int m_primKeyType;
    private int m_maxNumericColNo;
    private int m_maxObjectColNo;
    private int m_tableFileSeq;
    private long m_sysKey;
    private byte[] m_colTypeList;
    private int[] m_keyColNoList;
    private int[] m_keyColNoOfRowNo;
    private String[] m_colNameList;
    private Hashtable m_colNameMap;
    private TableName m_tableName;
    private TreeMap m_tree;
    private Hashtable m_indexTabByName = null;
    private Hashtable m_indexTabByNumber = null;
    private LinkedList m_uniqueIndex = null;
    private TableTrigger[] m_trigger = null;
    private File m_schemaFolder = null;
    private boolean m_isUpdated = false;
    private boolean m_unloaded = false;
    private boolean m_insTriggerExists = false;
    private static final int KEY_TYPE_NONE = 0;
    private static final int NUM_KEY = 1;
    private static final int CHAR_KEY = 2;
    private static final int NUM_NUM_KEY = 3;
    private static final int MULTI_NUM_KEY = 4;
    private static final int MULTI_CHAR_KEY = 5;
    private static final int MULTI_COL_KEY = 6;
    private static final int TAB_READ_ONLY = 0;
    private static final int TAB_READ_WRITE = 1;
    private static final int TABLE_BACKUP_VERSION = -606348541;
    private static final int TABLE_PERSISTENT_VERSION = -606361085;
    private static final String TABLE_FILE_EXTENSION = ".tab";
    private static final String AUX_FILE_PREFIX = "~";
    private static final DatabaseLogentry DUMMY_LOGENTRY = new Logentry();

    private Table() {
        this.m_tree = new TreeMap();
    }

    public Table(TableName tabname, LinkedList columnNameList, LinkedList columnTypeList, LinkedList keyColumnNames) throws SQLException {
        this.m_primKeyType = 0;
        this.m_tableType = 1;
        this.m_maxNumericColNo = 0;
        this.m_maxObjectColNo = 0;
        this.m_tableFileSeq = 0;
        this.m_sysKey = 0L;
        this.m_keyColNoList = null;
        this.m_keyColNoOfRowNo = null;
        this.m_tableName = tabname;
        this.m_tree = new TreeMap();
        this.m_colNameMap = new Hashtable();
        this.m_colNameList = new String[columnNameList.size() + 1];
        this.m_colTypeList = new byte[columnNameList.size() + 1];
        this.m_colTypeList[0] = 0;
        Iterator colNameIter = columnNameList.iterator();
        Iterator colTypeIter = columnTypeList.iterator();
        int colNo = 0;
        while (colNameIter.hasNext()) {
            this.m_colNameList[++colNo] = (String)colNameIter.next();
            this.m_colNameMap.put(this.m_colNameList[colNo], new Integer(colNo));
            this.m_colTypeList[colNo] = (Byte)colTypeIter.next();
            if (this.m_colTypeList[colNo] == 4) {
                this.m_maxNumericColNo = colNo;
                continue;
            }
            this.m_maxObjectColNo = colNo;
        }
        if (keyColumnNames != null) {
            this.createKeyMetaData(keyColumnNames);
            return;
        }
        this.m_primKeyType = 1;
        this.m_colTypeList[0] = 4;
        this.m_keyColNoList = new int[2];
        this.m_keyColNoList[0] = -1;
        this.m_keyColNoList[1] = 0;
        this.m_keyColNoOfRowNo = new int[this.m_colTypeList.length];
        Arrays.fill(this.m_keyColNoOfRowNo, -1);
        this.m_keyColNoOfRowNo[0] = 1;
        if (this.m_maxNumericColNo < 1) {
            this.m_maxNumericColNo = 1;
        }
    }

    public synchronized void addTrigger(int triggerType, TableTrigger trigger) throws SQLException {
        if (this.m_trigger == null) {
            this.m_trigger = new TableTrigger[3];
        }
        if (this.m_trigger[triggerType] != null) {
            throw ErrorMsg.newSQLException("Duplicate trigger", -3008);
        }
        this.m_trigger[triggerType] = trigger;
        if (triggerType == 1) {
            this.m_insTriggerExists = true;
        }
    }

    private void addUniqueIndex(IndexTable index) {
        if (this.m_uniqueIndex == null) {
            this.m_uniqueIndex = new LinkedList();
        }
        this.m_uniqueIndex.add(index);
    }

    public void checkLoaded() throws SQLException {
        if (this.m_unloaded) {
            throw ErrorMsg.newSQLException("Table " + this.m_tableName.toString() + " is unloaded", -4004);
        }
    }

    public boolean containsColumn(String colName) {
        return this.m_colNameMap.containsKey(colName);
    }

    static Table createFromStream(DatabaseInputStream inStream, boolean loadContent) throws IOException {
        int version = inStream.readInt();
        if (version != -606348541) {
            throw new IOException("Wrong table version " + version + " (required version: " + -606348541 + ")");
        }
        Table tab = new Table();
        tab.readFromStream(inStream, loadContent);
        return tab;
    }

    public void createIndex(String indexName, boolean isUnique, LinkedList indexColumnNames, LinkedList isAscending) throws SQLException {
        int newIndexNo = 1;
        if (this.m_indexTabByName != null) {
            if (this.m_indexTabByName.containsKey(indexName)) {
                throw ErrorMsg.newSQLException("Duplicate index name '" + indexName + "'", -6008);
            }
            newIndexNo = -1;
            for (int currNo = 1; currNo <= this.m_indexTabByNumber.size(); ++currNo) {
                if (this.m_indexTabByNumber.containsKey(new Integer(currNo))) continue;
                newIndexNo = currNo;
                break;
            }
            if (newIndexNo == -1) {
                newIndexNo = this.m_indexTabByNumber.size() + 1;
            }
        }
        IndexTable newIndexTab = new IndexTable(this, indexName, newIndexNo, isUnique, indexColumnNames, isAscending);
        Iterator iter = this.getIterator();
        while (iter.hasNext()) {
            TableRow currRow = (TableRow)iter.next();
            if (isUnique) {
                IndexKey indexKey = newIndexTab.checkUniqueGetKey(currRow);
                currRow.setIndexKey(newIndexNo, indexKey);
            }
            newIndexTab.insertIndexRow(currRow);
        }
        if (this.m_indexTabByName == null) {
            this.m_indexTabByName = new Hashtable();
            this.m_indexTabByNumber = new Hashtable();
        }
        this.m_indexTabByName.put(indexName, newIndexTab);
        this.m_indexTabByNumber.put(new Integer(newIndexNo), newIndexTab);
        if (isUnique) {
            this.addUniqueIndex(newIndexTab);
        }
    }

    private void createKeyMetaData(LinkedList keyColumnNames) throws SQLException {
        this.m_keyColNoList = new int[keyColumnNames.size() + 1];
        this.m_keyColNoOfRowNo = new int[this.m_colTypeList.length];
        Arrays.fill(this.m_keyColNoOfRowNo, -1);
        boolean charFound = false;
        boolean numFound = false;
        boolean objFound = false;
        Iterator iter = keyColumnNames.iterator();
        int keyCol = 0;
        block4: while (iter.hasNext()) {
            this.m_keyColNoList[++keyCol] = this.getColumnNo((String)iter.next());
            this.m_keyColNoOfRowNo[this.m_keyColNoList[keyCol]] = keyCol;
            byte colType = this.getColumnType(this.m_keyColNoList[keyCol]);
            switch (colType) {
                case 4: {
                    numFound = true;
                    continue block4;
                }
                case 2: {
                    charFound = true;
                    continue block4;
                }
            }
            objFound = true;
        }
        this.m_primKeyType = 6;
        if (objFound) {
            return;
        }
        if (keyCol == 1) {
            this.m_primKeyType = numFound ? 1 : 2;
        } else if (!charFound) {
            this.m_primKeyType = keyCol == 2 ? 3 : 4;
        } else if (!numFound) {
            this.m_primKeyType = 5;
        }
    }

    public void deleteRowIndexEntries(DatabaseTableRow row) {
        Enumeration iter = this.getIndexTableIterator();
        if (iter == null) {
            return;
        }
        while (iter.hasMoreElements()) {
            IndexTable currIndex = (IndexTable)iter.nextElement();
            currIndex.removeIndexRow(row.getKey(currIndex.getIndexNumber()));
        }
    }

    public void dropIndex(String indexName) throws SQLException {
        if (!this.existsIndex()) {
            return;
        }
        IndexTable indexTab = (IndexTable)this.m_indexTabByName.get(indexName);
        if (indexTab == null) {
            throw ErrorMsg.newSQLException("Unknown index name '" + indexName + "'", -4004);
        }
        if (indexTab.isUnique()) {
            this.m_uniqueIndex.remove(indexTab);
            if (this.m_uniqueIndex.size() <= 0) {
                this.m_uniqueIndex = null;
            }
        }
        this.m_indexTabByName.remove(indexName);
        this.m_indexTabByNumber.remove(new Integer(indexTab.getIndexNumber()));
        if (this.m_indexTabByName.size() <= 0) {
            this.m_indexTabByName = null;
            this.m_indexTabByNumber = null;
        }
    }

    public synchronized void dropTrigger(int triggerType) throws SQLException {
        if (this.m_trigger == null || this.m_trigger[triggerType] == null) {
            throw ErrorMsg.newSQLException("Trigger not found", -4001);
        }
        this.m_trigger[triggerType] = null;
        if (this.m_trigger[0] == null && this.m_trigger[1] == null && this.m_trigger[2] == null) {
            this.m_trigger = null;
        }
        if (triggerType == 1) {
            this.m_insTriggerExists = false;
        }
    }

    public synchronized void ensureTableIsLoaded() throws SQLException {
        if (!this.m_unloaded) {
            return;
        }
        File tableFile = this.getTableFile(false);
        if (this.m_schemaFolder == null || !tableFile.exists()) {
            this.m_unloaded = false;
            return;
        }
        try {
            this.readContentFromFile(tableFile);
            Enumeration indexIter = this.getIndexTableIterator();
            if (indexIter != null) {
                while (indexIter.hasMoreElements()) {
                    IndexTable indexTab = (IndexTable)indexIter.nextElement();
                    this.recreateIndex(indexTab);
                }
            }
            this.m_unloaded = false;
        }
        catch (IOException ex) {
            this.m_tree.clear();
            throw ErrorMsg.newSQLException(ex, -903);
        }
    }

    public boolean existsIndex() {
        return this.m_indexTabByName == null ? false : this.m_indexTabByName.size() > 0;
    }

    public DatabaseTableRow findRow(DatabaseKey key) {
        if (key instanceof IndexKey) {
            if (this.m_indexTabByNumber == null) {
                return null;
            }
            Integer indexNo = new Integer(((IndexKey)key).getIndexNo());
            IndexTable indexTab = (IndexTable)this.m_indexTabByNumber.get(indexNo);
            return indexTab == null ? null : indexTab.findIndexRow(key);
        }
        return (DatabaseTableRow)this.m_tree.get(key);
    }

    public String getColumnName(int columnNo) {
        return columnNo > 0 && columnNo < this.m_colNameList.length ? this.m_colNameList[columnNo] : null;
    }

    String[] getColumnNameList() {
        return this.m_colNameList;
    }

    public int getColumnNo(String colName) throws SQLException {
        int colNo = -1;
        Integer colNoObject = (Integer)this.m_colNameMap.get(colName);
        if (colNoObject != null) {
            colNo = colNoObject;
        }
        if (colNo <= 0) {
            throw ErrorMsg.newSQLException("Unknown column name '" + colName + "'", -4005);
        }
        return colNo;
    }

    public byte getColumnType(int columnNo) throws SQLException {
        boolean isOK;
        boolean bl = this.m_colTypeList == null ? false : (isOK = columnNo >= 0 && columnNo <= this.getMaxColNo());
        if (!isOK) {
            throw ErrorMsg.newSQLException("Unknown column type of column number " + columnNo, -4005);
        }
        return this.m_colTypeList[columnNo];
    }

    byte[] getColumnTypeList() {
        return this.m_colTypeList;
    }

    public TableTrigger getDeleteTrigger() {
        return this.m_trigger == null ? null : this.m_trigger[0];
    }

    public String getIndexName(int indexNo) {
        if (this.m_indexTabByNumber == null) {
            return null;
        }
        IndexTable indexTab = (IndexTable)this.m_indexTabByNumber.get(new Integer(indexNo));
        return indexTab == null ? null : indexTab.getIndexName();
    }

    public Enumeration getIndexNamesIterator() {
        return this.m_indexTabByName == null ? null : this.m_indexTabByName.keys();
    }

    public int getIndexTableCount() {
        return this.m_indexTabByName == null ? 0 : this.m_indexTabByName.size();
    }

    public Enumeration getIndexTableIterator() {
        return this.m_indexTabByNumber != null && this.m_indexTabByNumber.size() > 0 ? this.m_indexTabByNumber.elements() : null;
    }

    public TableTrigger getInsertTrigger() {
        return this.m_insTriggerExists ? this.m_trigger[1] : null;
    }

    public Iterator getIterator() {
        return this.m_tree.values().iterator();
    }

    public Iterator getIteratorGreaterEqual(DatabaseKey startKey) {
        if (startKey == null) {
            return this.getIterator();
        }
        if (startKey instanceof IndexKey) {
            if (this.m_indexTabByNumber == null) {
                return this.getIterator();
            }
            Integer indexNo = new Integer(((IndexKey)startKey).getIndexNo());
            IndexTable indexTab = (IndexTable)this.m_indexTabByNumber.get(indexNo);
            return indexTab == null ? this.getIterator() : indexTab.getIndexIteratorGreaterEqual(startKey);
        }
        SortedMap treeTail = this.m_tree.tailMap(startKey);
        return treeTail.values().iterator();
    }

    public int[] getKeyColumnList() {
        return this.m_keyColNoList;
    }

    public int getKeyColumnNo(int rowColNo) {
        return this.m_keyColNoOfRowNo[rowColNo];
    }

    public int getMaxColNo() {
        return this.m_colTypeList.length - 1;
    }

    public int getMaxKeyColumns() {
        return this.m_keyColNoList.length - 1;
    }

    public int getMaxNumericColNo() {
        return this.m_maxNumericColNo;
    }

    public int getMaxObjectColNo() {
        return this.m_maxObjectColNo;
    }

    public DatabaseKey getNewKey() {
        switch (this.m_primKeyType) {
            case 1: {
                return new PrimaryNumKey();
            }
            case 2: {
                return new PrimaryCharKey();
            }
            case 3: {
                return new PrimaryNumNumKey();
            }
            case 4: {
                return new MultiNumKey(this.getMaxKeyColumns());
            }
            case 5: {
                return new MultiCharKey(this.getMaxKeyColumns());
            }
            case 6: {
                return new MultiColKey(this.getMaxKeyColumns());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRow getNewRow() {
        TableRow row = new TableRow(this.m_maxNumericColNo, this.m_maxObjectColNo, this.getNewKey());
        if (this.isSystemKeyDefined()) {
            long keyValue;
            Table table = this;
            synchronized (table) {
                keyValue = this.m_sysKey++;
            }
            row.setNumericCol(0, keyValue);
        }
        return row;
    }

    public TableRow getNewRowCopyParam(DatabaseRow paramRow) throws SQLException {
        TableRow newRow = this.getNewRow();
        if (this.isSystemKeyDefined()) {
            long sysKey = newRow.getNumericCol(0);
            newRow.copyContents(paramRow);
            newRow.setNumericCol(0, sysKey);
        } else {
            newRow.copyContents(paramRow);
        }
        byte[] newRowColTypes = newRow.getColumnTypeList();
        for (int colNo = 1; colNo < this.m_colTypeList.length; ++colNo) {
            if (newRowColTypes[colNo] == 0 || newRowColTypes[colNo] == this.m_colTypeList[colNo]) continue;
            newRow.copyCol(colNo, this.m_colTypeList[colNo], paramRow, colNo);
        }
        return newRow;
    }

    String getRemarks() {
        String info;
        String string = info = this.m_unloaded ? "unloaded" : "number of rows: " + this.m_tree.size();
        if (this.m_trigger != null) {
            for (int i = 0; i < this.m_trigger.length; ++i) {
                if (this.m_trigger[i] == null) continue;
                info = info + "; " + ((Object)this.m_trigger[i]).toString();
            }
        }
        return info;
    }

    public int getRowCount() {
        return this.m_unloaded ? -1 : this.m_tree.size();
    }

    public String getSchemaName() {
        return this.m_tableName.getSchema();
    }

    private File getTableFile(boolean auxFileWanted) {
        if (this.m_schemaFolder == null) {
            return null;
        }
        String filename = this.m_tableName.getIdentifier() + TABLE_FILE_EXTENSION;
        if (auxFileWanted) {
            filename = AUX_FILE_PREFIX + filename;
        }
        return new File(this.m_schemaFolder, filename);
    }

    public String getTableIdentifier() {
        return this.m_tableName.getIdentifier();
    }

    public TableName getTableName() {
        return this.m_tableName;
    }

    public TableTrigger getUpdateTrigger() {
        return this.m_trigger == null ? null : this.m_trigger[2];
    }

    synchronized void initPersistent(File databaseFolder) {
        if (this.m_schemaFolder == null) {
            this.m_schemaFolder = new File(databaseFolder, this.m_tableName.getSchema());
        }
    }

    public void insertRow(ConnectionHandle connection, TableRow row) throws SQLException {
        this.checkLoaded();
        this.m_isUpdated = true;
        if (this.m_primKeyType == 1) {
            row.initNumericKey(this.m_keyColNoList[1]);
        } else {
            row.initKey(this.m_keyColNoList, this.m_colTypeList);
        }
        if (this.m_uniqueIndex != null) {
            Iterator iter = this.m_uniqueIndex.iterator();
            while (iter.hasNext()) {
                IndexTable indexTab = (IndexTable)iter.next();
                IndexKey indexKey = indexTab.checkUniqueGetKey(connection, row);
                row.setIndexKey(indexTab.getIndexNumber(), indexKey);
            }
        }
        if (this.m_tree.get(row.getKey()) != null) {
            throw ErrorMsg.newSQLException("Duplicate key (" + ((Object)row.getKey()).toString() + ") of table " + this.m_tableName.toString(), 200);
        }
        this.m_tree.put(row.getKey(), row);
        this.insertRowIndexEntries(row);
    }

    public void insertRowIndexEntries(DatabaseTableRow row) {
        Enumeration iter = this.getIndexTableIterator();
        if (iter == null) {
            return;
        }
        while (iter.hasMoreElements()) {
            IndexTable currIndex = (IndexTable)iter.nextElement();
            currIndex.insertIndexRow((TableRow)row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseLogentry insertRowWithLogging(ConnectionHandle connection, DatabaseTableRow newRow) throws SQLException {
        newRow.lock(connection);
        ConnectionImpl con = (ConnectionImpl)connection;
        Table table = this;
        synchronized (table) {
            try {
                this.insertRow(connection, (TableRow)newRow);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() != 200) {
                    throw ex;
                }
                TableRow existingRow = (TableRow)this.findRow(newRow.getKey());
                if (existingRow.isLockCollision(connection)) {
                    return null;
                }
                if (!existingRow.isDeleted()) {
                    throw ex;
                }
                UpdateLogentry logentry = new UpdateLogentry(this, existingRow);
                con.addLogentry(logentry);
                this.replaceRow((TableRow)newRow);
                return logentry;
            }
        }
        if (!this.m_insTriggerExists && connection.getAutoCommit()) {
            return DUMMY_LOGENTRY;
        }
        InsertLogentry logentry = new InsertLogentry(this, newRow.getKey());
        con.addLogentry(logentry);
        return logentry;
    }

    public boolean isReadOnly() {
        return this.m_tableType == 0;
    }

    public boolean isSystemKeyDefined() {
        return this.m_keyColNoList[1] == 0;
    }

    public DatabaseLogentry markRowDeletedWithLogging(ConnectionHandle connection, DatabaseTableRow row) {
        this.m_isUpdated = true;
        DeleteLogentry logentry = new DeleteLogentry(this, row.getKey());
        ((ConnectionImpl)connection).addLogentry(logentry);
        ((TableRow)row).setDeleted(true);
        return logentry;
    }

    public void markTableUpdated() {
        this.m_isUpdated = true;
    }

    public synchronized void printContents() {
        Console.println();
        Console.println("===== table " + this.m_tableName.toString() + " (rows: " + this.m_tree.size() + ") =====");
        int rowCount = 0;
        Iterator iter = this.m_tree.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry currEntry = iter.next();
            AnyKey key = (AnyKey)currEntry.getKey();
            TableRow row = (TableRow)currEntry.getValue();
            row.printContents(++rowCount);
            Console.println("      KEY: " + key.toString());
        }
        Console.println();
        Console.println("==== end of " + this.m_tableName.toString() + " =====");
        Console.println();
        Enumeration indexIter = this.getIndexTableIterator();
        if (indexIter != null) {
            while (indexIter.hasMoreElements()) {
                ((IndexTable)indexIter.nextElement()).printContents();
            }
        }
    }

    private synchronized void readContentFromFile(File tableFile) throws IOException {
        if (!tableFile.exists()) {
            return;
        }
        FileInputStream fileStream = new FileInputStream(tableFile);
        DatabaseInputStream inStream = new DatabaseInputStream(fileStream);
        int requiredVersion = -606361085;
        int inputVersion = inStream.readInt();
        this.m_tableFileSeq = inStream.readInt();
        if (inputVersion != requiredVersion) {
            throw new IOException("DBfolder error: wrong file version " + inputVersion + " in " + tableFile.getAbsolutePath() + ", required version: " + requiredVersion);
        }
        TableName inputName = TableName.createFromStream(inStream);
        if (!inputName.equals(this.m_tableName)) {
            throw new IOException("DBfolder error: wrong table name " + inputName.toString() + " in " + tableFile.getAbsolutePath() + ", required name: " + this.m_tableName.toString());
        }
        byte[] inputColTypeList = inStream.readByteArray();
        int[] inputKeyColNoList = inStream.readIntArray();
        if (!Arrays.equals(inputKeyColNoList, this.m_keyColNoList) || !Arrays.equals(inputColTypeList, this.m_colTypeList)) {
            throw new IOException("DBfolder error: catalog mismatch in " + tableFile.getAbsolutePath() + " [table: " + this.m_tableName.toString() + "]");
        }
        this.readPrimaryTree(inStream);
        inputVersion = inStream.readInt();
        fileStream.close();
        if (inputVersion != requiredVersion) {
            throw new IOException("DBfolder error: wrong end-of-file version " + inputVersion + " in " + tableFile.getAbsolutePath() + ", required version: " + requiredVersion);
        }
    }

    private void readFromStream(DatabaseInputStream inStream, boolean loadContent) throws IOException {
        this.m_tableType = inStream.readInt();
        this.m_primKeyType = inStream.readInt();
        this.m_maxNumericColNo = inStream.readInt();
        this.m_maxObjectColNo = inStream.readInt();
        this.m_sysKey = inStream.readLong();
        this.m_colNameList = inStream.readStringArray();
        this.m_colTypeList = inStream.readByteArray();
        this.m_keyColNoList = inStream.readIntArray();
        this.m_keyColNoOfRowNo = inStream.readIntArray();
        this.m_tableName = TableName.createFromStream(inStream);
        this.m_tableFileSeq = 0;
        int triggerCount = inStream.readInt();
        for (int i = 0; i < triggerCount; ++i) {
            if (!inStream.readBoolean()) continue;
            TableTrigger trigger = null;
            try {
                Class<?> triggerHandler = Class.forName("com.sap.sdb.minDB.sql.TriggerHandler");
                trigger = (TableTrigger)triggerHandler.newInstance();
            }
            catch (Exception ex) {
                throw new IOException(ex.toString());
            }
            trigger.readFromStream(inStream, this);
        }
        if (loadContent) {
            this.m_unloaded = false;
            this.m_isUpdated = true;
            this.readPrimaryTree(inStream);
        } else {
            this.m_unloaded = true;
            this.m_isUpdated = false;
        }
        this.readIndexTables(inStream, loadContent);
        this.m_colNameMap = new Hashtable();
        for (int colNo = 1; colNo < this.m_colNameList.length; ++colNo) {
            this.m_colNameMap.put(this.m_colNameList[colNo], new Integer(colNo));
        }
    }

    private void readIndexTables(DatabaseInputStream inStream, boolean loadContent) throws IOException {
        int indexTableCount = inStream.readInt();
        if (indexTableCount <= 0) {
            return;
        }
        this.m_indexTabByName = new Hashtable();
        this.m_indexTabByNumber = new Hashtable();
        for (int i = 0; i < indexTableCount; ++i) {
            IndexTable indexTab = new IndexTable();
            indexTab.readMetaDataFromStream(inStream);
            if (indexTab.isUnique()) {
                this.addUniqueIndex(indexTab);
            }
            this.m_indexTabByName.put(indexTab.getIndexName(), indexTab);
            this.m_indexTabByNumber.put(new Integer(indexTab.getIndexNumber()), indexTab);
            if (!loadContent) continue;
            this.recreateIndex(indexTab);
        }
    }

    private void readPrimaryTree(DatabaseInputStream inStream) throws IOException {
        int rowCount = inStream.readInt();
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = TableRow.createTableRowFromStream(inStream);
            this.m_tree.put(row.getKey(), row);
        }
    }

    private void recreateIndex(IndexTable indexTab) {
        indexTab.removeAllIndexRows();
        Iterator rowIter = this.getIterator();
        while (rowIter.hasNext()) {
            TableRow currRow = (TableRow)rowIter.next();
            indexTab.insertIndexRow(currRow);
        }
    }

    public void removeAll() {
        if (this.m_unloaded) {
            return;
        }
        this.m_isUpdated = true;
        this.m_tree.clear();
        Enumeration iter = this.getIndexTableIterator();
        if (iter == null) {
            return;
        }
        while (iter.hasMoreElements()) {
            IndexTable indexTab = (IndexTable)iter.nextElement();
            indexTab.removeAllIndexRows();
        }
    }

    public DatabaseTableRow removeRow(DatabaseKey key) {
        TableRow row = (TableRow)this.m_tree.remove(key);
        if (row != null) {
            this.m_isUpdated = true;
            if (this.existsIndex()) {
                this.deleteRowIndexEntries(row);
            }
        }
        return row;
    }

    public void replaceRow(TableRow newRow) {
        this.m_isUpdated = true;
        if (!this.existsIndex()) {
            this.m_tree.put(newRow.getKey(), newRow);
            return;
        }
        TableRow oldRow = (TableRow)this.m_tree.get(newRow.getKey());
        this.deleteRowIndexEntries(oldRow);
        oldRow = null;
        this.m_tree.put(newRow.getKey(), newRow);
        this.insertRowIndexEntries(newRow);
    }

    private void rollbackUpdateAfterIndexError(DatabaseLogentry updLogentry, TableRow afterImageRow, IndexTable badIndex) throws SQLException {
        TableRow beforeImageRow = (TableRow)updLogentry.getBeforeImageRow();
        Enumeration iter = this.getIndexTableIterator();
        while (iter.hasMoreElements()) {
            IndexTable currIndex = (IndexTable)iter.nextElement();
            if (currIndex != badIndex) {
                currIndex.removeIndexRow(afterImageRow.getKey(currIndex.getIndexNumber()));
            }
            currIndex.insertIndexRow(beforeImageRow);
            if (currIndex != badIndex) continue;
            break;
        }
        this.m_tree.put(beforeImageRow.getKey(), beforeImageRow);
        ((UpdateLogentry)updLogentry).setIgnoreRollback();
    }

    public void setReadOnly(boolean readOnly) {
        this.m_tableType = readOnly ? 0 : 1;
    }

    void setTableName(TableName tabname) throws SQLException {
        block5: {
            if (this.m_schemaFolder == null) {
                this.m_tableName = tabname;
                return;
            }
            try {
                boolean isUnloaded = this.m_unloaded;
                this.ensureTableIsLoaded();
                TableName oldName = this.m_tableName;
                File oldFile = this.getTableFile(false);
                File oldAuxFile = this.getTableFile(true);
                this.m_tableName = tabname;
                oldAuxFile.delete();
                if (!oldFile.renameTo(oldAuxFile)) break block5;
                try {
                    this.writeContentIntoFile(isUnloaded);
                }
                catch (Exception ex) {
                    File newFile = this.getTableFile(false);
                    newFile.delete();
                    oldAuxFile.renameTo(oldFile);
                    this.m_tableName = oldName;
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw ErrorMsg.newSQLException(ex, -903);
            }
        }
    }

    public DatabaseLogentry updateLogging(ConnectionHandle connection, DatabaseTableRow row) {
        this.m_isUpdated = true;
        UpdateLogentry logentry = new UpdateLogentry(this, (TableRow)row);
        ((ConnectionImpl)connection).addLogentry(logentry);
        return logentry;
    }

    public void updateRowIndexEntries(DatabaseLogentry updLogentry, DatabaseTableRow row) throws SQLException {
        Enumeration iter = this.getIndexTableIterator();
        IndexTable badIndex = null;
        SQLException indexException = null;
        if (iter == null) {
            return;
        }
        while (iter.hasMoreElements() && indexException == null) {
            IndexTable currIndex = (IndexTable)iter.nextElement();
            try {
                currIndex.updateRowEntry((TableRow)row);
            }
            catch (SQLException ex) {
                badIndex = currIndex;
                indexException = ex;
            }
        }
        if (indexException != null) {
            this.rollbackUpdateAfterIndexError(updLogentry, (TableRow)row, badIndex);
            throw indexException;
        }
    }

    synchronized boolean writeContentIntoFile(boolean unloadTable) throws IOException {
        boolean fileWritten = false;
        if (this.m_unloaded || this.m_schemaFolder == null || !this.m_isUpdated && !unloadTable) {
            return fileWritten;
        }
        if (!this.m_isUpdated) {
            if (unloadTable) {
                this.removeAll();
                this.m_unloaded = true;
            }
            return fileWritten;
        }
        this.m_tableFileSeq = this.m_tableFileSeq < Integer.MAX_VALUE ? ++this.m_tableFileSeq : 1;
        try {
            this.m_schemaFolder.mkdir();
            File outFile = this.getTableFile(false);
            File auxFile = this.getTableFile(true);
            auxFile.delete();
            boolean fileAlreadyExists = outFile.exists();
            boolean fileRenamed = outFile.renameTo(auxFile);
            if (fileAlreadyExists && !fileRenamed) {
                throw new IOException("file " + outFile.getAbsolutePath() + " not accessible");
            }
            try {
                FileOutputStream fileStream = new FileOutputStream(outFile);
                DatabaseOutputStream outStream = new DatabaseOutputStream(fileStream);
                outStream.writeInt(-606361085);
                outStream.writeInt(this.m_tableFileSeq);
                this.m_tableName.writeToStream(outStream);
                outStream.writeByteArray(this.m_colTypeList);
                outStream.writeIntArray(this.m_keyColNoList);
                this.writePrimaryTree(outStream);
                outStream.writeInt(-606361085);
                fileStream.close();
                fileWritten = true;
            }
            catch (Exception ex) {
                outFile.delete();
                if (fileAlreadyExists) {
                    auxFile.renameTo(outFile);
                }
                throw ex;
            }
            if (fileAlreadyExists) {
                auxFile.delete();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        this.m_isUpdated = false;
        if (unloadTable) {
            this.removeAll();
            this.m_unloaded = true;
        }
        return fileWritten;
    }

    private void writeIndexTablesMetaData(DatabaseOutputStream outStream) throws IOException {
        if (!this.existsIndex()) {
            outStream.writeInt(0);
            return;
        }
        outStream.writeInt(this.m_indexTabByName.size());
        Enumeration iter = this.getIndexTableIterator();
        while (iter.hasMoreElements()) {
            IndexTable indexTab = (IndexTable)iter.nextElement();
            indexTab.writeMetaDataToStream(outStream);
        }
    }

    private void writePrimaryTree(DatabaseOutputStream outStream) throws IOException {
        outStream.writeInt(this.m_tree.size());
        Iterator treeIter = this.getIterator();
        while (treeIter.hasNext()) {
            TableRow currRow = (TableRow)treeIter.next();
            currRow.writeToStream(outStream);
        }
    }

    synchronized void writeToStream(DatabaseOutputStream outStream, boolean isBackup) throws IOException {
        outStream.writeInt(-606348541);
        outStream.writeInt(this.m_tableType);
        outStream.writeInt(this.m_primKeyType);
        outStream.writeInt(this.m_maxNumericColNo);
        outStream.writeInt(this.m_maxObjectColNo);
        outStream.writeLong(this.m_sysKey);
        outStream.writeStringArray(this.m_colNameList);
        outStream.writeByteArray(this.m_colTypeList);
        outStream.writeIntArray(this.m_keyColNoList);
        outStream.writeIntArray(this.m_keyColNoOfRowNo);
        this.m_tableName.writeToStream(outStream);
        if (this.m_trigger == null) {
            outStream.writeInt(0);
        } else {
            outStream.writeInt(this.m_trigger.length);
            for (int i = 0; i < this.m_trigger.length; ++i) {
                outStream.writeBoolean(this.m_trigger[i] != null);
                if (this.m_trigger[i] == null) continue;
                this.m_trigger[i].writeToStream(outStream);
            }
        }
        if (isBackup) {
            if (this.m_unloaded) {
                this.readContentFromFile(this.getTableFile(false));
            }
            this.writePrimaryTree(outStream);
            if (this.m_unloaded) {
                this.m_tree.clear();
            }
        }
        this.writeIndexTablesMetaData(outStream);
    }
}

