/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.ResultSetImpl;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;

public class ResultSetOrderBy
extends ResultSetImpl {
    private int m_insertCount = 0;
    private boolean m_isSelectDistinct = false;
    private int[] m_orderByColNo;
    private boolean[] m_orderByAsc;
    private TreeMap m_resultTree;

    public boolean last() {
        if (this.m_resultTree == null || this.m_resultTree.size() <= 0) {
            return false;
        }
        Row lastRow = (Row)this.m_resultTree.get(this.m_resultTree.lastKey());
        super.setLastRow(lastRow);
        return true;
    }

    public ResultSetOrderBy(boolean isSelectDistinct, int maxNumericColNo, int maxObjectColNo, int[] orderByColNo, boolean[] orderByAsc, String[] schemaList, String[] tabIdentifierList, String[] colNameList, byte[] colTypeList) {
        super(maxNumericColNo, maxObjectColNo, schemaList, tabIdentifierList, colNameList, colTypeList);
        if (!isSelectDistinct) {
            this.m_orderByColNo = orderByColNo;
            this.m_orderByAsc = orderByAsc;
        } else {
            this.initDistinctWithOrderBy(colNameList.length - 1, orderByColNo, orderByAsc);
        }
    }

    public ResultSetOrderBy(DatabaseTable tab, boolean isSelectDistinct, int[] orderByColNo, boolean[] orderByAsc) {
        super(tab);
        if (!isSelectDistinct) {
            this.m_orderByColNo = orderByColNo;
            this.m_orderByAsc = orderByAsc;
        } else {
            this.initDistinctWithOrderBy(tab.getMaxColNo(), orderByColNo, orderByAsc);
        }
    }

    public ResultSetOrderBy(DatabaseTable tab) {
        super(tab);
        this.initDistinctWithoutOrderBy(tab.getMaxColNo());
    }

    public ResultSetOrderBy(int maxNumericColNo, int maxObjectColNo, String[] schemaList, String[] tabIdentifierList, String[] colNameList, byte[] colTypeList) {
        super(maxNumericColNo, maxObjectColNo, schemaList, tabIdentifierList, colNameList, colTypeList);
        this.initDistinctWithoutOrderBy(colNameList.length - 1);
    }

    public int addRow(DatabaseRow resultRow) {
        if (this.m_resultTree == null) {
            this.m_resultTree = new TreeMap();
        }
        ++this.m_insertCount;
        int uniqueRowNo = this.m_isSelectDistinct ? -1 : this.m_insertCount;
        IndexKey key = new IndexKey(resultRow, this.m_orderByColNo, this.m_orderByAsc, uniqueRowNo);
        this.m_resultTree.put(key, resultRow);
        return this.m_resultTree.size();
    }

    public void clearReferences() {
        super.clearReferences();
        this.m_resultTree = null;
    }

    private void initDistinctWithOrderBy(int maxColumns, int[] orderByClauseColNo, boolean[] orderByClauseAsc) {
        this.m_isSelectDistinct = true;
        this.m_orderByColNo = new int[maxColumns + 1];
        this.m_orderByAsc = new boolean[maxColumns + 1];
        boolean[] used = new boolean[maxColumns + 1];
        Arrays.fill(used, false);
        for (int i = 1; i < orderByClauseColNo.length; ++i) {
            this.m_orderByColNo[i] = orderByClauseColNo[i];
            this.m_orderByAsc[i] = orderByClauseAsc[i];
            used[orderByClauseColNo[i]] = true;
        }
        int index = orderByClauseColNo.length;
        for (int colNo = 1; colNo <= maxColumns; ++colNo) {
            if (index >= this.m_orderByColNo.length || used[colNo]) continue;
            this.m_orderByColNo[index] = colNo;
            this.m_orderByAsc[index] = true;
            ++index;
        }
    }

    private void initDistinctWithoutOrderBy(int maxColumns) {
        this.m_isSelectDistinct = true;
        this.m_orderByColNo = new int[maxColumns + 1];
        this.m_orderByAsc = new boolean[maxColumns + 1];
        for (int colNo = 1; colNo <= maxColumns; ++colNo) {
            this.m_orderByColNo[colNo] = colNo;
        }
        Arrays.fill(this.m_orderByAsc, true);
    }

    public void resultCreated() {
        if (this.m_resultTree == null || this.m_resultTree.size() <= 0) {
            return;
        }
        Iterator iter = this.m_resultTree.values().iterator();
        this.setIteratorAndResultSize(iter, this.m_resultTree.size());
    }
}

