/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.io.IOException;

public class PrimaryCharKey
extends AnyKey {
    private boolean m_initialized;
    private String m_charCol;

    PrimaryCharKey() {
        this.m_initialized = false;
        this.m_charCol = null;
    }

    public PrimaryCharKey(String keyValue) {
        this.m_charCol = keyValue;
        this.m_initialized = true;
    }

    public void addCol(int colNo, String keyValue) {
        if (colNo == 1) {
            this.m_charCol = keyValue;
            this.m_initialized = true;
        } else {
            super.addCol(colNo, keyValue);
        }
    }

    public int compareTo(Object o) {
        PrimaryCharKey other = (PrimaryCharKey)o;
        if (!this.m_initialized) {
            return other.m_initialized ? -1 : 0;
        }
        if (!other.m_initialized) {
            return 1;
        }
        return this.m_charCol.compareTo(other.m_charCol);
    }

    public boolean isGreaterStopKey(DatabaseKey stopKey) {
        PrimaryCharKey other = (PrimaryCharKey)stopKey;
        if (!this.m_initialized || !other.m_initialized) {
            return false;
        }
        return this.m_charCol.compareTo(other.m_charCol) > 0;
    }

    void readFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_initialized = inStream.readBoolean();
        this.m_charCol = inStream.readString();
    }

    public String toString() {
        return this.m_initialized ? "'" + this.m_charCol + "'" : "<empty>";
    }

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeByte(1);
        outStream.writeBoolean(this.m_initialized);
        outStream.writeString(this.m_charCol);
    }
}

