/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.ColumnType;
import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;

public class Row
implements DatabaseRow {
    private byte[] m_colState;
    private long[] m_numericCol;
    private Object[] m_objectCol;

    public Row() {
        this.m_colState = null;
        this.m_numericCol = null;
        this.m_objectCol = null;
    }

    public Row(int maxNumericColNo, int maxObjectColNo) {
        this.initRow(maxNumericColNo, maxObjectColNo);
    }

    public Row(Row sourceRow) {
        int maxNumericColNo = sourceRow.m_numericCol == null ? 0 : sourceRow.m_numericCol.length - 1;
        int maxObjectColNo = sourceRow.m_objectCol == null ? 0 : sourceRow.m_objectCol.length - 1;
        this.initRow(maxNumericColNo, maxObjectColNo);
        this.copyContents(sourceRow);
    }

    public void clear() {
        byte auxState = this.m_colState[0];
        Arrays.fill(this.m_colState, (byte)0);
        if (this.m_objectCol != null) {
            Arrays.fill(this.m_objectCol, null);
        }
        this.m_colState[0] = auxState;
    }

    public void copyCol(int colNo, DatabaseRow sourceRow, int sourceColNo) {
        this.copyCol(colNo, (Row)sourceRow, sourceColNo);
    }

    public void copyCol(int colNo, Row sourceRow, int sourceColNo) {
        this.m_colState[colNo] = sourceRow.m_colState[sourceColNo];
        switch (this.m_colState[colNo]) {
            case 0: {
                this.m_objectCol[colNo] = null;
                break;
            }
            case 4: {
                this.m_numericCol[colNo] = sourceRow.m_numericCol[sourceColNo];
                break;
            }
            default: {
                this.m_objectCol[colNo] = sourceRow.m_objectCol[sourceColNo];
            }
        }
    }

    public void copyCol(int colNo, byte colType, DatabaseRow sourceRow, int sourceColNo) throws SQLException {
        byte sourceState = ((Row)sourceRow).m_colState[sourceColNo];
        if (sourceState == 0) {
            this.m_colState[colNo] = 0;
            this.m_objectCol[colNo] = null;
            return;
        }
        this.m_colState[colNo] = colType;
        if (colType == 4) {
            this.m_numericCol[colNo] = colType == sourceState ? ((Row)sourceRow).m_numericCol[sourceColNo] : sourceRow.getNumericCol(sourceColNo);
            return;
        }
        if (colType == sourceState) {
            this.m_objectCol[colNo] = ((Row)sourceRow).m_objectCol[sourceColNo];
            return;
        }
        if (colType == 2) {
            this.m_objectCol[colNo] = sourceRow.getCharCol(sourceColNo);
            return;
        }
        if (colType == 1) {
            this.m_objectCol[colNo] = sourceRow.getBinaryCol(sourceColNo);
            return;
        }
        if (colType == 3) {
            this.m_objectCol[colNo] = new Double(sourceRow.getDoubleCol(sourceColNo));
            return;
        }
        throw ErrorMsg.newSQLException("Cannot convert " + ColumnType.getTypeName(sourceState) + " source column " + sourceColNo + " into " + ColumnType.getTypeName(colType) + " column " + colNo, -3999);
    }

    public void copyContents(DatabaseRow sourceRow) {
        this.copyContents((Row)sourceRow);
    }

    public void copyContents(Row sourceRow) {
        System.arraycopy(sourceRow.m_colState, 0, this.m_colState, 0, this.m_colState.length);
        if (this.m_numericCol != null) {
            System.arraycopy(sourceRow.m_numericCol, 0, this.m_numericCol, 0, this.m_numericCol.length);
        }
        if (this.m_objectCol != null) {
            System.arraycopy(sourceRow.m_objectCol, 0, this.m_objectCol, 0, this.m_objectCol.length);
        }
    }

    public static Row createFromStream(DatabaseInputStream inStream) throws IOException {
        Row row = new Row();
        row.readFromStream(inStream);
        return row;
    }

    public byte[] getBinaryCol(int colNo) throws SQLException {
        if (this.m_colState[colNo] == 0) {
            return null;
        }
        if (this.m_colState[colNo] != 1) {
            if (this.m_colState[colNo] == 2 || this.m_colState[colNo] == 4 || this.m_colState[colNo] == 3) {
                return this.getCharCol(colNo).getBytes();
            }
            throw ErrorMsg.newSQLException("Cannot convert " + this.getColumnTypeName(colNo) + " column " + colNo + " into a binary value", -3999);
        }
        return (byte[])this.m_objectCol[colNo];
    }

    public String getCharCol(int colNo) throws SQLException {
        if (this.m_colState[colNo] == 0) {
            return null;
        }
        if (this.m_colState[colNo] != 2) {
            if (this.m_colState[colNo] == 4) {
                return Long.toString(this.m_numericCol[colNo]);
            }
            if (this.m_colState[colNo] == 3) {
                return Double.toString(this.getDoubleCol(colNo));
            }
            if (this.m_colState[colNo] == 1) {
                return new String(this.getBinaryCol(colNo));
            }
            throw ErrorMsg.newSQLException("Cannot convert " + this.getColumnTypeName(colNo) + " column " + colNo + " into a character value", -3999);
        }
        return (String)this.m_objectCol[colNo];
    }

    public byte getColumnState(int colNo) {
        return this.m_colState[colNo];
    }

    public byte[] getColumnTypeList() {
        return this.m_colState;
    }

    private String getColumnTypeName(int colNo) {
        return ColumnType.getTypeName(this.m_colState[colNo]);
    }

    public double getDoubleCol(int colNo) throws SQLException {
        if (this.m_colState[colNo] == 0) {
            return 0.0;
        }
        if (this.m_colState[colNo] != 3) {
            if (this.m_colState[colNo] == 4) {
                return this.getNumericCol(colNo);
            }
            if (this.m_colState[colNo] == 2 || this.m_colState[colNo] == 1 || this.m_colState[colNo] == 4) {
                try {
                    return Double.parseDouble(this.getCharCol(colNo));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ErrorMsg.newSQLException("Cannot convert " + this.getColumnTypeName(colNo) + " column " + colNo + " into a double value", -3999);
        }
        return (Double)this.m_objectCol[colNo];
    }

    public int getMaxColNo() {
        return this.m_colState.length - 1;
    }

    public DatabaseRow getNewRowCopy() {
        return new Row(this);
    }

    public long getNumericCol(int colNo) throws SQLException {
        if (this.m_colState[colNo] == 0) {
            return 0L;
        }
        if (this.m_colState[colNo] != 4) {
            if ((this.m_colState[colNo] == 2 || this.m_colState[colNo] == 1 || this.m_colState[colNo] == 3) && this.m_objectCol[colNo] != null) {
                try {
                    return Long.parseLong(this.getCharCol(colNo));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ErrorMsg.newSQLException("Cannot convert " + this.getColumnTypeName(colNo) + " column " + colNo + " into a numeric value", -3999);
        }
        return this.m_numericCol[colNo];
    }

    public Object getObjectCol(int colNo) throws SQLException {
        if (this.m_colState[colNo] == 0) {
            return null;
        }
        if (this.m_colState[colNo] == 4) {
            return new Long(this.getNumericCol(colNo));
        }
        return this.m_objectCol[colNo];
    }

    private void initRow(int maxNumericColNo, int maxObjectColNo) {
        this.m_numericCol = maxNumericColNo > 0 ? new long[maxNumericColNo + 1] : null;
        this.m_objectCol = maxObjectColNo > 0 ? new Object[maxObjectColNo + 1] : null;
        this.m_colState = maxNumericColNo > maxObjectColNo ? new byte[maxNumericColNo + 1] : new byte[maxObjectColNo + 1];
        this.clear();
    }

    public boolean isNull(int colNo) {
        return this.m_colState[colNo] == 0;
    }

    public void printContents() {
        if (this.m_colState == null || this.m_colState.length == 0) {
            Console.println("      row " + this.hashCode() + " is empty");
            return;
        }
        Console.println("      row " + this.hashCode() + " (columns: " + (this.m_colState.length - 1) + ")");
        for (int col = 1; col < this.m_colState.length; ++col) {
            String msg = "      " + col + " " + ColumnType.getTypeName(this.m_colState[col]);
            switch (this.m_colState[col]) {
                case 0: {
                    break;
                }
                case 2: {
                    msg = msg + ": '" + (String)this.m_objectCol[col] + "'";
                    break;
                }
                case 4: {
                    msg = msg + ": " + this.m_numericCol[col];
                    break;
                }
                default: {
                    msg = msg + ": " + this.m_objectCol[col].toString();
                }
            }
            Console.println(msg);
        }
    }

    public void readFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_colState = inStream.readByteArray();
        this.m_numericCol = inStream.readLongArray();
        this.m_objectCol = inStream.readObjArray();
    }

    public void setBinaryCol(int colNo, byte[] x) {
        this.m_colState[colNo] = 1;
        this.m_objectCol[colNo] = x;
    }

    public void setCharCol(int colNo, String x) {
        this.m_colState[colNo] = 2;
        this.m_objectCol[colNo] = x;
    }

    public void setDoubleCol(int colNo, double x) {
        this.m_colState[colNo] = 3;
        this.m_objectCol[colNo] = new Double(x);
    }

    public void setNull(int colNo) {
        this.m_colState[colNo] = 0;
    }

    public void setNumericCol(int colNo, long x) {
        this.m_colState[colNo] = 4;
        this.m_numericCol[colNo] = x;
    }

    public void setObjectCol(int colNo, Object x) {
        this.m_colState[colNo] = 5;
        this.m_objectCol[colNo] = x;
    }

    public void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeByteArray(this.m_colState);
        outStream.writeLongArray(this.m_numericCol);
        outStream.writeObjArray(this.m_objectCol);
    }
}

