/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class DatabaseInputStream
extends DataInputStream {
    private static final int NULL_LENGTH = -1;
    private static final int NULL_OBJECT = 0;
    private static final int STRING_OBJECT = 1;
    private static final int ANY_OBJECT = 2;

    public DatabaseInputStream(InputStream inStream) throws IOException {
        super(inStream);
    }

    private Object deserializeObject() throws IOException {
        try {
            byte[] byteArray = this.readByteArray();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Object obj = objStream.readObject();
            objStream.close();
            return obj;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.toString());
        }
    }

    public boolean[] readBooleanArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        boolean[] boolArray = new boolean[length];
        for (int i = 0; i < length; ++i) {
            boolArray[i] = super.readBoolean();
        }
        return boolArray;
    }

    public byte[] readByteArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        byte[] byteArray = new byte[length];
        super.readFully(byteArray, 0, length);
        return byteArray;
    }

    public int[] readIntArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        int[] intArray = new int[length];
        for (int i = 0; i < length; ++i) {
            intArray[i] = super.readInt();
        }
        return intArray;
    }

    public long[] readLongArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        long[] longArray = new long[length];
        for (int i = 0; i < length; ++i) {
            longArray[i] = super.readLong();
        }
        return longArray;
    }

    public Object readObj() throws IOException {
        byte objType = super.readByte();
        switch (objType) {
            case 0: {
                return null;
            }
            case 1: {
                return super.readUTF();
            }
            case 2: {
                return this.deserializeObject();
            }
        }
        throw new IOException("unknown object type: " + objType);
    }

    public Object[] readObjArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        Object[] objArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            objArray[i] = this.readObj();
        }
        return objArray;
    }

    public String readString() throws IOException {
        if (super.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    public String[] readStringArray() throws IOException {
        int length = super.readInt();
        if (length == -1) {
            return null;
        }
        String[] stringArray = new String[length];
        for (int i = 0; i < length; ++i) {
            stringArray[i] = this.readString();
        }
        return stringArray;
    }
}

