/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.SQLException;

public abstract class ColumnType {
    public static final byte IS_NULL = 0;
    public static final byte IS_BINARY = 1;
    public static final byte IS_CHAR = 2;
    public static final byte IS_DOUBLE = 3;
    public static final byte IS_NUMERIC = 4;
    public static final byte IS_OBJECT = 5;
    public static final int DOUBLE_PRECISION = 17;
    public static final int NUMERIC_PRECISION = 18;

    public static int compareByteArray(byte[] leftOperand, byte[] rightOperand) {
        int minLength = leftOperand.length < rightOperand.length ? leftOperand.length : rightOperand.length;
        for (int i = 0; i < minLength; ++i) {
            if (leftOperand[i] == rightOperand[i]) continue;
            int left = leftOperand[i];
            int right = rightOperand[i];
            if (left < 0) {
                left = 127 - left;
            }
            if (right < 0) {
                right = 127 - right;
            }
            return left < right ? -1 : 1;
        }
        return leftOperand.length == rightOperand.length ? 0 : (leftOperand.length < rightOperand.length ? -1 : 1);
    }

    public static int compareObject(Object leftOperand, Object rightOperand) throws SQLException {
        if (leftOperand instanceof byte[] && rightOperand instanceof byte[]) {
            return ColumnType.compareByteArray((byte[])leftOperand, (byte[])rightOperand);
        }
        if (leftOperand instanceof Comparable && rightOperand instanceof Comparable) {
            return ((Comparable)leftOperand).compareTo((Comparable)rightOperand);
        }
        throw ErrorMsg.newSQLException("Objects not comparable", -3999);
    }

    public static int getPrecision(byte typeValue) {
        switch (typeValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return Integer.MAX_VALUE;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 3: {
                return 17;
            }
            case 4: {
                return 18;
            }
            case 5: {
                return -1;
            }
        }
        return 0;
    }

    public static int getSQLType(byte typeValue) {
        switch (typeValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return -2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2000;
            }
        }
        return 1111;
    }

    public static String getTypeName(byte typeValue) {
        switch (typeValue) {
            case 0: {
                return "null";
            }
            case 1: {
                return "binary";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "numeric";
            }
            case 5: {
                return "object";
            }
        }
        return "undefined";
    }
}

