/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class StressTest
extends TestCase
implements LiveCacheConstants {
    private static final String sUser = "USTRESS";
    private static final String sPassword = "USTRESS";
    private int mNumberOfFillers;
    private int mNumberOfContainers;
    private static boolean mTraceOn = false;
    private int mMaximumRuntime;
    private int mMaximumLoops;
    private float mObjectPropability;
    private float mKeyedObjectPropability;
    private float mVarObjectPropability;
    private int mNuberOfObjects = 0;
    private Connection mConnection = null;
    private TestStatement mStatement = null;

    private void deleteObjects() {
        try {
            CallableStatement stm = this.mConnection.prepareCall("CALL RANDOM_DELETE_ALL");
            this.mStatement.execute("drop package consist");
        }
        catch (SQLException e) {
            StressTest.addGlobalMessage((String)"Object deletion", (char)'E', (String)("Error while deleting objects: " + e.getMessage()));
        }
    }

    private boolean generateDBProcedures() throws TestDatabaseException {
        try {
            this.mStatement.enableExceptions(false);
            try {
                if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                    this.mStatement.execute("enable write transaction");
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
            }
            this.mStatement.execute("drop package consist");
            this.mStatement.enableExceptions(true);
            this.mStatement.execute("create package consist as 'livecache.Consistent' local");
            this.mStatement.execute("CREATE DBPROC RANDOM_ADD_OBJECT in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC RANDOM_ADD_KEYED_OBJECT in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC RANDOM_ADD_VAR_OBJECT in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC RANDOM_DELETE_ALL in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC CREATE_CURRENT_SCHEMA in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC SET_CURRENT_SCHEMA in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC DROP_CURRENT_SCHEMA in consist EXECUTE LOCAL");
            this.mStatement.execute("CREATE DBPROC CLASS_REGISTER in consist EXECUTE LOCAL");
            this.mStatement.enableExceptions(false);
            this.mStatement.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            this.mStatement.enableExceptions(true);
            this.mStatement.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            this.mStatement.execute("CALL CLASS_REGISTER");
            this.mConnection.commit();
        }
        catch (SQLException e) {
            StressTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            con = StressTest.getDatabase().connect(StressTest.getDatabase().getUser(), StressTest.getDatabase().getPassword());
            stmt = new TestStatement(null, con);
        }
        catch (Exception e) {
            StressTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during cleanup: " + e.getMessage()));
            throw new TestCaseException("Error during cleanup: " + e.getMessage());
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public synchronized void incNumberOfObjects() {
        ++this.mNuberOfObjects;
    }

    public boolean isTraceOn() {
        return mTraceOn;
    }

    public static void prepare() throws TestCaseException {
        Object lDefConnection = null;
        Object lDefTstmt = null;
    }

    static void printTrace(String TraceMessage) {
        if (mTraceOn) {
            System.out.println(TraceMessage);
        }
    }

    private boolean readParameters() {
        mTraceOn = StressTest.getParameterBoolean((String)"TraceOn", (boolean)false);
        this.mNumberOfContainers = StressTest.getParameterInt((String)"NumberOfContainers", (int)1);
        this.mNumberOfFillers = StressTest.getParameterInt((String)"NumberOfFillers", (int)5);
        this.mMaximumLoops = StressTest.getParameterInt((String)"MaximumLoops", (int)-1);
        this.mMaximumRuntime = StressTest.getParameterInt((String)"MaximumRuntime", (int)-1);
        this.mObjectPropability = StressTest.getParameterFloat((String)"ObjectPropability", (float)1.0f);
        this.mKeyedObjectPropability = StressTest.getParameterFloat((String)"KeyedObjectPropability", (float)0.0f);
        this.mVarObjectPropability = StressTest.getParameterFloat((String)"VarObjectPropability", (float)0.0f);
        if (this.mObjectPropability <= 0.0f && this.mKeyedObjectPropability <= 0.0f && this.mVarObjectPropability <= 0.0f) {
            StressTest.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)"Wrong object propability defined");
            return false;
        }
        if (this.mNumberOfFillers < 1) {
            StressTest.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)("Illegal number of filler tasks: " + this.mNumberOfFillers + ". Has to be at least 1"));
            return false;
        }
        if (this.mNumberOfContainers < 1) {
            StressTest.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)("Illegal number of Containers: " + this.mNumberOfContainers + ". Has to be at least 1"));
            return false;
        }
        if (this.mMaximumLoops < 1 && this.mMaximumRuntime < 0) {
            StressTest.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)"You have to define either MaximumLoops or MaximumRuntime");
            return false;
        }
        return true;
    }

    public void run() {
        boolean Finished = false;
        boolean AttemptToStop = false;
        Object AttemptToStopTime = null;
        System.out.println("Running test class StressTest");
    }

    public static void setTrace(boolean EnableTrace) {
        mTraceOn = EnableTrace;
    }
}

