/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

public class Oid
implements Cloneable {
    private int mPno = 0;
    private short mPagePos = 0;
    private short mClassId = 0;

    public Oid() {
    }

    public Oid(byte[] omsOid) {
        this.setOmsOid(omsOid);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Oid pObject) {
        return pObject.mPagePos == this.mPagePos && pObject.mPno == this.mPno && pObject.mClassId == this.mClassId;
    }

    public short getClassId() {
        return this.mClassId;
    }

    public byte[] getOmsOid() {
        byte[] Result = new byte[]{(byte)((this.mPno >> 24) % 256), (byte)((this.mPno >> 16) % 256), (byte)((this.mPno >> 8) % 256), (byte)(this.mPno % 256), (byte)((this.mPagePos >> 8) % 256), (byte)(this.mPagePos % 256), (byte)((this.mClassId >> 8) % 256), (byte)(this.mClassId % 256)};
        return Result;
    }

    public int getOmsOidLength() {
        return 8;
    }

    public int getPagePos() {
        return this.mPagePos;
    }

    public int getPno() {
        return this.mPno;
    }

    public void setClassId(short newClassId) {
        this.mClassId = newClassId;
    }

    public void setOmsOid(byte[] omsOid) {
        int Byte0 = (omsOid[0] + 256) % 256;
        int Byte1 = (omsOid[1] + 256) % 256;
        int Byte2 = (omsOid[2] + 256) % 256;
        int Byte3 = (omsOid[3] + 256) % 256;
        this.mPno = Byte0 << 24 | Byte1 << 16 | Byte2 << 8 | Byte3;
        Byte0 = (omsOid[4] + 256) % 256;
        Byte1 = (omsOid[5] + 256) % 256;
        this.mPagePos = (short)(Byte0 << 8 | Byte1);
        Byte0 = (omsOid[6] + 256) % 256;
        Byte1 = (omsOid[7] + 256) % 256;
        this.mClassId = (short)(Byte0 << 8 | Byte1);
    }

    public void setPagePos(short newPagePos) {
        this.mPagePos = newPagePos;
    }

    public void setPno(int newPno) {
        this.mPno = newPno;
    }

    public String toString() {
        return "(Pno=" + this.mPno + ", Pos=" + this.mPagePos + ", ClassId=" + this.mClassId + ")";
    }
}

