/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.lctest.ListDescriptor;
import com.sap.sapdb.lctest.LiveCacheActor;
import com.sap.sapdb.lctest.LiveCacheKiller;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.lctest.LiveCacheReader;
import com.sap.sapdb.lctest.LiveCacheWriter;
import com.sap.sapdb.lctest.SQLActor;
import com.sap.sapdb.lctest.SQLTableDescriptor;
import com.sap.sapdb.lctest.SQLWriter;
import com.sap.sapdb.lctest.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.File;
import java.io.FileWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public class MultiUserRecovery
extends LiveCacheMaster {
    private static int mNumberOfLists;
    private static int mNumberOfReaders;
    private static int mNumberOfWriters;
    private static int mNumberOfSQLActors;
    private static int mMaximumRuntime;
    private static int mMaximumLoops;
    private static int mNumberOfTables;
    private static int mRandomSeed;
    private static boolean mTwoPhaseCommit;
    public static boolean mOltpOnly;
    private Connection mConnection = null;
    private TestStatement mStatement = null;
    private static final String sVersion = "7.5";

    private Date attemptActorsStop(LiveCacheActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    private Date attemptActorsStop(SQLActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    private Date attemptActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    TestActor[] createActors() throws Exception {
        int j = 0;
        TestActor[] Actors = new TestActor[mNumberOfReaders + mNumberOfWriters + mNumberOfSQLActors];
        int i = 0;
        while (i < mNumberOfReaders) {
            Actors[j] = new LiveCacheReader();
            Actors[j].setMaster(this);
            ((LiveCacheReader)Actors[j]).setCycleNumber(mMaximumLoops);
            Actors[j].setTitle("Reader" + i + "   ");
            ++i;
            ++j;
        }
        i = 0;
        while (i < mNumberOfWriters) {
            Actors[j] = new LiveCacheWriter();
            Actors[j].setMaster(this);
            ((LiveCacheWriter)Actors[j]).setCycleNumber(mMaximumLoops);
            Actors[j].setTitle("Writer" + i + "   ");
            ++i;
            ++j;
        }
        i = 0;
        while (i < mNumberOfSQLActors) {
            Actors[j] = new SQLWriter();
            Actors[j].setMaster(this);
            SQLActor.setCycleNumber(mMaximumLoops);
            Actors[j].setTitle("SQLWriter" + i);
            ++i;
            ++j;
        }
        for (i = 0; i < Actors.length; ++i) {
            Actors[i].start();
        }
        return Actors;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = MultiUserRecovery.getDatabase().connect(MultiUserRecovery.getDatabase().getUser(), MultiUserRecovery.getDatabase().getPassword());
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST", ExecMode);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'consistent'");
            }
            DBProcedure.create(stmt, "LIST_INIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_EXIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_READ", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CREATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_UPDATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INSERT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_DELETE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_REMOVE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_LOCK", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CONSISTENT", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            MultiUserRecovery.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("ConsistentRead.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    LiveCacheActor createKiller() throws Exception {
        LiveCacheKiller Actor = new LiveCacheKiller();
        ((TestActor)Actor).setMaster(this);
        Actor.setTitle("Killer");
        Actor.start();
        return Actor;
    }

    private void deleteObjects() {
        block2: {
            try {
                CallableStatement stm = this.mConnection.prepareCall("CALL SET_CURRENT_SCHEMA('testteam')");
                stm.execute();
                stm = this.mConnection.prepareCall("CALL LIST_EXIT(?)");
                stm.registerOutParameter(1, 4);
                stm.execute();
                int NumberOfObjects = stm.getInt(1);
                MultiUserRecovery.printTrace("Number of deleted objects: " + NumberOfObjects);
                this.mStatement.execute("drop package consistent");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -51 || e.getErrorCode() == 700) break block2;
                MultiUserRecovery.addGlobalMessage((String)"Object deletion", (char)'I', (String)"Try to delete all still existing objects from the livecache; but:");
                MultiUserRecovery.addGlobalMessage((String)"Object deletion", (char)'E', (String)("Error while deleting objects: " + e.getMessage() + " " + e.getClass()));
            }
        }
    }

    private void dropTables() {
        block5: {
            Connection mSQLConnection = null;
            TestStatement mSQLStatement = null;
            try {
                mSQLConnection = MultiUserRecovery.getDatabase().connect(MultiUserRecovery.getDatabase().getDBAUser(), MultiUserRecovery.getDatabase().getDBAPassword());
                MultiUserRecovery.printTrace("Creating DROP connection!");
            }
            catch (Exception e) {
                MultiUserRecovery.addGlobalMessage((String)"dropTables()", (char)'I', (String)"Try to drop all still existing tables from the livecache.");
                MultiUserRecovery.addGlobalMessage((String)"Login failure in dropTables()", (char)'E', (String)("DBAUser: " + MultiUserRecovery.getDatabase().getDBAUser() + ", Password: " + MultiUserRecovery.getDatabase().getDBAPassword()));
                return;
            }
            try {
                mSQLStatement = new TestStatement(null, mSQLConnection);
                int NumberOfTables = MultiUserRecovery.getParameterInt((String)"NumberOfSQLActors", (int)0);
                for (int i = 0; i < NumberOfTables; ++i) {
                    mSQLStatement.executeUpdateIgnoreErrors("drop index ind_SQLTab" + i + " on SQLTab" + i);
                    mSQLStatement.executeUpdateIgnoreErrors("drop table SQLTab" + i);
                    this.mConnection.commit();
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -51 || e.getErrorCode() == 700) break block5;
                MultiUserRecovery.addGlobalMessage((String)"dropTables()", (char)'I', (String)"Try to drop all still existing tables from the livecache. But:");
                MultiUserRecovery.addGlobalMessage((String)"Dropping tables", (char)'E', (String)("Error while dropping tables: " + e.getMessage() + " " + e.getClass()));
            }
        }
    }

    private void forceActorsStop(LiveCacheActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].interrupt();
        }
    }

    private void forceActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].interrupt();
        }
    }

    public int getNumberOfLists() {
        return mNumberOfLists;
    }

    public int getNumberOfTables() {
        return mNumberOfTables;
    }

    private boolean initializeLists() {
        CallableStatement stm = null;
        try {
            try {
                stm = this.mConnection.prepareCall("CALL LIST_INIT");
                stm.execute();
            }
            catch (SQLException e) {
                if (e.getErrorCode() != -51) {
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            MultiUserRecovery.addGlobalMessage((String)"Object creation", (char)'E', (String)("Error while creating COM objects: " + e.getMessage()));
            return false;
        }
        this.mLists = new ListDescriptor[mNumberOfLists];
        this.mLists_Fallback = new ListDescriptor[mNumberOfLists];
        for (int i = 0; i < mNumberOfLists; ++i) {
            this.mLists[i] = new ListDescriptor();
            this.mLists_Fallback[i] = new ListDescriptor();
        }
        return true;
    }

    private boolean initializeTables() {
        this.mTables = new SQLTableDescriptor[mNumberOfTables];
        this.mTables_Fallback = new SQLTableDescriptor[mNumberOfTables];
        for (int i = 0; i < mNumberOfTables; ++i) {
            this.mTables[i] = new SQLTableDescriptor();
            this.mTables_Fallback[i] = new SQLTableDescriptor();
        }
        return true;
    }

    public static void prepare() throws TestCaseException {
        MultiUserRecovery.readParameters();
        MultiUserRecovery.printParameters();
        if (!mOltpOnly) {
            MultiUserRecovery.createDBProcedures();
        }
    }

    private static void printParameters() throws TestCaseException {
        MultiUserRecovery.printInfo("MultiUserRecovery", "Starting MultiUserRecovery 7.5");
        String parameterString = "";
        if (!mOltpOnly) {
            parameterString = parameterString + "\n     Number of OMS lists            = " + mNumberOfLists + "\n     Number of OMS updaters         = " + mNumberOfWriters + "\n     Number of OMS readers          = " + mNumberOfReaders;
        }
        parameterString = parameterString + "\n     Number of SQL actors           = " + mNumberOfSQLActors + "\n     Number of SQL tables           = " + mNumberOfSQLActors;
        parameterString = mMaximumRuntime == -1 ? parameterString + "\n     Maximum runtime                = infinite" : parameterString + "\n     Maximum runtime                = " + mMaximumRuntime + " min";
        parameterString = MultiUserRecovery.getParameterInt((String)"MaximumLoops", (int)-1) == -1 ? parameterString + "\n     Maximum loops                  = infinite" : parameterString + "\n     Maximum loops                  = " + MultiUserRecovery.getParameterInt((String)"MaximumLoops", (int)-1) + " loops";
        if (!mOltpOnly) {
            parameterString = parameterString + "\n     Maximum OMS list length        = " + MultiUserRecovery.getParameterInt((String)"MaxListLength", (int)10) + "\n     Maximum variable object length = " + MultiUserRecovery.getParameterInt((String)"VarMaxLength", (int)10);
        }
        parameterString = parameterString + "\n     Insert operations              = " + MultiUserRecovery.getParameterInt((String)"InsertPercentage", (int)33) + " %" + "\n     Update operations              = " + MultiUserRecovery.getParameterInt((String)"UpdatePercentage", (int)33) + " %" + "\n     Delete operations              = " + MultiUserRecovery.getParameterInt((String)"DeletePercentage", (int)33) + " %" + "\n     Subtrans propability           = " + MultiUserRecovery.getParameterInt((String)"SubtransactionPercentage", (int)33) + " %" + "\n     Subtrans commit propability    = " + MultiUserRecovery.getParameterInt((String)"SubtransCommitPercentage", (int)50);
        parameterString = MultiUserRecovery.getParameterInt((String)"ShutdownDistance", (int)-1) == -1 ? parameterString + "\n     Shutdown disabled" : parameterString + "\n     Shutdown distance              = " + MultiUserRecovery.getParameterInt((String)"ShutdownDistance", (int)-1) + " min" + "\n     Support two-phase-commit       = " + MultiUserRecovery.getParameterBoolean((String)"TwoPhaseCommit", (boolean)false) + "\n     Oltp test only                 = " + MultiUserRecovery.getParameterBoolean((String)"OltpOnly", (boolean)false);
        MultiUserRecovery.printInfo("MultiUserRecovery", "\nParameter Setting for this test: \n------------------------------------------------------ \n" + parameterString);
    }

    private static void readParameters() throws TestCaseException {
        mTraceOn = MultiUserRecovery.getParameterBoolean((String)"TraceOn", (boolean)true);
        mNumberOfLists = MultiUserRecovery.getParameterInt((String)"NumberOfLists", (int)10);
        mNumberOfReaders = MultiUserRecovery.getParameterInt((String)"NumberOfReaders", (int)2);
        mNumberOfWriters = MultiUserRecovery.getParameterInt((String)"NumberOfWriters", (int)2);
        mNumberOfSQLActors = MultiUserRecovery.getParameterInt((String)"NumberOfSQLActors", (int)3);
        mMaximumLoops = MultiUserRecovery.getParameterInt((String)"MaximumLoops", (int)-1);
        mMaximumRuntime = MultiUserRecovery.getParameterInt((String)"MaximumRuntime", (int)5);
        mRandomSeed = MultiUserRecovery.getParameterInt((String)"RandomSeed", (int)-1);
        mNumberOfTables = MultiUserRecovery.getParameterInt((String)"NumberOfSQLActors", (int)3);
        mTwoPhaseCommit = MultiUserRecovery.getParameterBoolean((String)"TwoPhaseCommit", (boolean)false);
        mOltpOnly = MultiUserRecovery.getParameterBoolean((String)"OltpOnly", (boolean)false);
        if (mRandomSeed != -1) {
            LiveCacheActor.setRandomSeed(mRandomSeed);
        }
        if (mNumberOfLists < 1) {
            throw new TestCaseException("Illegal number of Objects: " + mNumberOfLists + ". Has to be at least 1");
        }
        if (mMaximumLoops < 1 && mMaximumRuntime < 0) {
            throw new TestCaseException("You have to define either MaximumLoops or MaximumRuntime");
        }
    }

    public void run() {
        int j = 0;
        boolean Finished = false;
        boolean AttemptToStop = false;
        Date AttemptToStopTime = null;
        try {
            int i;
            this.mConnection = MultiUserRecovery.getDatabase().connect(MultiUserRecovery.getUser(), MultiUserRecovery.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            if (!mOltpOnly) {
                this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
                this.mConnection.commit();
                if (!this.initializeLists()) {
                    return;
                }
            }
            if (!this.initializeTables()) {
                return;
            }
            MultiUserRecovery.printInfo("MultiUserRecovery", "Starting the parallel actors");
            TestActor[] Actors = this.createActors();
            MultiUserRecovery.printInfo("MultiUserRecovery", "Starting the Killer");
            LiveCacheActor Killer2 = this.createKiller();
            Date StartTime = new Date();
            while (!Finished) {
                long TimeDiff;
                ++j;
                if (!AttemptToStop) {
                    if (mMaximumRuntime != -1 && (TimeDiff = (new Date().getTime() - StartTime.getTime()) / 60000L) > (long)mMaximumRuntime) {
                        AttemptToStop = true;
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                } else {
                    TimeDiff = new Date().getTime() - AttemptToStopTime.getTime();
                    if (TimeDiff > 5000L) {
                        this.forceActorsStop(Actors);
                    }
                }
                int NumberOfRunningActors = 0;
                for (i = 0; i < Actors.length; ++i) {
                    if (Actors[i].isRunning()) {
                        ++NumberOfRunningActors;
                        continue;
                    }
                    if (AttemptToStop || !Actors[i].hasError()) continue;
                    AttemptToStop = true;
                    AttemptToStopTime = this.attemptActorsStop(Actors);
                }
                if (NumberOfRunningActors == 0) {
                    Finished = true;
                    Killer2.shouldStop();
                } else if (AttemptToStop && j > 10) {
                    j = 0;
                }
                Thread.sleep(1000L);
            }
            if (Killer2.getStatus() == 4) {
                boolean killerFinishedDatabaseShutDown;
                this.addMessage("MultiUserRecovery", 'T', "The killer is currently shutting down the database.");
                long killerStartTime = new Date().getTime();
                boolean bl = killerFinishedDatabaseShutDown = Killer2.getStatus() == 3;
                while (!killerFinishedDatabaseShutDown) {
                    Thread.sleep(500L);
                    if (Killer2.getStatus() == 3) {
                        killerFinishedDatabaseShutDown = true;
                    }
                    if (killerFinishedDatabaseShutDown || killerStartTime + 180000L >= new Date().getTime()) continue;
                    this.addMessage("MultiUserRecovery", 'E', "A shutdown of the database by the killer thread was performed, but this shutdown didn't complete without error.");
                    break;
                }
            }
            if (Killer2.getStatus() == 3) {
                try {
                    String qalevel = mTestDriverOptions.getProperty("QALevel");
                    if (qalevel != null && qalevel.equalsIgnoreCase("D")) {
                        this.generateAnalysisFiles();
                    }
                    TestDatabase mTestDatabase = MultiUserRecovery.getDatabase();
                    TestDatabaseSap sapdb = (TestDatabaseSap)mTestDatabase;
                    if (mTestDatabase.isSap()) {
                        sapdb = (TestDatabaseSap)mTestDatabase;
                    }
                    if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.3.1")) {
                        MultiUserRecovery.printInfo("MultiUserRecovery", "Perform: 'db_admin' and 'db_execute check data with update'");
                        MultiUserRecovery.getDatabase().executeDBMcmd("db_admin");
                        MultiUserRecovery.getDatabase().executeDBMcmd("db_execute check data with update");
                    } else {
                        MultiUserRecovery.printInfo("MultiUserRecovery", "Perform: 'db_cold' and 'util_execute verify'");
                        MultiUserRecovery.getDatabase().executeDBMcmd("db_cold");
                        MultiUserRecovery.getDatabase().executeDBMcmd("util_execute verify");
                    }
                }
                catch (Exception e) {
                    String qalevel = mTestDriverOptions.getProperty("QALevel");
                    if (qalevel != null && qalevel.equalsIgnoreCase("D")) {
                        System.out.println("Could not execute 'db_admin' or 'db_execute check data with update'");
                        System.out.println("Error: " + e.getMessage());
                        System.out.println("Keep instance for analysis.");
                        this.setStatus("check data with update fails - important");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        System.exit(-1);
                    }
                    MultiUserRecovery.addGlobalMessage((String)"MultiUserRecovery", (char)'E', (String)("Could not execute 'db_admin' or 'db_execute check data with update': " + e.getMessage()));
                    return;
                }
                MultiUserRecovery.printInfo("MultiUserRecovery", "Restarting the liveCache");
                try {
                    MultiUserRecovery.getDatabase().restart();
                }
                catch (Exception e) {
                    MultiUserRecovery.addGlobalMessage((String)"MultiUserRecovery", (char)'E', (String)("Could not restart the liveCache: " + e.getMessage()));
                    return;
                }
                MultiUserRecovery.printInfo("MultiUserRecovery", "Checking liveCache consistency");
                try {
                    for (i = 0; i < Actors.length; ++i) {
                        Actors[i].check();
                    }
                }
                catch (DataConsistencyException e) {
                    MultiUserRecovery.addGlobalMessage((String)"MultiUserRecovery", (char)'E', (String)("Could not recover the liveCache! -> " + e.getMessage()));
                    MultiUserRecovery.addGlobalMessage((String)"", (char)'E', (String)("2. Info: " + e.getLocalizedMessage()));
                    MultiUserRecovery.addGlobalMessage((String)"", (char)'E', (String)("3. Info: " + e.getClass().getName()));
                    e.printStackTrace();
                    MultiUserRecovery.printInfo("MultiUserRecovery", "DataConsitencyException ERROR: liveCache could not recover properly! -> " + e.getMessage());
                }
                catch (Exception e) {
                    MultiUserRecovery.addGlobalMessage((String)"MultiUserRecovery", (char)'E', (String)("Could not recover the liveCache! More: " + e.getMessage()));
                    MultiUserRecovery.addGlobalMessage((String)"", (char)'E', (String)("2. info: " + e.getLocalizedMessage()));
                    MultiUserRecovery.addGlobalMessage((String)"", (char)'E', (String)("3. Info: " + e.getClass().getName()));
                    e.printStackTrace();
                    MultiUserRecovery.printInfo("MultiUserRecovery", "other Exception ERROR: liveCache could not recover properly! More: " + e.getMessage());
                }
            } else {
                MultiUserRecovery.printInfo("MultiUserRecovery", "Test finished");
                MultiUserRecovery.addGlobalMessage((String)"Status of Killer", (char)'I', (String)(Killer2.getStatusMessage() + " intern -> " + Killer2.getStatus()));
                for (i = 0; i < Actors.length; ++i) {
                    if (Actors[i].hasError()) {
                        MultiUserRecovery.addGlobalMessage((String)Actors[i].getTitle(), (char)'E', (String)(Actors[i].getStatusMessage() + " intern -> " + Actors[i].getStatus()));
                        continue;
                    }
                    MultiUserRecovery.addGlobalMessage((String)Actors[i].getTitle(), (char)'I', (String)(Actors[i].getStatusMessage() + " intern -> " + Actors[i].getStatus()));
                }
            }
            if (mNumberOfWriters > 0) {
                this.printListInfos();
            }
            if (!mOltpOnly) {
                this.deleteObjects();
            }
            if (mNumberOfSQLActors > 0) {
                this.printTableInfos();
            }
            this.dropTables();
        }
        catch (Exception e) {
            MultiUserRecovery.printInfo("MultiUserRecovery", "General exception: " + e.getLocalizedMessage() + " " + e.getClass().toString());
            if (e != null) {
                e.printStackTrace();
            }
            MultiUserRecovery.addGlobalMessage((String)"MultiUserRecovery", (char)'E', (String)(e.getLocalizedMessage() + " " + e.getClass().toString()));
        }
    }

    private void generateAnalysisFiles() {
        String currentCmd = null;
        Properties mOptions = mTestDriverOptions;
        File FileDir = null;
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)MultiUserRecovery.getDatabase();
            FileDir = new File(sapdb.getRunDir());
        }
        catch (TestDatabaseException e) {
            // empty catch block
        }
        if (FileDir == null) {
            System.out.println("No vtrace, rtedump and knldump because: can't read RUNDIRECTORY; getting: null");
            return;
        }
        try {
            currentCmd = mOptions.getProperty("DBRoot") + File.separator + "bin" + File.separator + "xkernprot -d " + mOptions.getProperty("DBName").toUpperCase() + " akbx";
            if (System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("WIN")) {
                SystemProcess = new Execute(currentCmd, null, ProcessOutput);
            } else {
                String[] cmdArr = new String[]{"sh", "-c", currentCmd};
                SystemProcess = new Execute(cmdArr, null, ProcessOutput);
            }
            SystemProcess.exec(FileDir);
            File Vtrace = new File(FileDir + File.separator + mOptions.getProperty("DBName").toUpperCase() + ".prt");
            File newVtrace = new File(FileDir + File.separator + MultiUserRecovery.getTestClassId() + "_db_stop.vtrace");
            Vtrace.renameTo(newVtrace);
        }
        catch (Exception e) {
            System.out.println("Can't run xkernprot.\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodError nsme) {
            System.out.println("Can't automatically generate the vtrace. Check if Java VM has version 1.3 or above.");
        }
        try {
            File rtedump = new File(FileDir + File.separator + "rtedump");
            File newRtedump = new File(FileDir + File.separator + MultiUserRecovery.getTestClassId() + "_db_stop.rtedump");
            rtedump.renameTo(newRtedump);
        }
        catch (Exception e) {
            System.out.println("Can't create rtedump.\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodError nsme) {
            System.out.println("Error: " + nsme.toString());
            nsme.printStackTrace();
        }
        try {
            File knldump = new File(FileDir + File.separator + "knldump");
            File newKnlump = new File(FileDir + File.separator + MultiUserRecovery.getTestClassId() + "_db_stop.knldump");
            knldump.renameTo(newKnlump);
        }
        catch (Exception e) {
            System.out.println("Can't copy knldump.\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodError nsme) {
            System.out.println("Error: " + nsme.toString());
            nsme.printStackTrace();
        }
        try {
            File knldiagFile = null;
            knldiagFile = new File(FileDir + File.separator + MultiUserRecovery.getTestClassId() + "_db_stop.knldiag");
            FileWriter fwknl = new FileWriter(knldiagFile);
            TestDatabaseSap sapdb = (TestDatabaseSap)MultiUserRecovery.getDatabase();
            String knldiag = sapdb.getDatabaseProtocolViaDBMKey("KNLDIAG");
            fwknl.write(knldiag.substring(0), 0, knldiag.length());
            fwknl.close();
        }
        catch (Exception e) {
            System.out.println("Can't copy knldiag.\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

