/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.TestActor;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Random;

abstract class LiveCacheActor
extends TestActor
implements LiveCacheConstants {
    public static final int WRITER = 1;
    public static final int READER = 2;
    public static final int KILLER = 3;
    public static final int NOT_STARTED = 0;
    public static final int R_START_CONSISTENT = 1;
    public static final int R_READ = 2;
    public static final int R_COMMIT = 3;
    public static final int W_LOCK = 4;
    public static final int W_WRITE = 5;
    public static final int W_COMMIT = 6;
    public static final int W_ROLLBACK = 7;
    public static final int F_APPEND = 8;
    public static final int W_CREATE = 9;
    public static final int W_REMOVE = 10;
    public static final int W_UPDATE = 11;
    protected int mAction = 0;
    protected int mCycleNumber = 0;
    protected static final SimpleDateFormat mDateFormat = new SimpleDateFormat("dd.MM.yyyy 'at' HH:mm:ss");
    private static Random mRandomGenerator = new Random();
    private static long mRandomSeed = -1L;

    public LiveCacheActor() {
    }

    public LiveCacheActor(Runnable target) {
        super(target);
    }

    public LiveCacheActor(Runnable target, String name) {
        super(target, name);
    }

    public LiveCacheActor(String name) {
        super(name);
    }

    public LiveCacheActor(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public LiveCacheActor(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public LiveCacheActor(ThreadGroup group, String name) {
        super(group, name);
    }

    protected void callDBProcedure(String ProcedureName) throws SQLException {
        this.mStatement.execute("CALL " + ProcedureName);
    }

    protected void cleanup() {
        try {
            this.mStatement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mConnection.rollback();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public abstract int getActorType();

    public int getCycleNumber() {
        return this.mCycleNumber;
    }

    public static Random getRandomGenerator() {
        return mRandomGenerator;
    }

    protected abstract int nextAction();

    public static float randomFloat(float MinValue, float MaxValue) {
        return (float)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue)) + MinValue;
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public void setCycleNumber(int newCycleNumber) {
        this.mCycleNumber = newCycleNumber;
    }

    public static void setRandomSeed(int pNewSeed) {
        mRandomSeed = pNewSeed;
        mRandomGenerator.setSeed(pNewSeed);
    }
}

