/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.ListDescriptor;
import com.sap.sapdb.lctest.LiveCacheActor;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.lctest.LiveCacheReader;
import com.sap.sapdb.lctest.LiveCacheWriter;
import com.sap.sapdb.lctest.TestActor;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.DirectoryCleaner;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public class ConsistentRead
extends LiveCacheMaster {
    private static int mNumberOfLists;
    private static int mNumberOfReaders;
    private static int mNumberOfWriters;
    private static int mNumberOfSQLActors;
    private static int mMaximumRuntime;
    private static int mMaximumLoops;
    private static Connection mCleanupConnection;
    private static DirectoryCleaner mDirectoryCleaner;
    private Connection mConnection = null;
    private TestStatement mStatement = null;
    private static final String sVersion = "6.3";

    private Date attemptActorsStop(LiveCacheActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    private Date attemptActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].shouldStop();
        }
        return new Date();
    }

    TestActor[] createActors() throws Exception {
        int j = 0;
        TestActor[] Actors = new TestActor[mNumberOfReaders + mNumberOfWriters + mNumberOfSQLActors];
        int i = 0;
        while (i < mNumberOfReaders) {
            Actors[j] = new LiveCacheReader();
            Actors[j].setMaster(this);
            ((LiveCacheReader)Actors[j]).setCycleNumber(mMaximumLoops);
            Actors[j].setTitle("Reader" + i);
            ++i;
            ++j;
        }
        i = 0;
        while (i < mNumberOfWriters) {
            Actors[j] = new LiveCacheWriter();
            Actors[j].setMaster(this);
            ((LiveCacheWriter)Actors[j]).setCycleNumber(mMaximumLoops);
            Actors[j].setTitle("Writer" + i);
            ++i;
            ++j;
        }
        for (i = 0; i < Actors.length; ++i) {
            Actors[i].start();
        }
        return Actors;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = ConsistentRead.getDatabase().connect(ConsistentRead.getDatabase().getUser(), ConsistentRead.getDatabase().getPassword());
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST", ExecMode);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'consistent'");
            }
            DBProcedure.create(stmt, "LIST_INIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_EXIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_READ", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CREATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_UPDATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INSERT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_DELETE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_REMOVE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_LOCK", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CONSISTENT", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            ConsistentRead.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("ConsistentRead.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void cleanUp() throws TestCaseException {
        block12: {
            TestStatement stmt;
            block11: {
                stmt = null;
                mDirectoryCleaner.stop();
                stmt = new TestStatement(null, mCleanupConnection);
                if (stmt == null) break block11;
                stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            }
            Object var3_1 = null;
            try {
                stmt.close();
                mCleanupConnection.rollback();
                mCleanupConnection.close();
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        if (((SQLException)e).getErrorCode() == -904 || ((SQLException)e).getErrorCode() == -907) {
                            ConsistentRead.addGlobalMessage((String)"cleanup", (char)'I', (String)("Database full; can not connect to delete objects.\n" + e.getLocalizedMessage()));
                        }
                    } else {
                        ConsistentRead.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during cleanup: " + e.getMessage()));
                        throw new TestCaseException("Error during cleanup: " + e.getMessage());
                    }
                    Object var3_2 = null;
                    try {
                        stmt.close();
                        mCleanupConnection.rollback();
                        mCleanupConnection.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    stmt.close();
                    mCleanupConnection.rollback();
                    mCleanupConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void deleteObjects() {
        block2: {
            try {
                this.mStatement = new TestStatement((TestCase)this, this.mConnection);
                this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
                this.mConnection.commit();
                CallableStatement stm = this.mConnection.prepareCall("CALL LIST_EXIT(?)");
                stm.registerOutParameter(1, 4);
                stm.execute();
                int NumberOfObjects = stm.getInt(1);
                ConsistentRead.addGlobalMessage((String)"internal object deletion", (char)'I', (String)("Number of deleted objects: " + NumberOfObjects));
                this.mConnection.commit();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -51 || e.getErrorCode() == 700 || e.getErrorCode() == -904 || e.getErrorCode() == -907) break block2;
                ConsistentRead.addGlobalMessage((String)"Object deletion", (char)'E', (String)("Error while deleting objects: " + e.getMessage()));
            }
        }
    }

    private void forceActorsStop(LiveCacheActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].interrupt();
        }
    }

    private void forceActorsStop(TestActor[] Actors) {
        for (int i = 0; i < Actors.length; ++i) {
            Actors[i].interrupt();
        }
    }

    public int getNumberOfLists() {
        return mNumberOfLists;
    }

    private boolean initializeLists() {
        CallableStatement stm = null;
        try {
            try {
                stm = this.mConnection.prepareCall("CALL LIST_INIT");
                stm.execute();
            }
            catch (SQLException e) {
                if (e.getErrorCode() != -51) {
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            ConsistentRead.addGlobalMessage((String)"Object creation", (char)'E', (String)("Error while creating COM objects: " + e.getMessage()));
            return false;
        }
        this.mLists = new ListDescriptor[mNumberOfLists];
        for (int i = 0; i < mNumberOfLists; ++i) {
            this.mLists[i] = new ListDescriptor();
        }
        return true;
    }

    public static long getTimeout() {
        if (mMaximumRuntime == -1) {
            return 0L;
        }
        return 60000 * (mMaximumRuntime + 5);
    }

    public static void prepare() throws TestCaseException {
        ConsistentRead.readParameters();
        ConsistentRead.printParameters();
        ConsistentRead.createDBProcedures();
        try {
            TestDatabase db = ConsistentRead.getDatabase();
            if (db.isSap()) {
                mDirectoryCleaner = new DirectoryCleaner(new File(((TestDatabaseSap)db).getRunDir()), "autosave.*", 300000);
            }
        }
        catch (Exception ex) {
            ConsistentRead.addGlobalMessage((String)"DirectoryCleaner", (char)'W', (String)("Can't start DirectoryCleaner: <" + ex.getMessage() + ">"));
        }
        mDirectoryCleaner.start();
        try {
            mCleanupConnection = ConsistentRead.getDatabase().connect(ConsistentRead.getDatabase().getUser(), ConsistentRead.getDatabase().getPassword());
        }
        catch (Exception ex2) {
            ConsistentRead.addGlobalMessage((String)"CleanUpConnection", (char)'W', (String)("Can not initialize cleanup connection: <" + ex2.getMessage() + ">"));
        }
    }

    private static void printParameters() throws TestCaseException {
        ConsistentRead.printInfo("ConsistentRead", "Starting ConsistentRead 6.3");
        ConsistentRead.printInfo("ConsistentRead", "Number of OMS lists            = " + mNumberOfLists);
        ConsistentRead.printInfo("ConsistentRead", "Number of OMS updaters         = " + mNumberOfWriters);
        ConsistentRead.printInfo("ConsistentRead", "Number of OMS readers          = " + mNumberOfReaders);
        ConsistentRead.printInfo("ConsistentRead", "Number of SQL actors           = " + mNumberOfSQLActors);
        if (mMaximumRuntime == -1) {
            ConsistentRead.printInfo("ConsistentRead", "Maximum runtime                = infinite");
        } else {
            ConsistentRead.printInfo("ConsistentRead", "Maximum runtime                = " + mMaximumRuntime + " min");
        }
        if (ConsistentRead.getParameterInt((String)"MaximumLoops", (int)-1) == -1) {
            ConsistentRead.printInfo("ConsistentRead", "Maximum loops                  = infinite");
        } else {
            ConsistentRead.printInfo("ConsistentRead", "Maximum loops                  = " + ConsistentRead.getParameterInt((String)"MaximumLoops", (int)-1) + " min");
        }
        ConsistentRead.printInfo("ConsistentRead", "Maximum OMS list length        = " + ConsistentRead.getParameterInt((String)"MaxListLength", (int)10));
        ConsistentRead.printInfo("ConsistentRead", "Maximum variable object length = " + ConsistentRead.getParameterInt((String)"VarMaxLength", (int)10));
        ConsistentRead.printInfo("ConsistentRead", "Insert operations              = " + ConsistentRead.getParameterInt((String)"InsertPercentage", (int)33) + " %");
        ConsistentRead.printInfo("ConsistentRead", "Update operations              = " + ConsistentRead.getParameterInt((String)"UpdatePercentage", (int)33) + " %");
        ConsistentRead.printInfo("ConsistentRead", "Delete operations              = " + ConsistentRead.getParameterInt((String)"DeletePercentage", (int)33) + " %");
        ConsistentRead.printInfo("ConsistentRead", "Subtrans propability           = " + ConsistentRead.getParameterInt((String)"SubtransactionPercentage", (int)33) + " %");
        ConsistentRead.printInfo("ConsistentRead", "Subtrans commit propability    = " + ConsistentRead.getParameterInt((String)"SubtransCommitPercentage", (int)50));
        ConsistentRead.printInfo("ConsistentRead", "TraceLoops                     = " + mTraceLoops);
    }

    private static void readParameters() throws TestCaseException {
        mTraceOn = ConsistentRead.getParameterBoolean((String)"TraceOn", (boolean)false);
        mTraceLoops = ConsistentRead.getParameterInt((String)"TraceLoops", (int)500);
        mNumberOfLists = ConsistentRead.getParameterInt((String)"NumberOfLists", (int)1);
        mNumberOfReaders = ConsistentRead.getParameterInt((String)"NumberOfReaders", (int)1);
        mNumberOfWriters = ConsistentRead.getParameterInt((String)"NumberOfWriters", (int)1);
        mNumberOfSQLActors = ConsistentRead.getParameterInt((String)"NumberOfSQLActors", (int)0);
        mMaximumLoops = ConsistentRead.getParameterInt((String)"MaximumLoops", (int)-1);
        mMaximumRuntime = ConsistentRead.getParameterInt((String)"MaximumRuntime", (int)45);
        mRandomSeed = ConsistentRead.getParameterInt((String)"RandomSeed", (int)-1);
        if (mRandomSeed != -1) {
            LiveCacheActor.setRandomSeed(mRandomSeed);
        }
        if (mNumberOfLists < 1) {
            throw new TestCaseException("Illegal number of Objects: " + mNumberOfLists + ". Has to be at least 1");
        }
        if (mMaximumLoops < 1 && mMaximumRuntime < 0) {
            throw new TestCaseException("You have to define either MaximumLoops or MaximumRuntime");
        }
    }

    public void run() {
        boolean Finished = false;
        boolean AttemptToStop = false;
        Date AttemptToStopTime = null;
        try {
            int i;
            this.mConnection = ConsistentRead.getDatabase().connect(ConsistentRead.getUser(), ConsistentRead.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
            if (!this.initializeLists()) {
                return;
            }
            this.mConnection.commit();
            TestActor[] Actors = this.createActors();
            Date StartTime = new Date();
            while (!Finished) {
                long TimeDiff;
                if (!AttemptToStop) {
                    if (mMaximumRuntime != -1 && (TimeDiff = (new Date().getTime() - StartTime.getTime()) / 60000L) >= (long)mMaximumRuntime) {
                        AttemptToStop = true;
                        AttemptToStopTime = this.attemptActorsStop(Actors);
                    }
                } else {
                    TimeDiff = new Date().getTime() - AttemptToStopTime.getTime();
                    if (TimeDiff > 5000L) {
                        this.forceActorsStop(Actors);
                    }
                }
                int NumberOfRunningActors = 0;
                for (i = 0; i < Actors.length; ++i) {
                    if (Actors[i].isRunning()) {
                        ++NumberOfRunningActors;
                        continue;
                    }
                    if (AttemptToStop || !Actors[i].hasError()) continue;
                    AttemptToStop = true;
                    AttemptToStopTime = this.attemptActorsStop(Actors);
                }
                if (NumberOfRunningActors == 0) {
                    Finished = true;
                    continue;
                }
                Thread.sleep(300L);
            }
            for (i = 0; i < Actors.length; ++i) {
                if (Actors[i].hasError()) {
                    ConsistentRead.addGlobalMessage((String)Actors[i].getTitle(), (char)'E', (String)Actors[i].getStatusMessage());
                    continue;
                }
                ConsistentRead.addGlobalMessage((String)Actors[i].getTitle(), (char)'I', (String)Actors[i].getStatusMessage());
            }
            this.printListInfos();
            this.deleteObjects();
        }
        catch (Exception e) {
            ConsistentRead.addGlobalMessage((String)"ConsistentRead", (char)'E', (String)e.getMessage());
        }
    }

    static {
        mDirectoryCleaner = null;
    }
}

