/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SeqTopicSubscriber
implements MessageListener,
ExceptionListener {
    private TopicConnection[] myConnection = null;
    private TopicSession[] qSession = null;
    private Topic[] consumeTopic = null;
    private TopicSubscriber[] qConsumer = null;
    private int[] myMessagesReceived;
    private int myMessagesToReceive = 0;
    private int[] mySeqNumber;
    private int myConsumerCount = 0;
    private static boolean end;

    public SeqTopicSubscriber(String consumerCount, String topicName, String messagesToReceive) {
        try {
            end = false;
            this.myConsumerCount = Integer.parseInt(consumerCount);
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive) * this.myConsumerCount;
            TopicConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.myConnection = new TopicConnection[this.myConsumerCount];
            this.qSession = new TopicSession[this.myConsumerCount];
            this.qConsumer = new TopicSubscriber[this.myConsumerCount];
            this.consumeTopic = new Topic[this.myConsumerCount];
            this.mySeqNumber = new int[this.myConsumerCount];
            this.myMessagesReceived = new int[this.myConsumerCount];
            for (int i = 0; i < this.myConsumerCount; ++i) {
                this.myConnection[i] = qFactory.createTopicConnection("", "");
                this.qSession[i] = this.myConnection[0].createTopicSession(false, 1);
                this.consumeTopic[i] = (Topic)jndi.lookup("jms.topic." + topicName + new Integer(i + 1).toString());
                this.qConsumer[i] = this.qSession[i].createSubscriber(this.consumeTopic[i]);
                this.qConsumer[i].setMessageListener((MessageListener)this);
                this.myConnection[i].setExceptionListener((ExceptionListener)this);
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Consumer due to: " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            if (this.getAllMessagesReceived() > this.myMessagesToReceive) {
                return;
            }
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            int seq = textMessage.getIntProperty("MsgNumber");
            int topicNumber = textMessage.getIntProperty("TopicNumber");
            String out = "Received on topic[" + topicNumber + "] ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            int n = topicNumber;
            this.myMessagesReceived[n] = this.myMessagesReceived[n] + 1;
            if (this.myMessagesReceived[topicNumber] == 1) {
                this.mySeqNumber[topicNumber] = seq;
            } else {
                int n2 = topicNumber;
                this.mySeqNumber[n2] = this.mySeqNumber[n2] + 1;
            }
            if (this.mySeqNumber[topicNumber] != seq) {
                System.out.println("Sequence Error: Expected:" + this.mySeqNumber[topicNumber] + " on topic: " + topicNumber + " , Received: " + seq);
                this.exit();
            }
            if (this.getAllMessagesReceived() == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message consumed: " + text + " at " + end.toString());
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    private synchronized int getAllMessagesReceived() {
        int allMsg = 0;
        for (int i = 0; i < this.myConsumerCount; ++i) {
            allMsg += this.myMessagesReceived[i];
        }
        return allMsg;
    }

    public void exit() {
        end = true;
    }

    public void close() throws JMSException {
        for (int i = 0; i < this.myConsumerCount; ++i) {
            this.myConnection[i].close();
        }
    }

    public void start() {
        try {
            for (int i = 0; i < this.myConsumerCount; ++i) {
                this.myConnection[i].start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.out.println("ConsumerCount,TopicName or Messagenumber missing");
        }
        SeqTopicSubscriber aQR = new SeqTopicSubscriber(argv[0], argv[1], argv[2]);
        System.out.println("Type 'start' to start connection.");
        try {
            String s = "";
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                s = stdin.readLine();
                if (!s.equalsIgnoreCase("start")) continue;
                stdin.close();
                aQR.start();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            while (!end) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            aQR.close();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }
}

