/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SeqQueueReceiver
implements MessageListener,
ExceptionListener {
    private QueueConnection[] myConnection = null;
    private QueueSession[] qSession = null;
    private Queue[] receiveQueue = null;
    private QueueReceiver[] qReceiver = null;
    private int[] myMessagesReceived;
    private int myMessagesToReceive = 0;
    private int[] mySeqNumber;
    private int myReceiverCount = 0;
    private static boolean end;

    public SeqQueueReceiver(String receiverCount, String queueName, String messagesToReceive) {
        try {
            end = false;
            this.myReceiverCount = Integer.parseInt(receiverCount);
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive) * this.myReceiverCount;
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.myConnection = new QueueConnection[this.myReceiverCount];
            this.qSession = new QueueSession[this.myReceiverCount];
            this.qReceiver = new QueueReceiver[this.myReceiverCount];
            this.receiveQueue = new Queue[this.myReceiverCount];
            this.mySeqNumber = new int[this.myReceiverCount];
            this.myMessagesReceived = new int[this.myReceiverCount];
            for (int i = 0; i < this.myReceiverCount; ++i) {
                this.myConnection[i] = qFactory.createQueueConnection("", "");
                this.qSession[i] = this.myConnection[0].createQueueSession(false, 1);
                this.receiveQueue[i] = (Queue)jndi.lookup("jms.queue." + queueName + new Integer(i + 1).toString());
                this.qReceiver[i] = this.qSession[i].createReceiver(this.receiveQueue[i]);
                this.qReceiver[i].setMessageListener((MessageListener)this);
                this.myConnection[i].setExceptionListener((ExceptionListener)this);
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            if (this.getAllMessagesReceived() > this.myMessagesToReceive) {
                return;
            }
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            int seq = textMessage.getIntProperty("MsgNumber");
            int queueNumber = textMessage.getIntProperty("QueueNumber");
            String out = "Received on queue[" + queueNumber + "] ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            int n = queueNumber;
            this.myMessagesReceived[n] = this.myMessagesReceived[n] + 1;
            if (this.myMessagesReceived[queueNumber] == 1) {
                this.mySeqNumber[queueNumber] = seq;
            } else {
                int n2 = queueNumber;
                this.mySeqNumber[n2] = this.mySeqNumber[n2] + 1;
            }
            if (this.mySeqNumber[queueNumber] != seq) {
                System.out.println("Sequence Error: Expected:" + this.mySeqNumber[queueNumber] + " on queue: " + queueNumber + " , Received: " + seq);
                this.exit();
            }
            if (this.getAllMessagesReceived() == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message received: " + text + " at " + end.toString());
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    private synchronized int getAllMessagesReceived() {
        int allMsg = 0;
        for (int i = 0; i < this.myReceiverCount; ++i) {
            allMsg += this.myMessagesReceived[i];
        }
        return allMsg;
    }

    public void exit() {
        end = true;
    }

    public void close() throws JMSException {
        for (int i = 0; i < this.myReceiverCount; ++i) {
            this.myConnection[i].close();
        }
    }

    public void start() {
        try {
            for (int i = 0; i < this.myReceiverCount; ++i) {
                this.myConnection[i].start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.out.println("ReceiverCount,QueueName or Messagenumber missing");
        }
        SeqQueueReceiver aQR = new SeqQueueReceiver(argv[0], argv[1], argv[2]);
        System.out.println("Type 'start' to start connection.");
        try {
            String s = "";
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                s = stdin.readLine();
                if (!s.equalsIgnoreCase("start")) continue;
                stdin.close();
                aQR.start();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            while (!end) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            aQR.close();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }
}

