/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

public class OneTopicPublisher
extends Thread
implements ExceptionListener {
    private TopicSession myPubSession;
    private TopicPublisher myPublisher;
    private TopicPublisher myPublisher2;
    private TopicConnection myConnection;
    private int myMessagesToSend = 0;
    private int mySentMessages = 1;
    private int myPriority = 0;
    private int myDeliverMode = 0;

    public OneTopicPublisher(String topicName, String priority, String messagesToSend, String persistent) throws Exception {
        this.myPriority = Integer.parseInt(priority);
        this.myMessagesToSend = Integer.parseInt(messagesToSend);
        this.myDeliverMode = persistent.equalsIgnoreCase("persistent") ? 2 : 1;
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection = conFactory.createTopicConnection("", "");
        this.myPubSession = this.myConnection.createTopicSession(false, 1);
        Topic myTopic = (Topic)jndi.lookup("jms.topic." + topicName + "_1");
        Topic myTopic2 = (Topic)jndi.lookup("jms.topic." + topicName + "_2");
        this.myPublisher = this.myPubSession.createPublisher(myTopic);
        this.myPublisher2 = this.myPubSession.createPublisher(myTopic2);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    protected void publishMessage() throws JMSException {
        TextMessage textMsg = this.myPubSession.createTextMessage();
        TextMessage textMsg2 = this.myPubSession.createTextMessage();
        String text = "Topic Message: " + Integer.toString(this.mySentMessages) + " with Priority(" + this.myPriority + ")" + " ";
        textMsg.setText(text + "_1");
        System.out.println("Publish Message 1: " + textMsg.getText());
        textMsg2.setText(text + "_2");
        System.out.println("Publish Message 2: " + textMsg2.getText());
        this.myPublisher.publish((Message)textMsg, this.myDeliverMode, this.myPriority, 0L);
        this.myPublisher2.publish((Message)textMsg2, this.myDeliverMode, this.myPriority, 0L);
        ++this.mySentMessages;
    }

    private void exit() {
        try {
            this.myConnection.close();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public void run() {
        Date start = new Date();
        while (this.mySentMessages <= this.myMessagesToSend) {
            try {
                this.publishMessage();
            }
            catch (JMSException ex) {
                ex.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
    }

    public static void main(String[] argv) {
        OneTopicPublisher aBS = null;
        try {
            if (argv.length != 4) {
                System.out.println("TopicName,Priority,Messagenumber or (non)persistent missing");
            }
            aBS = new OneTopicPublisher(argv[0], argv[1], argv[2], argv[3]);
            aBS.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Attention!!! Unhandled Error!");
            e.printStackTrace();
        }
    }
}

