/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.msgServer.test.ReceiveStatisticHandler;
import com.sap.sdb.msgServer.test.ReceiverClient;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MassTopicSubscriber
implements MessageListener,
ExceptionListener,
ReceiverClient {
    private TopicConnection m_connection = null;
    private TopicSession m_session = null;
    private Topic m_topic = null;
    private int m_ownThreadId;
    private long m_msgCount = 0L;
    private long m_rollbackTrigger = 0L;
    private long m_errorCount = 0L;
    private String[] m_lastMsgID;
    private String[] m_lastMsgText;
    private static int m_acknowledgeMode = 1;
    private static boolean m_noCheck = false;
    private static boolean m_transacted = false;
    private static boolean m_syncReceive = false;
    private static boolean m_properties = false;
    private static ReceiveStatisticHandler m_receiveStat = null;
    private static final int ROLLBACK_MSG_COUNT = 10;
    private static final int DISPLAY_MSG_COUNT = 2000;
    private static final int MAX_CLIENTS = 6;
    private static final int MAX_PRIORITY = 9;
    private static final int PERSISTENT = 0;
    private static final int TRANSIENT = 1;
    private static final int PRIO_PERSISTENT = 2;
    private static final int PRIO_TRANSIENT = 3;

    public static void main(String[] argv) {
        int ArgIndex = 0;
        if (argv.length < 2) {
            System.out.println("Parameter required: <TopicName1> <TopicName2> [NOCHECK] [CLIENT_ACK | TRANSACTED] [SYNC] [PROPERTIES]");
            return;
        }
        ArgIndex = 2;
        if (argv.length > ArgIndex + 1) {
            if (argv[ArgIndex + 1].equalsIgnoreCase("client_ack")) {
                ++ArgIndex;
                m_acknowledgeMode = 2;
                System.out.println("session mode: client acknowledge");
            } else if (argv[ArgIndex + 1].equalsIgnoreCase("transacted")) {
                ++ArgIndex;
                m_transacted = true;
                System.out.println("transacted sessions");
            }
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("nocheck")) {
            ++ArgIndex;
            m_noCheck = true;
            System.out.println("without message order check");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("sync")) {
            ++ArgIndex;
            m_syncReceive = true;
            System.out.println("synchronous receive");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("properties")) {
            ++ArgIndex;
            m_properties = true;
            System.out.println("select properties");
        }
        m_receiveStat = new ReceiveStatisticHandler(6);
        m_receiveStat.start();
        int threadID = 0;
        for (int i = 1; i <= 3; ++i) {
            for (int k = 0; k < 2; ++k) {
                String topicName = argv[k];
                String subscriberName = "durable" + i + "_" + topicName;
                new MassTopicSubscriber(threadID, topicName, subscriberName);
                ++threadID;
            }
        }
    }

    private MassTopicSubscriber(int threadId, String topicName, String subscriberName) {
        System.out.println("initializing TopicSubscriber T" + threadId + ": " + subscriberName);
        try {
            this.m_ownThreadId = threadId;
            this.m_lastMsgID = new String[4];
            this.m_lastMsgText = new String[4];
            for (int i = 0; i < this.m_lastMsgID.length; ++i) {
                this.m_lastMsgID[i] = "";
                this.m_lastMsgText[i] = "";
            }
            InitialContext jndi = null;
            jndi = new InitialContext();
            TopicConnectionFactory factory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.m_connection = factory.createTopicConnection("", "");
            this.m_session = this.m_connection.createTopicSession(m_transacted, m_acknowledgeMode);
            this.m_topic = (Topic)jndi.lookup("jms.topic." + topicName);
            TopicSubscriber subscriber = m_properties ? this.m_session.createDurableSubscriber(this.m_topic, subscriberName, "StringProperty = 'Hallo'", false) : this.m_session.createDurableSubscriber(this.m_topic, subscriberName);
            this.m_connection.setExceptionListener((ExceptionListener)this);
            if (!m_syncReceive) {
                subscriber.setMessageListener((MessageListener)this);
            }
            this.m_connection.start();
            if (m_syncReceive) {
                SyncClient clientThread = new SyncClient(this, subscriber);
                clientThread.start();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void emptySynchronousMessageReceived() {
        if (this.m_msgCount == 0L) {
            m_receiveStat.clientStarted(this);
        }
    }

    private void exit() {
        try {
            this.m_connection.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public long getErrorCount() {
        return this.m_errorCount;
    }

    public long getMessageCount() {
        return this.m_msgCount;
    }

    public int getThreadId() {
        return this.m_ownThreadId;
    }

    public void onException(JMSException jsme) {
        this.println("*** Exit Receiver due to:");
        this.println("*** " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        ++this.m_msgCount;
        try {
            int msgType;
            boolean isTransient;
            if (this.m_msgCount == this.m_rollbackTrigger) {
                this.m_session.rollback();
            }
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            String msgID = message.getJMSMessageID();
            int msgPrio = message.getJMSPriority();
            boolean wrongMsgOrder = false;
            boolean bl = isTransient = textMessage.getJMSDeliveryMode() == 1;
            int n = msgPrio == 9 ? (isTransient ? 3 : 2) : (msgType = isTransient ? 1 : 0);
            if (!(m_noCheck || this.m_lastMsgText[msgType].compareTo(text) < 0 && this.m_lastMsgID[msgType].compareTo(msgID) < 0)) {
                wrongMsgOrder = true;
                ++this.m_errorCount;
            }
            if (this.m_msgCount <= 3L || this.m_msgCount % 2000L == 0L || msgPrio == 9 || wrongMsgOrder) {
                String prioMsg;
                if (this.m_msgCount > 3L) {
                    if (m_transacted) {
                        this.m_session.commit();
                        m_receiveStat.addCommits(1990L);
                        this.m_rollbackTrigger = this.m_msgCount + 10L;
                    } else if (m_acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                }
                boolean isRedelivered = textMessage.getJMSRedelivered();
                String out = null;
                String id = " [msgID: " + msgID + "]";
                String string = prioMsg = message.getJMSPriority() > 0 ? " prio " + message.getJMSPriority() : "";
                out = isTransient ? (isRedelivered ? this.m_msgCount + prioMsg + " (transient, redelivered): " : this.m_msgCount + prioMsg + " (transient): ") : (isRedelivered ? this.m_msgCount + prioMsg + " (redelivered): " : this.m_msgCount + prioMsg + ": ");
                out = text.length() > 64 ? out + text.substring(0, 64) : out + text;
                if (wrongMsgOrder) {
                    out = "*** " + out + " [last: " + this.m_lastMsgText[msgType] + " lastID: " + this.m_lastMsgID[msgType] + "]";
                }
                if (textMessage.propertyExists("IntProperty")) {
                    String propText = null;
                    try {
                        propText = " (intProp: " + textMessage.getIntProperty("IntProperty") + ", strProp: '" + textMessage.getStringProperty("StringProperty") + "') ";
                    }
                    catch (Exception rte) {
                        propText = "(***Properties: " + rte.toString() + ")";
                    }
                    this.println(out + propText + id);
                } else {
                    this.println(out + id);
                }
                if (this.m_msgCount == 1L) {
                    m_receiveStat.clientStarted(this);
                }
            }
            this.m_lastMsgID[msgType] = msgID;
            this.m_lastMsgText[msgType] = text;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            System.exit(0);
        }
        m_receiveStat.incrSumMessages();
    }

    private void println(String msg) {
        System.out.println("T" + this.m_ownThreadId + ": " + msg);
    }

    private class SyncClient
    extends Thread {
        MassTopicSubscriber m_client;
        TopicSubscriber m_receiver;

        SyncClient(MassTopicSubscriber client, TopicSubscriber receiver) {
            this.m_client = client;
            this.m_receiver = receiver;
        }

        public void run() {
            boolean msgReceived;
            this.m_client.println("synchronous receiver started");
            do {
                msgReceived = false;
                try {
                    Message msg = this.m_receiver.receiveNoWait();
                    if (msg == null) {
                        this.m_client.println("null message received");
                        this.m_client.emptySynchronousMessageReceived();
                        break;
                    }
                    this.m_client.onMessage(msg);
                    msgReceived = true;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    this.m_client.onException(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_client.exit();
                }
            } while (msgReceived);
            this.m_client.println("synchronous receiver stopped");
        }
    }
}

