/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PExec
extends Thread {
    private String mCmd;
    private String[] mCmdarry;
    private File mRunDir;
    private String[] mEnvp;
    private StringBuffer mBuffer;
    private PrintWriter mWriter;
    private String mErrPrefix;
    private String mOutPrefix;
    private String mLineSep;
    private BufferedReader mErrReader;
    private BufferedReader mOutReader;
    private Process mProcess;
    private int mExitValue;
    private long mTimeout = 0L;
    private boolean mIsDestroyed = false;
    private boolean mHasTokenizedCmdl = false;
    private Timer mTimer;

    public PExec(String cmd, String[] envp) {
        this.initialize(cmd, envp, null, null);
    }

    public PExec(String cmd, String[] envp, PrintWriter pWriter) {
        this.initialize(cmd, envp, null, pWriter);
    }

    public PExec(String[] cmd, String[] envp, File rundir, PrintWriter pWriter) {
        this.initialize(cmd, envp, rundir, null, pWriter);
    }

    public PExec(String cmd, String[] envp, StringBuffer pBuffer) {
        this.initialize(cmd, envp, pBuffer, null);
    }

    private void appendErrLine(String pLine) {
        if (this.mBuffer != null) {
            this.mBuffer.append(this.mErrPrefix + pLine + this.mLineSep);
        }
        if (this.mWriter != null) {
            this.mWriter.println(this.mErrPrefix + pLine);
        }
    }

    private void appendException(Exception e, String msg) {
        if (this.mBuffer != null) {
            StringWriter wrt = new StringWriter();
            PrintWriter pwt = new PrintWriter(wrt);
            e.printStackTrace(pwt);
            this.mBuffer.append("*** " + msg + this.mLineSep);
            this.mBuffer.append(wrt.toString());
        }
        if (this.mWriter != null) {
            this.mWriter.println("*** " + msg);
            e.printStackTrace(this.mWriter);
        }
    }

    private void appendOutLine(String pLine) {
        if (this.mBuffer != null) {
            this.mBuffer.append(this.mOutPrefix + pLine + this.mLineSep);
        }
        if (this.mWriter != null) {
            this.mWriter.println(this.mOutPrefix + pLine);
        }
    }

    public void exec() {
        try {
            this.mProcess = this.mHasTokenizedCmdl ? Runtime.getRuntime().exec(this.mCmdarry, this.mEnvp, this.mRunDir) : Runtime.getRuntime().exec(this.mCmd, this.mEnvp);
            this.start();
            Timer timer = new Timer(this.mTimeout);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                this.appendException(e, "joining exec stdout thread");
            }
            try {
                this.mProcess.waitFor();
            }
            catch (InterruptedException e) {
                this.appendException(e, "waiting for exec process");
            }
            timer.pleaseStop();
            this.mExitValue = this.mProcess.exitValue();
        }
        catch (IOException e) {
            this.appendException(e, "execing process " + this.mCmd);
        }
    }

    public void execNoWait() {
        try {
            this.mProcess = this.mHasTokenizedCmdl ? Runtime.getRuntime().exec(this.mCmdarry, this.mEnvp, this.mRunDir) : Runtime.getRuntime().exec(this.mCmd, this.mEnvp);
            this.start();
            this.mTimer = new Timer(this.mTimeout);
        }
        catch (IOException e) {
            this.appendException(e, "execing process " + this.mCmd);
        }
    }

    public void waitFor() {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            this.appendException(e, "joining exec stdout thread");
        }
        try {
            this.mProcess.waitFor();
        }
        catch (InterruptedException e) {
            this.appendException(e, "waiting for exec process");
        }
        this.mTimer.pleaseStop();
        this.mExitValue = this.mProcess.exitValue();
    }

    public int getExitValue() {
        return this.mExitValue;
    }

    private void initialize(String cmd, String[] envp, StringBuffer pBuffer, PrintWriter pWriter) {
        this.mExitValue = -1;
        this.mCmd = cmd;
        this.mCmd = cmd;
        this.mEnvp = envp;
        this.mBuffer = pBuffer;
        this.mWriter = pWriter;
        this.mErrPrefix = "";
        this.mOutPrefix = "";
        this.mLineSep = System.getProperty("line.separator", "\n");
    }

    private void initialize(String[] cmd, String[] envp, File rundir, StringBuffer pBuffer, PrintWriter pWriter) {
        this.mExitValue = -1;
        this.mCmdarry = cmd;
        this.mCmd = cmd[0];
        this.mHasTokenizedCmdl = true;
        this.mRunDir = rundir;
        this.mEnvp = envp;
        this.mBuffer = pBuffer;
        this.mWriter = pWriter;
        this.mErrPrefix = "";
        this.mOutPrefix = "";
        this.mLineSep = System.getProperty("line.separator", "\n");
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public void run() {
        try {
            String line;
            this.mProcess.getOutputStream().close();
            this.mErrReader = new BufferedReader(new InputStreamReader(this.mProcess.getErrorStream()));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String line = null;
                        while ((line = PExec.this.mErrReader.readLine()) != null) {
                            PExec.this.appendErrLine(line);
                        }
                    }
                    catch (IOException e) {
                        PExec.this.appendException(e, "Reading exec stderr stream");
                    }
                }
            });
            t.setPriority(10);
            t.start();
            this.mOutReader = new BufferedReader(new InputStreamReader(this.mProcess.getInputStream()));
            this.setPriority(10);
            while ((line = this.mOutReader.readLine()) != null) {
                this.appendOutLine(line);
            }
            this.mOutReader.close();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.appendException(e, "joining exec stderr thread");
            }
        }
        catch (IOException e) {
            this.appendException(e, "reading exec stdout stream");
        }
    }

    public void setErrPrefix(String pPrefix) {
        this.mErrPrefix = pPrefix;
    }

    public void setOutPrefix(String pPrefix) {
        this.mOutPrefix = pPrefix;
    }

    public void setTimeout(int pTimeout) {
        this.mTimeout = pTimeout * 1000;
    }

    public void setTimeoutMillis(long pTimeout) {
        this.mTimeout = pTimeout;
    }

    class Timer
    extends Thread {
        long startTime = 0L;
        long elapsedTime;
        long Timeout;
        boolean keepRuning = true;

        public Timer(long timeout) {
            if (timeout != 0L) {
                this.start();
                this.startTime = System.currentTimeMillis();
                this.Timeout = timeout;
            }
        }

        public void run() {
            while (this.keepRuning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.elapsedTime = System.currentTimeMillis() - this.startTime;
                if (this.elapsedTime <= this.Timeout) continue;
                PExec.this.mProcess.destroy();
                this.pleaseStop();
                PExec.this.appendOutLine("Subprocess destroyed after timeout");
                PExec.this.mIsDestroyed = true;
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }
}

