/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.QName;
import org.apache.xpath.Arg;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public class VariableStack
extends Stack {
    private IntStack m_elemFramePos = new IntStack();
    private static final Stack m_emptyStackFrame = new Stack();
    private int m_globalStackFrameIndex = -1;
    private int m_searchStart = -1;

    public VariableStack() {
        this.pushContextMarker();
    }

    private Stack allocateCurrentFrame() {
        int stackFrameIndex = this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
        Stack newFrame = new Stack();
        this.setElementAt(newFrame, stackFrameIndex);
        return newFrame;
    }

    public int getContextPos() {
        return this.size() - 1;
    }

    private Stack getCurrentFrame() {
        int stackFrameIndex = this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
        return (Stack)this.elementAt(stackFrameIndex);
    }

    public Arg getDeclaredVariable(QName qname) throws TransformerException {
        Stack frame = this.getCurrentFrame();
        int i2 = frame.size() - 1;
        while (i2 >= 0) {
            Object obj = frame.elementAt(i2);
            if (((Arg)obj).getQName().equals(qname)) {
                return (Arg)obj;
            }
            --i2;
        }
        Stack gframe = (Stack)this.elementAt(0);
        if (gframe == frame) {
            return null;
        }
        int i3 = gframe.size() - 1;
        while (i3 >= 0) {
            Object obj = gframe.elementAt(i3);
            if (((Arg)obj).getQName().equals(qname)) {
                return (Arg)obj;
            }
            --i3;
        }
        return null;
    }

    public Arg getParamArg(QName qname) throws TransformerException {
        Object val = null;
        Stack frame = this.getCurrentFrame();
        int i2 = frame.size() - 1;
        while (i2 >= 0) {
            Arg arg = (Arg)frame.elementAt(i2);
            if (arg.getQName().equals(qname) && arg.isFromWithParam()) {
                return arg;
            }
            --i2;
        }
        return null;
    }

    public int getSearchStart() {
        return this.m_searchStart;
    }

    public int getSearchStartOrTop() {
        return this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
    }

    public XObject getVariable(XPathContext xctxt, QName name) throws TransformerException {
        Arg arg;
        int i2;
        Stack gframe;
        Stack frame = this.getCurrentFrame();
        if (frame != (gframe = (Stack)this.elementAt(0))) {
            i2 = frame.size() - 1;
            while (i2 >= 0) {
                arg = (Arg)frame.elementAt(i2);
                if (arg.getQName().equals(name) && arg.isVisible()) {
                    XObject val = arg.getVal();
                    if (val.getType() == 600) {
                        val = val.execute(xctxt);
                        arg.setVal(val);
                    }
                    return val;
                }
                --i2;
            }
        }
        i2 = gframe.size() - 1;
        while (i2 >= 0) {
            arg = (Arg)gframe.elementAt(i2);
            if (arg.getQName().equals(name) && arg.isVisible()) {
                XObject val = arg.getVal();
                if (val.getType() == 600) {
                    val = val.execute(xctxt);
                    arg.setVal(val);
                }
                return val;
            }
            --i2;
        }
        return null;
    }

    public void markGlobalStackFrame() {
        this.m_globalStackFrameIndex = this.size();
    }

    public void popContextPosition() {
    }

    public void popCurrentContext() {
        this.pop();
    }

    public void popElemFrame() {
        Stack frame = this.getCurrentFrame();
        int newSize = this.m_elemFramePos.pop();
        frame.setSize(newSize);
    }

    public void pushContextMarker() {
        this.push(m_emptyStackFrame);
    }

    public void pushContextPosition(int pos) {
    }

    public void pushElemFrame() {
        Stack frame = this.getCurrentFrame();
        this.m_elemFramePos.push(frame.size());
    }

    public void pushOrReplaceParameter(QName qname, XObject xval) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        int i2 = frame.size() - 1;
        while (i2 >= 0) {
            Arg arg = (Arg)frame.elementAt(i2);
            if (arg.getQName().equals(qname) && arg.isFromWithParam()) {
                frame.setElementAt(new Arg(qname, xval, true), i2);
                return;
            }
            --i2;
        }
        frame.push(new Arg(qname, xval, true));
    }

    public void pushVariable(QName qname, XObject val) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        frame.push(new Arg(qname, val, false));
    }

    public void pushVariableArg(Arg arg) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        frame.push(arg);
    }

    public void remarkParams() {
        Stack frame = this.getCurrentFrame();
        int i2 = frame.size() - 1;
        while (i2 >= 0) {
            Arg arg = (Arg)frame.elementAt(i2);
            if (arg != null) {
                arg.setIsVisible(false);
            }
            --i2;
        }
    }

    public void setSearchStart(int startPos) {
        this.m_searchStart = startPos;
    }
}

