/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.URI;

public class SystemIDResolver {
    public static String getAbsoluteURI(String url) throws TransformerException {
        if (url.indexOf(58) < 0) {
            url = SystemIDResolver.getAbsoluteURIFromRelative(url);
        }
        return url;
    }

    public static String getAbsoluteURI(String urlString, String base) throws TransformerException {
        URI uri;
        boolean isAbsouteUrl = false;
        if (urlString.indexOf(58) > 0) {
            isAbsouteUrl = true;
        }
        if (!(isAbsouteUrl || base != null && base.indexOf(58) >= 0)) {
            base = SystemIDResolver.getAbsoluteURIFromRelative(base);
        }
        if (base != null && urlString.startsWith("file:") && urlString.charAt(5) != '/') {
            if (base.equals(urlString)) {
                base = "";
            } else {
                urlString = urlString.substring(5);
                isAbsouteUrl = false;
            }
        }
        if (base != null && base.indexOf(92) > -1) {
            base = base.replace('\\', '/');
        }
        if (urlString != null && urlString.indexOf(92) > -1) {
            urlString = urlString.replace('\\', '/');
        }
        try {
            if (base == null || base.length() == 0 || isAbsouteUrl) {
                uri = new URI(urlString);
            } else {
                URI baseURI = new URI(base);
                uri = new URI(baseURI, urlString);
            }
        }
        catch (URI.MalformedURIException mue) {
            throw new TransformerException(mue);
        }
        String uriStr = uri.toString();
        return uriStr;
    }

    public static String getAbsoluteURIFromRelative(String uri) {
        String curdir = System.getProperty("user.dir");
        if (curdir != null) {
            uri = uri != null ? "file:///" + curdir + System.getProperty("file.separator") + uri : "file:///" + curdir + System.getProperty("file.separator");
        }
        if (uri != null && uri.indexOf(92) > -1) {
            uri = uri.replace('\\', '/');
        }
        return uri;
    }
}

