/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOMHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TreeWalker2Result
extends TreeWalker {
    TransformerImpl m_transformer;
    ResultTreeHandler m_handler;
    Node m_startNode;

    public TreeWalker2Result(TransformerImpl transformer, ResultTreeHandler handler) {
        super(handler, transformer.getXPathContext().getDOMHelper());
        this.m_transformer = transformer;
        this.m_handler = handler;
    }

    protected void startNode(Node node) throws SAXException {
        try {
            if (node.getNodeType() == 1 && this.m_startNode == node) {
                DOMHelper dhelper = this.m_transformer.getXPathContext().getDOMHelper();
                String elemName = node.getNodeName();
                String localName = dhelper.getLocalNameOfNode(node);
                String namespace = dhelper.getNamespaceOfNode(node);
                this.m_handler.startElement(namespace, localName, elemName, null);
                Node parent = node;
                while (parent != null) {
                    if (parent.getNodeType() == 1) {
                        NamedNodeMap atts = ((Element)parent).getAttributes();
                        int n2 = atts.getLength();
                        int i2 = 0;
                        while (i2 < n2) {
                            String nsDeclPrefix = null;
                            Attr attr = (Attr)atts.item(i2);
                            String name = attr.getName();
                            String value = attr.getValue();
                            if (name.startsWith("xmlns:")) {
                                nsDeclPrefix = name.substring(name.indexOf(":") + 1);
                            } else if (name.equals("xmlns")) {
                                nsDeclPrefix = "";
                            }
                            if (nsDeclPrefix != null || node == parent) {
                                this.m_handler.addAttribute(dhelper.getNamespaceOfNode(attr), dhelper.getLocalNameOfNode(attr), name, "CDATA", value);
                            }
                            ++i2;
                        }
                    }
                    parent = parent.getParentNode();
                }
            } else {
                super.startNode(node);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void traverse(Node pos) throws SAXException {
        this.m_startNode = pos;
        super.traverse(pos);
    }
}

