/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import org.apache.xalan.stree.CommentImpl;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.TextImpl;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StreeDOMBuilder
extends DOMBuilder {
    TextImpl m_text_buffer = null;
    protected DocumentImpl m_docImpl;
    private boolean m_previousIsText = false;
    private static final boolean DEBUG = false;

    public StreeDOMBuilder(Document doc) {
        super(doc);
        this.m_docImpl = (DocumentImpl)doc;
    }

    public StreeDOMBuilder(Document doc, DocumentFragment docFrag) {
        super(doc, docFrag);
        this.m_docImpl = (DocumentImpl)doc;
    }

    public StreeDOMBuilder(Document doc, Node node) {
        super(doc, node);
        this.m_docImpl = (DocumentImpl)doc;
    }

    void appendAccumulatedText(Node currentNode, char[] ch2, int start, int length) throws SAXException {
        if (this.m_text_buffer == null) {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch2, start, length);
            this.setPreviousIsText(true);
        } else {
            this.m_text_buffer.appendText(ch2, start, length);
        }
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, ch2, start, length);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch2, start, length);
            this.setPreviousIsText(true);
        }
    }

    public void charactersRaw(char[] ch2, int start, int length) throws SAXException {
        this.setPreviousIsText(false);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(new TextImpl(this.m_docImpl, ch2, start, length));
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        this.setPreviousIsText(false);
        this.append(new CommentImpl(this.m_docImpl, ch2, start, length));
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.setPreviousIsText(false);
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.setPreviousIsText(false);
        super.endElement(ns, localName, name);
    }

    boolean getPreviousIsText() {
        return this.m_previousIsText;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, ch2, start, length);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch2, start, length);
        }
        this.setPreviousIsText(true);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.setPreviousIsText(false);
        super.processingInstruction(target, data);
    }

    public void setIDAttribute(String id, Element elem) {
        this.m_docImpl.setIDAttribute(id, elem);
    }

    public void setPreviousIsText(boolean isText) throws SAXException {
        if (this.m_previousIsText && !isText) {
            if (!this.m_docImpl.m_sourceTreeHandler.getShouldStripWhitespace() || !this.m_text_buffer.isWhitespace()) {
                this.append(this.m_text_buffer);
            }
            this.m_text_buffer = null;
        }
        this.m_previousIsText = isText;
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        this.setPreviousIsText(false);
        ElementImpl elem = ns == null || ns.length() == 0 ? (ElementImpl)this.m_doc.createElement(name) : (ElementImpl)this.m_doc.createElementNS(ns, name);
        elem.m_uid = ++((DocImpl)this.m_doc).m_docOrderCount;
        elem.m_level = (short)(((DocImpl)this.m_doc).m_level + 1);
        int nAtts = atts.getLength();
        if (nAtts != 0) {
            int i2 = 0;
            while (i2 < nAtts) {
                String attrNS;
                if (atts.getType(i2).equalsIgnoreCase("ID")) {
                    this.setIDAttribute(atts.getValue(i2), elem);
                }
                if ((attrNS = atts.getURI(i2)) == null) {
                    attrNS = "";
                }
                if (attrNS.length() == 0 || atts.getQName(i2).startsWith("xmlns:")) {
                    elem.setAttribute(atts.getQName(i2), atts.getValue(i2));
                } else {
                    elem.setAttributeNS(attrNS, atts.getQName(i2), atts.getValue(i2));
                }
                ++i2;
            }
        }
        this.append(elem);
        this.m_elemStack.push(elem);
        this.m_currentNode = elem;
    }
}

