/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemText;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.xml.sax.SAXException;

public class ProcessorCharacters
extends XSLTElementProcessor {
    private StringBuffer m_accumulator = new StringBuffer();
    private ElemText m_xslTextElement;

    public void characters(StylesheetHandler handler, char[] ch2, int start, int length) throws SAXException {
        this.m_accumulator.append(ch2, start, length);
        if (this != handler.getCurrentProcessor()) {
            handler.pushProcessor(this);
        }
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        this.startNonText(handler);
        handler.getCurrentProcessor().endElement(handler, uri, localName, rawName);
        handler.popProcessor();
    }

    void setXslTextElement(ElemText xslTextElement) {
        this.m_xslTextElement = xslTextElement;
    }

    public void startNonText(StylesheetHandler handler) throws SAXException {
        int nChars;
        if (this == handler.getCurrentProcessor()) {
            handler.popProcessor();
        }
        if ((nChars = this.m_accumulator.length()) > 0 && (this.m_xslTextElement != null || !XMLCharacterRecognizer.isWhiteSpace(this.m_accumulator)) || handler.isSpacePreserve()) {
            ElemTextLiteral elem = new ElemTextLiteral();
            elem.setDOMBackPointer(handler.getOriginatingNode());
            elem.setLocaterInfo(handler.getLocator());
            try {
                elem.setPrefixes(handler.getNamespaceSupport());
            }
            catch (TransformerException te) {
                throw new SAXException(te);
            }
            boolean doe = this.m_xslTextElement != null ? this.m_xslTextElement.getDisableOutputEscaping() : false;
            elem.setDisableOutputEscaping(doe);
            elem.setPreserveSpace(true);
            char[] chars = new char[nChars];
            this.m_accumulator.getChars(0, nChars, chars, 0);
            elem.setChars(chars);
            ElemTemplateElement parent = handler.getElemTemplateElement();
            parent.appendChild(elem);
        }
        this.m_accumulator.setLength(0);
    }
}

