/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class MethodResolver {
    public static final int STATIC_ONLY = 1;
    public static final int INSTANCE_ONLY = 2;
    public static final int STATIC_AND_INSTANCE = 3;
    public static final int DYNAMIC = 4;
    private static final int SCOREBASE = 1;
    static ConversionInfo[] m_javaObjConversions = new ConversionInfo[]{new ConversionInfo(Double.TYPE, 11), new ConversionInfo(Float.TYPE, 12), new ConversionInfo(Long.TYPE, 13), new ConversionInfo(Integer.TYPE, 14), new ConversionInfo(Short.TYPE, 15), new ConversionInfo(Character.TYPE, 16), new ConversionInfo(Byte.TYPE, 17), new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 18)};
    static ConversionInfo[] m_booleanConversions = new ConversionInfo[]{new ConversionInfo(Boolean.TYPE, 0), new ConversionInfo(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = MethodResolver.class$("java.lang.Boolean")), 1), new ConversionInfo(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")), 2), new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 3)};
    static ConversionInfo[] m_numberConversions = new ConversionInfo[]{new ConversionInfo(Double.TYPE, 0), new ConversionInfo(class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = MethodResolver.class$("java.lang.Double")), 1), new ConversionInfo(Float.TYPE, 3), new ConversionInfo(Long.TYPE, 4), new ConversionInfo(Integer.TYPE, 5), new ConversionInfo(Short.TYPE, 6), new ConversionInfo(Character.TYPE, 7), new ConversionInfo(Byte.TYPE, 8), new ConversionInfo(Boolean.TYPE, 9), new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 10), new ConversionInfo(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")), 11)};
    static ConversionInfo[] m_stringConversions = new ConversionInfo[]{new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 0), new ConversionInfo(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")), 1), new ConversionInfo(Character.TYPE, 2), new ConversionInfo(Double.TYPE, 3), new ConversionInfo(Float.TYPE, 3), new ConversionInfo(Long.TYPE, 3), new ConversionInfo(Integer.TYPE, 3), new ConversionInfo(Short.TYPE, 3), new ConversionInfo(Byte.TYPE, 3), new ConversionInfo(Boolean.TYPE, 4)};
    static ConversionInfo[] m_rtfConversions = new ConversionInfo[]{new ConversionInfo(class$org$w3c$dom$traversal$NodeIterator != null ? class$org$w3c$dom$traversal$NodeIterator : (class$org$w3c$dom$traversal$NodeIterator = MethodResolver.class$("org.w3c.dom.traversal.NodeIterator")), 0), new ConversionInfo(class$org$w3c$dom$NodeList != null ? class$org$w3c$dom$NodeList : (class$org$w3c$dom$NodeList = MethodResolver.class$("org.w3c.dom.NodeList")), 1), new ConversionInfo(class$org$w3c$dom$Node != null ? class$org$w3c$dom$Node : (class$org$w3c$dom$Node = MethodResolver.class$("org.w3c.dom.Node")), 2), new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 3), new ConversionInfo(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")), 5), new ConversionInfo(Character.TYPE, 6), new ConversionInfo(Double.TYPE, 7), new ConversionInfo(Float.TYPE, 7), new ConversionInfo(Long.TYPE, 7), new ConversionInfo(Integer.TYPE, 7), new ConversionInfo(Short.TYPE, 7), new ConversionInfo(Byte.TYPE, 7), new ConversionInfo(Boolean.TYPE, 8)};
    static ConversionInfo[] m_nodesetConversions = new ConversionInfo[]{new ConversionInfo(class$org$w3c$dom$traversal$NodeIterator != null ? class$org$w3c$dom$traversal$NodeIterator : (class$org$w3c$dom$traversal$NodeIterator = MethodResolver.class$("org.w3c.dom.traversal.NodeIterator")), 0), new ConversionInfo(class$org$w3c$dom$NodeList != null ? class$org$w3c$dom$NodeList : (class$org$w3c$dom$NodeList = MethodResolver.class$("org.w3c.dom.NodeList")), 1), new ConversionInfo(class$org$w3c$dom$Node != null ? class$org$w3c$dom$Node : (class$org$w3c$dom$Node = MethodResolver.class$("org.w3c.dom.Node")), 2), new ConversionInfo(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")), 3), new ConversionInfo(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")), 5), new ConversionInfo(Character.TYPE, 6), new ConversionInfo(Double.TYPE, 7), new ConversionInfo(Float.TYPE, 7), new ConversionInfo(Long.TYPE, 7), new ConversionInfo(Integer.TYPE, 7), new ConversionInfo(Short.TYPE, 7), new ConversionInfo(Byte.TYPE, 7), new ConversionInfo(Boolean.TYPE, 8)};
    static ConversionInfo[][] m_conversions = new ConversionInfo[][]{m_javaObjConversions, m_booleanConversions, m_numberConversions, m_stringConversions, m_nodesetConversions, m_rtfConversions};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$w3c$dom$traversal$NodeIterator;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$org$apache$xalan$extensions$ExpressionContext;
    static /* synthetic */ Class class$org$apache$xalan$templates$ElemExtensionCall;
    static /* synthetic */ Class class$org$apache$xalan$extensions$XSLProcessorContext;
    static /* synthetic */ Class class$java$lang$Class;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static Object convert(Object xsltObj, Class javaClass) throws TransformerException {
        if (xsltObj instanceof XObject) {
            XObject xobj = (XObject)xsltObj;
            int xsltClassType = xobj.getType();
            switch (xsltClassType) {
                case -1: {
                    return null;
                }
                case 1: {
                    if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")))) {
                        return xobj.str();
                    }
                    return new Boolean(xobj.bool());
                }
                case 2: {
                    if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")))) {
                        return xobj.str();
                    }
                    if (javaClass == Boolean.TYPE) {
                        return new Boolean(xobj.bool());
                    }
                    return MethodResolver.convertDoubleToNumber(xobj.num(), javaClass);
                }
                case 3: {
                    if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String"))) || javaClass == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")))) {
                        return xobj.str();
                    }
                    if (javaClass == Character.TYPE) {
                        String str = xobj.str();
                        if (str.length() > 0) {
                            return new Character(str.charAt(0));
                        }
                        return null;
                    }
                    if (javaClass == Boolean.TYPE) {
                        return new Boolean(xobj.bool());
                    }
                    return MethodResolver.convertDoubleToNumber(xobj.num(), javaClass);
                }
                case 5: {
                    if (javaClass == (class$org$w3c$dom$traversal$NodeIterator != null ? class$org$w3c$dom$traversal$NodeIterator : (class$org$w3c$dom$traversal$NodeIterator = MethodResolver.class$("org.w3c.dom.traversal.NodeIterator"))) || javaClass == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")))) {
                        return ((XRTreeFrag)xobj).asNodeIterator();
                    }
                    if (javaClass == (class$org$w3c$dom$NodeList != null ? class$org$w3c$dom$NodeList : (class$org$w3c$dom$NodeList = MethodResolver.class$("org.w3c.dom.NodeList")))) {
                        return ((XRTreeFrag)xobj).convertToNodeset();
                    }
                    if (javaClass == (class$org$w3c$dom$Node != null ? class$org$w3c$dom$Node : (class$org$w3c$dom$Node = MethodResolver.class$("org.w3c.dom.Node")))) {
                        return xobj.rtree().getFirstChild();
                    }
                    if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")))) {
                        return xobj.str();
                    }
                    if (javaClass == Boolean.TYPE) {
                        return new Boolean(xobj.bool());
                    }
                    if (javaClass.isPrimitive()) {
                        return MethodResolver.convertDoubleToNumber(xobj.num(), javaClass);
                    }
                    Node child = xobj.rtree().getFirstChild();
                    if (javaClass.isAssignableFrom(child.getClass())) {
                        return child;
                    }
                    return null;
                }
                case 4: {
                    if (javaClass == (class$org$w3c$dom$traversal$NodeIterator != null ? class$org$w3c$dom$traversal$NodeIterator : (class$org$w3c$dom$traversal$NodeIterator = MethodResolver.class$("org.w3c.dom.traversal.NodeIterator"))) || javaClass == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = MethodResolver.class$("java.lang.Object")))) {
                        return xobj.nodeset();
                    }
                    if (javaClass == (class$org$w3c$dom$NodeList != null ? class$org$w3c$dom$NodeList : (class$org$w3c$dom$NodeList = MethodResolver.class$("org.w3c.dom.NodeList")))) {
                        return xobj.mutableNodeset();
                    }
                    if (javaClass == (class$org$w3c$dom$Node != null ? class$org$w3c$dom$Node : (class$org$w3c$dom$Node = MethodResolver.class$("org.w3c.dom.Node")))) {
                        NodeIterator ni = xobj.nodeset();
                        return ni.nextNode();
                    }
                    if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")))) {
                        return xobj.str();
                    }
                    if (javaClass == Boolean.TYPE) {
                        return new Boolean(xobj.bool());
                    }
                    if (javaClass.isPrimitive()) {
                        return MethodResolver.convertDoubleToNumber(xobj.num(), javaClass);
                    }
                    Node child = xobj.nodeset().nextNode();
                    if (javaClass.isAssignableFrom(child.getClass())) {
                        return child;
                    }
                    return null;
                }
            }
            xsltObj = xobj.object();
        }
        if (javaClass == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MethodResolver.class$("java.lang.String")))) {
            return xsltObj.toString();
        }
        if (javaClass.isPrimitive()) {
            XString xstr = new XString(xsltObj.toString());
            double num = xstr.num();
            return MethodResolver.convertDoubleToNumber(num, javaClass);
        }
        if (javaClass == (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = MethodResolver.class$("java.lang.Class")))) {
            return xsltObj.getClass();
        }
        return xsltObj;
    }

    static Object convertDoubleToNumber(double num, Class javaClass) {
        if (javaClass == Double.TYPE || javaClass == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = MethodResolver.class$("java.lang.Double")))) {
            return new Double(num);
        }
        if (javaClass == Float.TYPE) {
            return new Float(num);
        }
        if (javaClass == Long.TYPE) {
            return new Long((long)num);
        }
        if (javaClass == Integer.TYPE) {
            return new Integer((int)num);
        }
        if (javaClass == Short.TYPE) {
            return new Short((short)num);
        }
        if (javaClass == Character.TYPE) {
            return new Character((char)num);
        }
        if (javaClass == Byte.TYPE) {
            return new Byte((byte)num);
        }
        return new Double(num);
    }

    public static void convertParams(Object[] argsIn, Object[][] argsOut, Class[] paramTypes, ExpressionContext exprContext) throws TransformerException {
        if (paramTypes == null) {
            argsOut[0] = null;
        } else {
            int nParams = paramTypes.length;
            argsOut[0] = new Object[nParams];
            int paramIndex = 0;
            if (nParams > 0 && (class$org$apache$xalan$extensions$ExpressionContext != null ? class$org$apache$xalan$extensions$ExpressionContext : (class$org$apache$xalan$extensions$ExpressionContext = MethodResolver.class$("org.apache.xalan.extensions.ExpressionContext"))).isAssignableFrom(paramTypes[0])) {
                argsOut[0][0] = exprContext;
                ++paramIndex;
            }
            if (argsIn != null) {
                int i2 = argsIn.length - nParams + paramIndex;
                while (paramIndex < nParams) {
                    argsOut[0][paramIndex] = MethodResolver.convert(argsIn[i2], paramTypes[paramIndex]);
                    ++i2;
                    ++paramIndex;
                }
            }
        }
    }

    private static String errArgs(Object[] xsltArgs, int startingArg) {
        StringBuffer returnArgs = new StringBuffer();
        int i2 = startingArg;
        while (i2 < xsltArgs.length) {
            if (i2 != startingArg) {
                returnArgs.append(", ");
            }
            if (xsltArgs[i2] instanceof XObject) {
                returnArgs.append(((XObject)xsltArgs[i2]).getTypeString());
            } else {
                returnArgs.append(xsltArgs[i2].getClass().getName());
            }
            ++i2;
        }
        return returnArgs.toString();
    }

    private static String errString(String callType, String searchType, Class classObj, String funcName, int searchMethod, Object[] xsltArgs) {
        String resultString = "For extension " + callType + ", could not find " + searchType + " ";
        switch (searchMethod) {
            case 1: {
                return String.valueOf(resultString) + "static " + classObj.getName() + "." + funcName + "([ExpressionContext,] " + MethodResolver.errArgs(xsltArgs, 0) + ").";
            }
            case 2: {
                return String.valueOf(resultString) + classObj.getName() + "." + funcName + "([ExpressionContext,] " + MethodResolver.errArgs(xsltArgs, 0) + ").";
            }
            case 3: {
                return String.valueOf(resultString) + classObj.getName() + "." + funcName + "([ExpressionContext,] " + MethodResolver.errArgs(xsltArgs, 0) + ").\n" + "Checked both static and instance methods.";
            }
            case 4: {
                return String.valueOf(resultString) + "static " + classObj.getName() + "." + funcName + "([ExpressionContext, ]" + MethodResolver.errArgs(xsltArgs, 0) + ") nor\n" + classObj + "." + funcName + "([ExpressionContext,] " + MethodResolver.errArgs(xsltArgs, 1) + ").";
            }
        }
        if (callType.equals("function")) {
            return String.valueOf(resultString) + classObj.getName() + "([ExpressionContext,] " + MethodResolver.errArgs(xsltArgs, 0) + ").";
        }
        return String.valueOf(resultString) + classObj.getName() + "." + funcName + "(org.apache.xalan.extensions.XSLProcessorContext, " + "org.apache.xalan.templates.ElemExtensionCall).";
    }

    public static Constructor getConstructor(Class classObj, Object[] argsIn, Object[][] argsOut, ExpressionContext exprContext) throws NoSuchMethodException, SecurityException, TransformerException {
        Constructor<?> bestConstructor = null;
        Class[] bestParamTypes = null;
        Constructor<?>[] constructors = classObj.getConstructors();
        int nMethods = constructors.length;
        int bestScore = Integer.MAX_VALUE;
        int bestScoreCount = 0;
        int i2 = 0;
        while (i2 < nMethods) {
            block7: {
                int score;
                int scoreStart;
                int paramStart;
                int numberMethodParams;
                Class[] paramTypes;
                Constructor<?> ctor;
                block8: {
                    block6: {
                        Class<?> javaClass;
                        ctor = constructors[i2];
                        paramTypes = ctor.getParameterTypes();
                        numberMethodParams = paramTypes.length;
                        paramStart = 0;
                        boolean isFirstExpressionContext = false;
                        if (numberMethodParams != argsIn.length + 1) break block6;
                        if (!(class$org$apache$xalan$extensions$ExpressionContext != null ? class$org$apache$xalan$extensions$ExpressionContext : MethodResolver.class$("org.apache.xalan.extensions.ExpressionContext")).isAssignableFrom(javaClass = paramTypes[0])) break block7;
                        isFirstExpressionContext = true;
                        scoreStart = 0;
                        ++paramStart;
                        break block8;
                    }
                    scoreStart = 1000;
                }
                if (argsIn.length == numberMethodParams - paramStart && (score = MethodResolver.scoreMatch(paramTypes, paramStart, argsIn, scoreStart)) != -1) {
                    if (score < bestScore) {
                        bestConstructor = ctor;
                        bestParamTypes = paramTypes;
                        bestScore = score;
                        bestScoreCount = 1;
                    } else if (score == bestScore) {
                        ++bestScoreCount;
                    }
                }
            }
            ++i2;
        }
        if (bestConstructor == null) {
            throw new NoSuchMethodException(MethodResolver.errString("function", "constructor", classObj, "", 0, argsIn));
        }
        MethodResolver.convertParams(argsIn, argsOut, bestParamTypes, exprContext);
        return bestConstructor;
    }

    public static Method getElementMethod(Class classObj, String name) throws NoSuchMethodException, SecurityException, TransformerException {
        Method bestMethod = null;
        Method[] methods = classObj.getMethods();
        int nMethods = methods.length;
        int bestScore = Integer.MAX_VALUE;
        int bestScoreCount = 0;
        int i2 = 0;
        while (i2 < nMethods) {
            Class<?>[] paramTypes;
            Method method = methods[i2];
            if (method.getName().equals(name) && (paramTypes = method.getParameterTypes()).length == 2 && paramTypes[1].isAssignableFrom(class$org$apache$xalan$templates$ElemExtensionCall != null ? class$org$apache$xalan$templates$ElemExtensionCall : MethodResolver.class$("org.apache.xalan.templates.ElemExtensionCall"))) {
                int score = -1;
                if (paramTypes[0].isAssignableFrom(class$org$apache$xalan$extensions$XSLProcessorContext != null ? class$org$apache$xalan$extensions$XSLProcessorContext : MethodResolver.class$("org.apache.xalan.extensions.XSLProcessorContext"))) {
                    score = 10;
                    if (score < bestScore) {
                        bestMethod = method;
                        bestScore = score;
                        bestScoreCount = 1;
                    } else if (score == bestScore) {
                        ++bestScoreCount;
                    }
                }
            }
            ++i2;
        }
        if (bestMethod == null) {
            throw new NoSuchMethodException(MethodResolver.errString("element", "method", classObj, name, 0, null));
        }
        if (bestScoreCount > 1) {
            throw new TransformerException("More than one best match for element method " + name);
        }
        return bestMethod;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Method getMethod(Class classObj, String name, Object[] argsIn, Object[][] argsOut, ExpressionContext exprContext, int searchMethod) throws NoSuchMethodException, SecurityException, TransformerException {
        Method bestMethod = null;
        Class[] bestParamTypes = null;
        Method[] methods = classObj.getMethods();
        int nMethods = methods.length;
        int bestScore = Integer.MAX_VALUE;
        int bestScoreCount = 0;
        int i2 = 0;
        while (i2 < nMethods) {
            block11: {
                int score;
                int scoreStart;
                int argsLen;
                int numberMethodParams;
                Class[] paramTypes;
                int javaParamStart;
                int xsltParamStart;
                Method method;
                block13: {
                    block12: {
                        Class<?> javaClass;
                        method = methods[i2];
                        xsltParamStart = 0;
                        if (!method.getName().equals(name)) break block11;
                        boolean isStatic = Modifier.isStatic(method.getModifiers());
                        switch (searchMethod) {
                            case 1: {
                                if (isStatic) break;
                                break block11;
                            }
                            case 2: {
                                if (!isStatic) break;
                                break block11;
                            }
                            case 4: {
                                if (isStatic) break;
                                xsltParamStart = 1;
                            }
                        }
                        javaParamStart = 0;
                        paramTypes = method.getParameterTypes();
                        numberMethodParams = paramTypes.length;
                        boolean isFirstExpressionContext = false;
                        int n2 = argsLen = argsIn != null ? argsIn.length : 0;
                        if (numberMethodParams != argsLen - xsltParamStart + 1) break block12;
                        if (!(class$org$apache$xalan$extensions$ExpressionContext != null ? class$org$apache$xalan$extensions$ExpressionContext : MethodResolver.class$("org.apache.xalan.extensions.ExpressionContext")).isAssignableFrom(javaClass = paramTypes[0])) break block11;
                        isFirstExpressionContext = true;
                        scoreStart = 0;
                        ++javaParamStart;
                        break block13;
                    }
                    scoreStart = 1000;
                }
                if (argsLen - xsltParamStart == numberMethodParams - javaParamStart && (score = MethodResolver.scoreMatch(paramTypes, javaParamStart, argsIn, scoreStart)) != -1) {
                    if (score < bestScore) {
                        bestMethod = method;
                        bestParamTypes = paramTypes;
                        bestScore = score;
                        bestScoreCount = 1;
                    } else if (score == bestScore) {
                        ++bestScoreCount;
                    }
                }
            }
            ++i2;
        }
        if (bestMethod == null) {
            throw new NoSuchMethodException(MethodResolver.errString("function", "method", classObj, name, searchMethod, argsIn));
        }
        MethodResolver.convertParams(argsIn, argsOut, bestParamTypes, exprContext);
        return bestMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int scoreMatch(Class[] javaParamTypes, int javaParamsStart, Object[] xsltArgs, int score) {
        if (xsltArgs == null || javaParamTypes == null) {
            return score;
        }
        int nParams = xsltArgs.length;
        int i2 = nParams - javaParamTypes.length + javaParamsStart;
        int javaParamTypesIndex = javaParamsStart;
        while (i2 < nParams) {
            Object xsltObj = xsltArgs[i2];
            int xsltClassType = xsltObj instanceof XObject ? ((XObject)xsltObj).getType() : 0;
            Class javaClass = javaParamTypes[javaParamTypesIndex];
            if (xsltClassType == -1) {
                if (javaClass.isPrimitive()) return -1;
                score += 10;
            } else {
                ConversionInfo[] convInfo = m_conversions[xsltClassType];
                int nConversions = convInfo.length;
                int k2 = 0;
                while (k2 < nConversions) {
                    ConversionInfo cinfo = convInfo[k2];
                    if (javaClass.isAssignableFrom(cinfo.m_class)) {
                        score += cinfo.m_score;
                        break;
                    }
                    ++k2;
                }
                if (k2 == nConversions) {
                    Class<?> realClass;
                    if (xsltClassType != 0) return -1;
                    Class<?> clazz = realClass = xsltObj instanceof XObject ? ((XObject)xsltObj).object().getClass() : xsltObj.getClass();
                    if (!javaClass.isAssignableFrom(realClass)) return -1;
                    score += 0;
                }
            }
            ++i2;
            ++javaParamTypesIndex;
        }
        return score;
    }

    static class ConversionInfo {
        Class m_class;
        int m_score;

        ConversionInfo(Class cl2, int score) {
            this.m_class = cl2;
            this.m_score = score;
        }
    }
}

