/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.parser.ParserUtils;
import org.apache.jasper.parser.TreeNode;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TAGLIB_TLD = "META-INF/taglib.tld";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    Hashtable jarEntries;
    JspCompilationContext ctxt;
    protected TagLibraryValidator tagLibraryValidator;

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn) throws JasperException {
        this(ctxt, prefix, uriIn, null);
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn, String[] location) throws JasperException {
        block17: {
            super(prefix, uriIn);
            this.ctxt = ctxt;
            InputStream in = null;
            URL url = null;
            boolean relativeURL = false;
            if (location == null) {
                int uriType = TldLocationsCache.uriType(this.uri);
                if (uriType == 0) {
                    throw new JasperException(Constants.getString("jsp.error.taglibDirective.absUriCannotBeResolved", new Object[]{this.uri}));
                }
                if (uriType == 2) {
                    this.uri = ctxt.resolveRelativeUri(this.uri);
                }
                location = new String[2];
                location[0] = this.uri;
                if (this.uri.endsWith("jar")) {
                    location[1] = TAGLIB_TLD;
                }
            }
            if (!location[0].endsWith("jar")) {
                try {
                    in = this.getResourceAsStream(location[0]);
                    if (in == null) {
                        throw new FileNotFoundException(location[0]);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JasperException(Constants.getString("jsp.error.file.not.found", new Object[]{location[0]}));
                }
                this.parseTLD(ctxt, location[0], in);
            } else {
                ZipFile jarFile = null;
                ZipEntry jarEntry = null;
                InputStream stream = null;
                try {
                    url = ctxt.getResource(location[0]);
                    if (url == null) {
                        return;
                    }
                    url = new URL("jar:" + url.toString() + "!/");
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    conn.connect();
                    jarFile = conn.getJarFile();
                    jarEntry = ((JarFile)jarFile).getEntry(location[1]);
                    stream = ((JarFile)jarFile).getInputStream(jarEntry);
                    this.parseTLD(ctxt, location[0], stream);
                }
                catch (Exception ex2) {
                    Constants.message("jsp.error.taglib.jarFileException", new Object[]{url.toString(), ex2.getMessage()}, 1);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (jarFile == null) break block17;
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, nRead);
        }
    }

    TagAttributeInfo createAttribute(TreeNode elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            String s2;
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("required".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                required = JspUtil.booleanValue(s2);
                continue;
            }
            if ("rtexprvalue".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                rtexprvalue = JspUtil.booleanValue(s2);
                continue;
            }
            if ("type".equals(tname)) {
                type = element.getBody();
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.attribute", new Object[]{tname}, 2);
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    String[] createInitParam(TreeNode elem) {
        String[] initParam = new String[2];
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("param-name".equals(tname)) {
                initParam[0] = element.getBody();
                continue;
            }
            if ("param-value".equals(tname)) {
                initParam[1] = element.getBody();
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.initParam", new Object[]{tname}, 2);
        }
        return initParam;
    }

    private TagInfo createTagInfo(TreeNode elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        Vector<TagVariableInfo> variableVector = new Vector<TagVariableInfo>();
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("tagclass".equals(tname) || "tag-class".equals(tname)) {
                tagclass = element.getBody();
                continue;
            }
            if ("teiclass".equals(tname) || "tei-class".equals(tname)) {
                teiclass = element.getBody();
                continue;
            }
            if ("bodycontent".equals(tname) || "body-content".equals(tname)) {
                bodycontent = element.getBody();
                continue;
            }
            if ("display-name".equals(tname)) {
                displayName = element.getBody();
                continue;
            }
            if ("small-icon".equals(tname)) {
                smallIcon = element.getBody();
                continue;
            }
            if ("large-icon".equals(tname)) {
                largeIcon = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                info = element.getBody();
                continue;
            }
            if ("variable".equals(tname)) {
                if (teiclass != null) {
                    throw new JasperException(Constants.getString("tld.error.variableNotAllowed"));
                }
                variableVector.addElement(this.createVariable(element));
                continue;
            }
            if ("attribute".equals(tname)) {
                attributeVector.addElement(this.createAttribute(element));
                continue;
            }
            if ("example".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.tag", new Object[]{tname}, 2);
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        Object[] tagVariableInfos = new TagVariableInfo[variableVector.size()];
        variableVector.copyInto(tagVariableInfos);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, cex.getMessage()}, 2);
            }
            catch (IllegalAccessException iae) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, iae.getMessage()}, 2);
            }
            catch (InstantiationException ie) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, ie.getMessage()}, 2);
            }
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, this, tei, (TagAttributeInfo[])tagAttributeInfo, displayName, smallIcon, largeIcon, (TagVariableInfo[])tagVariableInfos);
        return taginfo;
    }

    private TagLibraryValidator createValidator(TreeNode elem) {
        String validatorClass = null;
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("validator-class".equals(tname)) {
                validatorClass = element.getBody();
                continue;
            }
            if ("init-param".equals(tname)) {
                String[] initParam = this.createInitParam(element);
                initParams.put(initParam[0], initParam[1]);
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.validator", new Object[]{tname}, 2);
        }
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception ex2) {
                Constants.message("jsp.warning.tlvclass.is.null", new Object[]{validatorClass, "EXCEPTION: " + ex2.getMessage()}, 1);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    TagVariableInfo createVariable(TreeNode elem) {
        String nameGiven = null;
        String nameFromAttribute = null;
        String className = null;
        boolean declare = true;
        int scope = 0;
        Iterator list = elem.findChildren();
        while (list.hasNext()) {
            String s2;
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("name-given".equals(tname)) {
                nameGiven = element.getBody();
                continue;
            }
            if ("name-from-attribute".equals(tname)) {
                nameFromAttribute = element.getBody();
                continue;
            }
            if ("variable-class".equals(tname)) {
                className = element.getBody();
                continue;
            }
            if ("declare".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                declare = JspUtil.booleanValue(s2);
                continue;
            }
            if ("scope".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                if ("NESTED".equals(s2)) {
                    scope = 0;
                    continue;
                }
                if ("AT_BEGIN".equals(s2)) {
                    scope = 1;
                    continue;
                }
                if (!"AT_END".equals(s2)) continue;
                scope = 2;
                continue;
            }
            if ("description".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.variable", new Object[]{tname}, 2);
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope);
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        try {
            String real = this.ctxt.getRealPath(uri);
            if (real == null) {
                return this.ctxt.getResourceAsStream(uri);
            }
            return new FileInputStream(real);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.ctxt.getResourceAsStream(uri);
        }
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    private boolean isRelativeURI(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void p(String s2) {
        System.out.println("[TagLibraryInfoImpl] " + s2);
    }

    private void parseTLD(JspCompilationContext ctxt, String uri, InputStream in) throws JasperException {
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        ClassLoader cl2 = ctxt.getClassLoader();
        ParserUtils pu = ParserUtils.createParserUtils(cl2);
        TreeNode tld = pu.parseXMLDocument(uri, in);
        Iterator list = tld.findChildren();
        while (list.hasNext()) {
            TreeNode element = (TreeNode)list.next();
            String tname = element.getName();
            if ("tlibversion".equals(tname) || "tlib-version".equals(tname)) {
                this.tlibversion = element.getBody();
                continue;
            }
            if ("jspversion".equals(tname) || "jsp-version".equals(tname)) {
                this.jspversion = element.getBody();
                continue;
            }
            if ("shortname".equals(tname) || "short-name".equals(tname)) {
                this.shortname = element.getBody();
                continue;
            }
            if ("uri".equals(tname)) {
                this.urn = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                this.info = element.getBody();
                continue;
            }
            if ("validator".equals(tname)) {
                this.tagLibraryValidator = this.createValidator(element);
                continue;
            }
            if ("tag".equals(tname)) {
                tagVector.addElement(this.createTagInfo(element));
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "listener".equals(tname)) continue;
            Constants.message("jsp.warning.unknown.element.in.TLD", new Object[]{tname}, 2);
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private final void print(String name, String value, PrintWriter w2) {
        if (value != null) {
            w2.print(String.valueOf(name) + " = {\n\t");
            w2.print(value);
            w2.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", this.tagLibraryValidator.toString(), out);
        int i2 = 0;
        while (i2 < this.tags.length) {
            out.println(this.tags[i2].toString());
            ++i2;
        }
        return sw.toString();
    }

    public String validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        return tlv.validate(this.getPrefixString(), this.getURI(), thePage);
    }
}

