/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.util.Enumeration;

final class SimpleHashtable
implements Enumeration {
    private Entry[] table;
    private Entry current = null;
    private int currentBucket = 0;
    private int count;
    private int threshold;
    private static final float loadFactor = 0.75f;

    public SimpleHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public SimpleHashtable() {
        this(11);
    }

    public void clear() {
        this.count = 0;
        this.currentBucket = 0;
        this.current = null;
        int i2 = 0;
        while (i2 < this.table.length) {
            this.table[i2] = null;
            ++i2;
        }
    }

    public int size() {
        return this.count;
    }

    public Enumeration keys() {
        this.currentBucket = 0;
        this.current = null;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasMoreElements() {
        if (this.current == null) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            this.current = this.table[this.currentBucket++];
            if (this.current == null) continue;
            return true;
lbl6:
            // 2 sources

            ** while (this.currentBucket < this.table.length)
        }
lbl7:
        // 1 sources

        return false;
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Object retval = this.current.key;
        this.current = this.current.next;
        return retval;
    }

    public Object get(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e10 = tab[index];
        while (e10 != null) {
            if (e10.hash == hash && e10.key == key) {
                return e10.value;
            }
            e10 = e10.next;
        }
        return null;
    }

    public Object getNonInterned(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e10 = tab[index];
        while (e10 != null) {
            if (e10.hash == hash && e10.key.equals(key)) {
                return e10.value;
            }
            e10 = e10.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e10 = old;
                old = old.next;
                int index = (e10.hash & Integer.MAX_VALUE) % newCapacity;
                e10.next = newMap[index];
                newMap[index] = e10;
            }
        }
    }

    public Object put(Object key, Object value) {
        Entry e10;
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e11 = tab[index];
        while (e11 != null) {
            if (e11.hash == hash && e11.key == key) {
                Object old = e11.value;
                e11.value = value;
                return old;
            }
            e11 = e11.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e10 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

