/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;

public final class InstanceSupport {
    private InstanceListener[] listeners = new InstanceListener[0];
    private Wrapper wrapper = null;

    public InstanceSupport(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void addInstanceListener(InstanceListener listener) {
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            InstanceListener[] results = new InstanceListener[this.listeners.length + 1];
            int i2 = 0;
            while (i2 < this.listeners.length) {
                results[i2] = this.listeners[i2];
                ++i2;
            }
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void fireInstanceEvent(String type, Filter filter) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i2 = 0;
        while (i2 < interested.length) {
            interested[i2].instanceEvent(event);
            ++i2;
        }
    }

    public void fireInstanceEvent(String type, Servlet servlet) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type);
        InstanceListener[] interested = null;
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            interested = (InstanceListener[])this.listeners.clone();
        }
        int i2 = 0;
        while (i2 < interested.length) {
            interested[i2].instanceEvent(event);
            ++i2;
        }
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void removeInstanceListener(InstanceListener listener) {
        InstanceListener[] instanceListenerArray = this.listeners;
        synchronized (instanceListenerArray) {
            int n2 = -1;
            int i2 = 0;
            while (i2 < this.listeners.length) {
                if (this.listeners[i2] == listener) {
                    n2 = i2;
                    break;
                }
                ++i2;
            }
            if (n2 < 0) {
                Object var3_5 = null;
                return;
            }
            InstanceListener[] results = new InstanceListener[this.listeners.length - 1];
            int j2 = 0;
            int i3 = 0;
            while (i3 < this.listeners.length) {
                if (i3 != n2) {
                    results[j2++] = this.listeners[i3];
                }
                ++i3;
            }
            this.listeners = results;
        }
    }
}

