/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FastDateFormat
extends DateFormat {
    DateFormat df;
    long lastSec = -1L;
    StringBuffer sb = new StringBuffer();
    FieldPosition fp = new FieldPosition(8);

    public FastDateFormat(DateFormat df2) {
        this.df = df2;
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long dt2 = date.getTime();
        long ds2 = dt2 / 1000L;
        if (ds2 != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = ds2;
        } else {
            int ms = (int)(dt2 % 1000L);
            int pos = this.fp.getEndIndex();
            int begin = this.fp.getBeginIndex();
            if (pos > 0) {
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
            }
        }
        toAppendTo.append(this.sb.toString());
        return toAppendTo;
    }

    public static void main(String[] args) {
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        if (args.length > 0) {
            format = args[0];
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        FastDateFormat fdf = new FastDateFormat(sdf);
        Date d10 = new Date();
        d10.setTime(1L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(20L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(500L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(543L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(999L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(1050L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(2543L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(12345L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        d10.setTime(12340L);
        System.out.println(String.valueOf(fdf.format(d10)) + "\t" + sdf.format(d10));
        int reps = 100000;
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100000) {
            d10.setTime(System.currentTimeMillis());
            fdf.format(d10);
            ++i2;
        }
        long elap = System.currentTimeMillis() - start;
        System.out.println("fast: " + elap + " elapsed");
        System.out.println(fdf.format(d10));
        long start2 = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < 100000) {
            d10.setTime(System.currentTimeMillis());
            sdf.format(d10);
            ++i3;
        }
        long elap2 = System.currentTimeMillis() - start2;
        System.out.println("slow: " + elap2 + " elapsed");
        System.out.println(sdf.format(d10));
    }

    public Date parse(String text, ParsePosition pos) {
        return this.df.parse(text, pos);
    }
}

