/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.SetAuthConstraint;
import org.apache.catalina.startup.SetDistributableAction;
import org.apache.catalina.startup.SetPublicIdAction;
import org.apache.catalina.startup.WrapperCreate;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.xml.XmlMapper;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.xml.sax.SAXParseException;

public final class ContextConfig
implements LifecycleListener {
    private static ResourceBundle authenticators = null;
    private Context context = null;
    private int debug = 0;
    private boolean ok = false;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    private void applicationConfig(XmlMapper mapper) {
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            this.log(sm.getString("contextConfig.applicationMissing"));
            return;
        }
        try {
            try {
                mapper.readXml(stream, (Object)this.context);
            }
            catch (InvocationTargetException e10) {
                this.log(sm.getString("contextConfig.applicationConfig"), e10.getTargetException());
                this.ok = false;
            }
            catch (SAXParseException e11) {
                this.log(sm.getString("contextConfig.applicationParse"), e11);
                this.log(sm.getString("contextConfig.applicationPosition", String.valueOf(e11.getLineNumber()), String.valueOf(e11.getColumnNumber())));
                this.ok = false;
            }
            catch (Exception e12) {
                this.log(sm.getString("contextConfig.applicationParse"), e12);
                this.ok = false;
            }
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            try {
                stream.close();
            }
            catch (IOException e13) {
                this.log(sm.getString("contextConfig.applicationClose"), e13);
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException e13) {
            this.log(sm.getString("contextConfig.applicationClose"), e13);
        }
    }

    private synchronized void authenticatorConfig() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline != null) {
                Valve basic = pipeline.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline.getValves();
                int i2 = 0;
                while (i2 < valves.length) {
                    if (valves[i2] instanceof Authenticator) {
                        return;
                    }
                    ++i2;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            this.log(sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        if (authenticators == null) {
            try {
                authenticators = ResourceBundle.getBundle("org.apache.catalina.startup.Authenticators");
            }
            catch (MissingResourceException e10) {
                this.log(sm.getString("contextConfig.authenticatorResources"), e10);
                this.ok = false;
                return;
            }
        }
        String authenticatorName = null;
        try {
            authenticatorName = authenticators.getString(loginConfig.getAuthMethod());
        }
        catch (MissingResourceException missingResourceException) {
            authenticatorName = null;
        }
        if (authenticatorName == null) {
            this.log(sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        try {
            Pipeline pipeline;
            Class<?> authenticatorClass = Class.forName(authenticatorName);
            authenticator = (Valve)authenticatorClass.newInstance();
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                pipeline.addValve(authenticator);
                this.log(sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
        catch (Throwable t2) {
            this.log(sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t2);
            this.ok = false;
        }
    }

    private void certificatesConfig() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("javax.net.ssl.SSLSocket");
            if (clazz == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
        Valve certificates = null;
        try {
            Class<?> clazz = Class.forName("org.apache.catalina.valves.CertificatesValve");
            certificates = (Valve)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return;
        }
        try {
            Pipeline pipeline;
            if (this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
                pipeline.addValve(certificates);
                this.log(sm.getString("contextConfig.certificatesConfig.added"));
            }
        }
        catch (Throwable t2) {
            this.log(sm.getString("contextConfig.certificatesConfig.error"), t2);
            this.ok = false;
        }
    }

    private XmlMapper createTldMapper() {
        XmlMapper mapper = new XmlMapper();
        if (this.debug > 0) {
            mapper.setDebug(3);
        }
        mapper.setValidating(true);
        File resourceFile = new File(System.getProperty("catalina.home"), "conf/tld_11.dtd");
        mapper.registerDTDFile("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", resourceFile.toString());
        resourceFile = new File(System.getProperty("catalina.home"), "conf/tld_12.dtd");
        mapper.registerDTDFile("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", resourceFile.toString());
        mapper.addRule("taglib/listener/listener-class", mapper.methodSetter("addApplicationListener", 0));
        return mapper;
    }

    private XmlMapper createWebMapper() {
        XmlMapper mapper = new XmlMapper();
        if (this.debug > 0) {
            mapper.setDebug(3);
        }
        mapper.setValidating(true);
        File resourceFile = new File(System.getProperty("catalina.home"), "conf/web_22.dtd");
        mapper.registerDTDFile("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", resourceFile.toString());
        resourceFile = new File(System.getProperty("catalina.home"), "conf/web_23.dtd");
        mapper.registerDTDFile("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", resourceFile.toString());
        mapper.addRule("web-app", new SetPublicIdAction("setPublicId"));
        mapper.addRule("web-app/context-param", mapper.methodSetter("addParameter", 2));
        mapper.addRule("web-app/context-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/context-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/distributable", new SetDistributableAction());
        mapper.addRule("web-app/ejb-local-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextLocalEjb"));
        mapper.addRule("web-app/ejb-local-ref", mapper.addChild("addLocalEjb", "org.apache.catalina.deploy.ContextLocalEjb"));
        mapper.addRule("web-app/ejb-local-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-ref-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/ejb-local-ref/local-home", mapper.methodSetter("setHome", 0));
        mapper.addRule("web-app/ejb-local-ref/local", mapper.methodSetter("setLocal", 0));
        mapper.addRule("web-app/ejb-local-ref/ejb-link", mapper.methodSetter("setLink", 0));
        mapper.addRule("web-app/ejb-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule("web-app/ejb-ref", mapper.addChild("addEjb", "org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule("web-app/ejb-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/ejb-ref/ejb-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/ejb-ref/ejb-ref-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/ejb-ref/home", mapper.methodSetter("setHome", 0));
        mapper.addRule("web-app/ejb-ref/remote", mapper.methodSetter("setRemote", 0));
        mapper.addRule("web-app/ejb-ref/ejb-link", mapper.methodSetter("setLink", 0));
        mapper.addRule("web-app/env-entry", mapper.objectCreate("org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule("web-app/env-entry", mapper.addChild("addEnvironment", "org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule("web-app/env-entry/env-entry-description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/env-entry/env-entry-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/env-entry/env-entry-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/env-entry/env-entry-value", mapper.methodSetter("setValue", 0));
        mapper.addRule("web-app/error-page", mapper.objectCreate("org.apache.catalina.deploy.ErrorPage"));
        mapper.addRule("web-app/error-page", mapper.addChild("addErrorPage", "org.apache.catalina.deploy.ErrorPage"));
        mapper.addRule("web-app/error-page/error-code", mapper.methodSetter("setErrorCode", 0));
        mapper.addRule("web-app/error-page/exception-type", mapper.methodSetter("setExceptionType", 0));
        mapper.addRule("web-app/error-page/location", mapper.methodSetter("setLocation", 0));
        mapper.addRule("web-app/filter", mapper.objectCreate("org.apache.catalina.deploy.FilterDef"));
        mapper.addRule("web-app/filter", mapper.addChild("addFilterDef", "org.apache.catalina.deploy.FilterDef"));
        mapper.addRule("web-app/filter/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/filter/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/filter/filter-class", mapper.methodSetter("setFilterClass", 0));
        mapper.addRule("web-app/filter/filter-name", mapper.methodSetter("setFilterName", 0));
        mapper.addRule("web-app/filter/icon/large-icon", mapper.methodSetter("setLargeIcon", 0));
        mapper.addRule("web-app/filter/icon/small-icon", mapper.methodSetter("setSmallIcon", 0));
        mapper.addRule("web-app/filter/init-param", mapper.methodSetter("addInitParameter", 2));
        mapper.addRule("web-app/filter/init-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/filter/init-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/filter-mapping", mapper.objectCreate("org.apache.catalina.deploy.FilterMap"));
        mapper.addRule("web-app/filter-mapping", mapper.addChild("addFilterMap", "org.apache.catalina.deploy.FilterMap"));
        mapper.addRule("web-app/filter-mapping/filter-name", mapper.methodSetter("setFilterName", 0));
        mapper.addRule("web-app/filter-mapping/servlet-name", mapper.methodSetter("setServletName", 0));
        mapper.addRule("web-app/filter-mapping/url-pattern", mapper.methodSetter("setURLPattern", 0));
        mapper.addRule("web-app/listener/listener-class", mapper.methodSetter("addApplicationListener", 0));
        mapper.addRule("web-app/login-config", mapper.objectCreate("org.apache.catalina.deploy.LoginConfig"));
        mapper.addRule("web-app/login-config", mapper.addChild("setLoginConfig", "org.apache.catalina.deploy.LoginConfig"));
        mapper.addRule("web-app/login-config/auth-method", mapper.methodSetter("setAuthMethod", 0));
        mapper.addRule("web-app/login-config/realm-name", mapper.methodSetter("setRealmName", 0));
        mapper.addRule("web-app/login-config/form-login-config/form-login-page", mapper.methodSetter("setLoginPage", 0));
        mapper.addRule("web-app/login-config/form-login-config/form-error-page", mapper.methodSetter("setErrorPage", 0));
        mapper.addRule("web-app/mime-mapping", mapper.methodSetter("addMimeMapping", 2));
        mapper.addRule("web-app/mime-mapping/extension", mapper.methodParam(0));
        mapper.addRule("web-app/mime-mapping/mime-type", mapper.methodParam(1));
        mapper.addRule("web-app/resource-env-ref", mapper.methodSetter("addResourceEnvRef", 2));
        mapper.addRule("web-app/resource-env-ref/resource-env-ref-name", mapper.methodParam(0));
        mapper.addRule("web-app/resource-env-ref/resource-env-ref-type", mapper.methodParam(1));
        mapper.addRule("web-app/resource-ref", mapper.objectCreate("org.apache.catalina.deploy.ContextResource"));
        mapper.addRule("web-app/resource-ref", mapper.addChild("addResource", "org.apache.catalina.deploy.ContextResource"));
        mapper.addRule("web-app/resource-ref/description", mapper.methodSetter("setDescription", 0));
        mapper.addRule("web-app/resource-ref/res-auth", mapper.methodSetter("setAuth", 0));
        mapper.addRule("web-app/resource-ref/res-ref-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/resource-ref/res-sharing-scope", mapper.methodSetter("setScope", 0));
        mapper.addRule("web-app/resource-ref/res-type", mapper.methodSetter("setType", 0));
        mapper.addRule("web-app/security-constraint", mapper.objectCreate("org.apache.catalina.deploy.SecurityConstraint"));
        mapper.addRule("web-app/security-constraint", mapper.addChild("addConstraint", "org.apache.catalina.deploy.SecurityConstraint"));
        mapper.addRule("web-app/security-constraint/auth-constraint", new SetAuthConstraint());
        mapper.addRule("web-app/security-constraint/auth-constraint/role-name", mapper.methodSetter("addAuthRole", 0));
        mapper.addRule("web-app/security-constraint/display-name", mapper.methodSetter("setDisplayName", 0));
        mapper.addRule("web-app/security-constraint/user-data-constraint/transport-guarantee", mapper.methodSetter("setUserConstraint", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection", mapper.objectCreate("org.apache.catalina.deploy.SecurityCollection"));
        mapper.addRule("web-app/security-constraint/web-resource-collection", mapper.addChild("addCollection", "org.apache.catalina.deploy.SecurityCollection"));
        mapper.addRule("web-app/security-constraint/web-resource-collection/http-method", mapper.methodSetter("addMethod", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection/url-pattern", mapper.methodSetter("addPattern", 0));
        mapper.addRule("web-app/security-constraint/web-resource-collection/web-resource-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/security-role", mapper.methodSetter("addSecurityRole", 1));
        mapper.addRule("web-app/security-role/role-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet", new WrapperCreate(this.context));
        mapper.addRule("web-app/servlet", mapper.addChild("addChild", "org.apache.catalina.Container"));
        mapper.addRule("web-app/servlet/init-param", mapper.methodSetter("addInitParameter", 2));
        mapper.addRule("web-app/servlet/init-param/param-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet/init-param/param-value", mapper.methodParam(1));
        mapper.addRule("web-app/servlet/jsp-file", mapper.methodSetter("setJspFile", 0));
        mapper.addRule("web-app/servlet/load-on-startup", mapper.methodSetter("setLoadOnStartupString", 0));
        mapper.addRule("web-app/servlet/run-as/role-name", mapper.methodSetter("setRunAs", 0));
        mapper.addRule("web-app/servlet/security-role-ref", mapper.methodSetter("addSecurityReference", 2));
        mapper.addRule("web-app/servlet/security-role-ref/role-link", mapper.methodParam(1));
        mapper.addRule("web-app/servlet/security-role-ref/role-name", mapper.methodParam(0));
        mapper.addRule("web-app/servlet/servlet-class", mapper.methodSetter("setServletClass", 0));
        mapper.addRule("web-app/servlet/servlet-name", mapper.methodSetter("setName", 0));
        mapper.addRule("web-app/servlet-mapping", mapper.methodSetter("addServletMapping", 2));
        mapper.addRule("web-app/servlet-mapping/servlet-name", mapper.methodParam(1));
        mapper.addRule("web-app/servlet-mapping/url-pattern", mapper.methodParam(0));
        mapper.addRule("web-app/session-config", mapper.methodSetter("setSessionTimeout", 1, new String[]{"int"}));
        mapper.addRule("web-app/session-config/session-timeout", mapper.methodParam(0));
        mapper.addRule("web-app/taglib", mapper.methodSetter("addTaglib", 2));
        mapper.addRule("web-app/taglib/taglib-location", mapper.methodParam(1));
        mapper.addRule("web-app/taglib/taglib-uri", mapper.methodParam(0));
        mapper.addRule("web-app/welcome-file-list/welcome-file", mapper.methodSetter("addWelcomeFile", 0));
        return mapper;
    }

    private void defaultConfig(XmlMapper mapper) {
        File file = new File("conf/web.xml");
        if (!file.isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("catalina.home")) + File.separator + "conf/web.xml");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file.getCanonicalPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log(sm.getString("contextConfig.defaultMissing"));
            return;
        }
        catch (IOException e10) {
            this.log(sm.getString("contextConfig.defaultMissing"), e10);
            return;
        }
        try {
            try {
                mapper.readXml(stream, (Object)this.context);
            }
            catch (InvocationTargetException e11) {
                this.log(sm.getString("contextConfig.defaultConfig"), e11.getTargetException());
                this.ok = false;
            }
            catch (SAXParseException e12) {
                this.log(sm.getString("contextConfig.defaultParse"), e12);
                this.log(sm.getString("contextConfig.defaultPosition", String.valueOf(e12.getLineNumber()), String.valueOf(e12.getColumnNumber())));
                this.ok = false;
            }
            catch (Exception e13) {
                this.log(sm.getString("contextConfig.defaultParse"), e13);
                this.ok = false;
            }
            Object var5_11 = null;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            try {
                stream.close();
            }
            catch (IOException e14) {
                this.log(sm.getString("contextConfig.defaultClose"), e14);
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException e14) {
            this.log(sm.getString("contextConfig.defaultClose"), e14);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int contextDebug;
            this.context = (Context)((Object)event.getLifecycle());
            if (this.context instanceof StandardContext && (contextDebug = ((StandardContext)this.context).getDebug()) > this.debug) {
                this.debug = contextDebug;
            }
        }
        catch (ClassCastException e10) {
            this.log(sm.getString("contextConfig.cce", event.getLifecycle()), e10);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "]: " + message);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.context != null) {
            logger = this.context.getLogger();
        }
        if (logger != null) {
            logger.log("ContextConfig[" + this.context.getName() + "] " + message, throwable);
        } else {
            System.out.println("ContextConfig[" + this.context.getName() + "]: " + message);
            System.out.println(String.valueOf(String.valueOf(throwable)));
            throwable.printStackTrace(System.out);
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    private synchronized void start() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.start"));
        }
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride()) {
            if (container instanceof Host) {
                ((Host)container).importDefaultContext(this.context);
                container = container.getParent();
            }
            if (container instanceof Engine) {
                ((Engine)container).importDefaultContext(this.context);
            }
        }
        XmlMapper mapper = this.createWebMapper();
        this.defaultConfig(mapper);
        this.applicationConfig(mapper);
        if (this.ok) {
            this.tldConfig();
        }
        if (this.ok) {
            this.certificatesConfig();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.debug >= 1 && this.context instanceof ContainerBase) {
            this.log("Pipline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                int i2 = 0;
                while (i2 < valves.length) {
                    this.log("  " + valves[i2].getInfo());
                    ++i2;
                }
            }
            this.log("======================");
        }
        if (this.ok) {
            this.context.setAvailable(true);
        } else {
            this.log(sm.getString("contextConfig.unavailable"));
            this.context.setAvailable(false);
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("contextConfig.stop"));
        }
        this.ok = true;
    }

    private void tldConfig() {
        XmlMapper mapper = this.createTldMapper();
        if (this.debug >= 1) {
            this.log("Scanning web.xml tag libraries");
        }
        ArrayList<String> resourcePaths = new ArrayList<String>();
        String[] taglibs = this.context.findTaglibs();
        int i2 = 0;
        while (i2 < taglibs.length) {
            String resourcePath = this.context.findTaglib(taglibs[i2]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/WEB-INF/web.xml/../" + resourcePath;
            }
            if (this.debug >= 2) {
                this.log("  URI='" + taglibs[i2] + "', ResourcePath='" + resourcePath + "'");
            }
            if (resourcePaths.contains(resourcePath)) {
                if (this.debug >= 2) {
                    this.log("    Already processed");
                }
            } else {
                resourcePaths.add(resourcePath);
                if (!this.tldConfigJar(resourcePath, mapper)) {
                    this.tldConfigTld(resourcePath, mapper);
                }
            }
            ++i2;
        }
        if (this.debug >= 1) {
            this.log("Scanning library JAR files");
        }
        DirContext resources = this.context.getResources();
        String libName = "/WEB-INF/lib";
        Object libDir = null;
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = resources.list(libName);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String filename = String.valueOf(libName) + "/" + ncPair.getName();
                if (!filename.endsWith(".jar")) continue;
                this.tldConfigJar(filename, mapper);
            }
        }
        catch (NamingException namingException) {}
    }

    private boolean tldConfigJar(String resourcePath, XmlMapper mapper) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            URL url = this.context.getServletContext().getResource(resourcePath);
            if (url == null) {
                return false;
            }
            DirContextURLStreamHandler.bind(this.context.getResources());
            url = new URL("jar:" + url.toString() + "!/");
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            jarFile = conn.getJarFile();
            DirContextURLStreamHandler.unbind();
            boolean found = false;
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                if (this.debug >= 2) {
                    this.log("    tldConfigJar(" + resourcePath + "): Processing entry '" + name + "'");
                }
                stream = ((JarFile)jarFile).getInputStream(entry);
                mapper.readXml(stream, (Object)this.context);
                stream.close();
                found = true;
            }
            return found;
        }
        catch (Exception e10) {
            block11: {
                if (this.debug >= 2) {
                    this.log("    tldConfigJar(" + resourcePath + "): " + e10);
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (jarFile == null) break block11;
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
            }
            return false;
        }
    }

    private boolean tldConfigTld(String resourcePath, XmlMapper mapper) {
        InputStream stream = null;
        try {
            stream = this.context.getServletContext().getResourceAsStream(resourcePath);
            if (stream == null) {
                return false;
            }
            mapper.readXml(stream, (Object)this.context);
            stream.close();
            return true;
        }
        catch (Exception e10) {
            block6: {
                if (this.debug >= 2) {
                    this.log("    tldConfigTld(" + resourcePath + "): " + e10);
                }
                if (stream == null) break block6;
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
            return false;
        }
    }
}

