/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.deploy.SecurityCollection;

public final class SecurityConstraint {
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public void addAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        if ("*".equals(authRole)) {
            this.allRoles = true;
            return;
        }
        String[] results = new String[this.authRoles.length + 1];
        int i2 = 0;
        while (i2 < this.authRoles.length) {
            results[i2] = this.authRoles[i2];
            ++i2;
        }
        results[this.authRoles.length] = authRole;
        this.authRoles = results;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        SecurityCollection[] results = new SecurityCollection[this.collections.length + 1];
        int i2 = 0;
        while (i2 < this.collections.length) {
            results[i2] = this.collections[i2];
            ++i2;
        }
        results[this.collections.length] = collection;
        this.collections = results;
    }

    public boolean findAuthRole(String role) {
        if (role == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.authRoles.length) {
            if (role.equals(this.authRoles[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String name) {
        if (name == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.collections.length) {
            if (name.equals(this.collections[i2].getName())) {
                return this.collections[i2];
            }
            ++i2;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public boolean included(String uri, String method) {
        if (method == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.collections.length) {
            if (this.collections[i2].findMethod(method)) {
                String[] patterns = this.collections[i2].findPatterns();
                int j2 = 0;
                while (j2 < patterns.length) {
                    if (this.matchPattern(uri, patterns[j2])) {
                        return true;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        return false;
    }

    private boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public void removeAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        int n2 = -1;
        int i2 = 0;
        while (i2 < this.authRoles.length) {
            if (this.authRoles[i2].equals(authRole)) {
                n2 = i2;
                break;
            }
            ++i2;
        }
        if (n2 >= 0) {
            int j2 = 0;
            String[] results = new String[this.authRoles.length - 1];
            int i3 = 0;
            while (i3 < this.authRoles.length) {
                if (i3 != n2) {
                    results[j2++] = this.authRoles[i3];
                }
                ++i3;
            }
            this.authRoles = results;
        }
    }

    public void removeCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        int n2 = -1;
        int i2 = 0;
        while (i2 < this.collections.length) {
            if (this.collections[i2].equals(collection)) {
                n2 = i2;
                break;
            }
            ++i2;
        }
        if (n2 >= 0) {
            int j2 = 0;
            SecurityCollection[] results = new SecurityCollection[this.collections.length - 1];
            int i3 = 0;
            while (i3 < this.collections.length) {
                if (i3 != n2) {
                    results[j2++] = this.collections[i3];
                }
                ++i3;
            }
            this.collections = results;
        }
    }

    public void setAuthConstraint(boolean authConstraint) {
        this.authConstraint = authConstraint;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setUserConstraint(String userConstraint) {
        if (userConstraint != null) {
            this.userConstraint = userConstraint;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityConstraint[");
        int i2 = 0;
        while (i2 < this.collections.length) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.collections[i2].getName());
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }
}

