/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;

public final class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper {
    private boolean allocated = false;
    private long available = 0L;
    private int debug = 0;
    private static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    private Servlet instance = null;
    private InstanceSupport instanceSupport = new InstanceSupport(this);
    private ClassLoader jasperLoader = null;
    private String jspFile = null;
    private int loadOnStartup = -1;
    private HashMap parameters = new HashMap();
    private HashMap references = new HashMap();
    private String runAs = null;
    private String servletClass = null;
    private boolean singleThreadModel = false;
    private boolean unloading = false;

    public StandardWrapper() {
        this.pipeline.setBasic(new StandardWrapperValve());
    }

    public void addChild(Container child) {
        throw new IllegalStateException(ContainerBase.sm.getString("standardWrapper.notChild"));
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    public void addInitParameter(String name, String value) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addInitParameter", name);
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    public void addSecurityReference(String name, String link) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(name, link);
        }
        this.fireContainerEvent("addSecurityReference", name);
    }

    public Servlet allocate() throws ServletException {
        if (this.debug >= 1) {
            this.log("Allocating an instance");
        }
        if (this.unloading) {
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.unloading", this.getName()));
        }
        if (this.instance == null) {
            try {
                this.load();
            }
            catch (ServletException e10) {
                throw e10;
            }
            catch (Throwable e11) {
                throw new ServletException(ContainerBase.sm.getString("standardWrapper.allocate"), e11);
            }
        }
        if (!this.singleThreadModel) {
            if (this.debug >= 2) {
                this.log("  Returning non-STM instance");
            }
            return this.instance;
        }
        Servlet servlet = this.instance;
        synchronized (servlet) {
            if (this.allocated) {
                if (this.debug >= 2) {
                    this.log("  Waiting for allocated STM instance");
                }
                try {
                    this.instance.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.debug >= 2) {
                this.log("  Returning allocated STM instance");
            }
            this.allocated = true;
            Servlet servlet2 = this.instance;
            Object var3_5 = null;
            return servlet2;
        }
    }

    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            return;
        }
        Servlet servlet2 = this.instance;
        synchronized (servlet2) {
            this.allocated = false;
            this.instance.notify();
        }
    }

    public String findInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String string = (String)this.parameters.get(name);
            Object var4_4 = null;
            return string;
        }
    }

    public String[] findInitParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            String[] stringArray = this.parameters.keySet().toArray(results);
            Object var3_4 = null;
            return stringArray;
        }
    }

    public String findSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            String string = (String)this.references.get(name);
            Object var4_4 = null;
            return string;
        }
    }

    public String[] findSecurityReferences() {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            String[] results = new String[this.references.size()];
            String[] stringArray = this.references.keySet().toArray(results);
            Object var3_4 = null;
            return stringArray;
        }
    }

    public long getAvailable() {
        return this.available;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getInfo() {
        return info;
    }

    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.parameters.keySet());
            Object var3_3 = null;
            return enumerator;
        }
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    private boolean isContainerServlet(String classname) {
        return classname.startsWith("org.apache.catalina.");
    }

    public boolean isSingleThreadModel() {
        try {
            this.load();
        }
        catch (Throwable throwable) {}
        return this.singleThreadModel;
    }

    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    public synchronized void load() throws ServletException {
        Wrapper jspWrapper;
        if (this.instance != null) {
            return;
        }
        String actualClass = this.servletClass;
        if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
            actualClass = jspWrapper.getServletClass();
        }
        if (actualClass == null) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.notClass", this.getName()));
        }
        Loader loader = this.getLoader();
        if (loader == null) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.missingLoader", this.getName()));
        }
        ClassLoader classLoader = loader.getClassLoader();
        if (this.isContainerServlet(actualClass)) {
            classLoader = this.getClass().getClassLoader();
            this.log(ContainerBase.sm.getString("standardWrapper.containerServlet", this.getName()));
        }
        if (actualClass.equals("org.apache.jasper.servlet.JspServlet")) {
            classLoader = ((StandardContext)this.getParent()).getJasperLoader();
            this.log(ContainerBase.sm.getString("standardWrapper.jasperLoader", this.getName()));
        }
        Class<?> classClass = null;
        try {
            classClass = classLoader != null ? classLoader.loadClass(actualClass) : Class.forName(actualClass);
        }
        catch (ClassNotFoundException e10) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.missingClass", actualClass), e10);
        }
        if (classClass == null) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.missingClass", actualClass));
        }
        Servlet servlet = null;
        try {
            servlet = (Servlet)classClass.newInstance();
        }
        catch (ClassCastException e11) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.notServlet", actualClass), e11);
        }
        catch (Throwable e12) {
            this.unavailable(null);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.instantiate", actualClass), e12);
        }
        try {
            this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
            servlet.init(this);
            this.instanceSupport.fireInstanceEvent("afterInit", servlet);
        }
        catch (UnavailableException f2) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            this.unavailable(f2);
            throw f2;
        }
        catch (ServletException f3) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            throw f3;
        }
        catch (Throwable f4) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.initException", this.getName()), f4);
        }
        this.instance = servlet;
        this.singleThreadModel = this.instance instanceof SingleThreadModel;
        this.fireContainerEvent("load", this);
    }

    protected String logName() {
        StringBuffer sb = new StringBuffer("StandardWrapper[");
        sb.append(this.getParent().getName());
        sb.append(':');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    public void removeInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        this.fireContainerEvent("removeInitParameter", name);
    }

    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    public void removeSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.remove(name);
        }
        this.fireContainerEvent("removeSecurityReference", name);
    }

    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", new Long(oldAvailable), new Long(this.available));
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Long(this.debug));
    }

    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
    }

    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", new Integer(oldLoadOnStartup), new Integer(this.loadOnStartup));
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            this.setLoadOnStartup(0);
        }
    }

    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardWrapper.notContext"));
        }
        super.setParent(container);
    }

    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        try {
            this.unload();
        }
        catch (ServletException e10) {
            this.log(ContainerBase.sm.getString("standardWrapper.unloadException", this.getName()), e10);
        }
        super.stop();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardWrapper[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void unavailable(UnavailableException unavailable) {
        this.log(ContainerBase.sm.getString("standardWrapper.unavailable", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    public synchronized void unload() throws ServletException {
        if (this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.allocated) {
            boolean first = true;
            while (this.allocated) {
                if (first) {
                    if (this.debug >= 1) {
                        this.log("Waiting for instance to be deallocated");
                    }
                    first = false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.instanceSupport.fireInstanceEvent("beforeDestroy", this.instance);
            this.instance.destroy();
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
        }
        catch (Throwable t2) {
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
            this.instance = null;
            this.fireContainerEvent("unload", this);
            this.unloading = false;
            throw new ServletException(ContainerBase.sm.getString("standardWrapper.destroyException", this.getName()), t2);
        }
        this.instance = null;
        this.jasperLoader = null;
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }
}

