/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.apache.catalina.Request;
import org.apache.catalina.util.StringManager;

public class RequestStream
extends ServletInputStream {
    protected boolean closed = false;
    protected int count = 0;
    protected int length = -1;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected InputStream stream = null;

    public RequestStream(Request request) {
        this.length = request.getRequest().getContentLength();
        this.stream = request.getStream();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.close.closed"));
        }
        if (this.length > 0) {
            while (this.count < this.length) {
                int b10 = this.read();
                if (b10 < 0) break;
            }
        }
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("requestStream.read.closed"));
        }
        if (this.length >= 0 && this.count >= this.length) {
            return -1;
        }
        int b10 = this.stream.read();
        if (b10 >= 0) {
            ++this.count;
        }
        return b10;
    }

    public int read(byte[] b10) throws IOException {
        return this.read(b10, 0, b10.length);
    }

    public int read(byte[] b10, int off, int len) throws IOException {
        int toRead = len;
        if (this.length > 0) {
            if (this.count >= this.length) {
                return -1;
            }
            if (this.count + len > this.length) {
                toRead = this.length - this.count;
            }
        }
        int actuallyRead = super.read(b10, off, toRead);
        return actuallyRead;
    }
}

