/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

public abstract class DocumentBuilderFactory {
    private static final String defaultPropName = "javax.xml.parsers.DocumentBuilderFactory";
    private boolean validating = false;
    private boolean namespaceAware = false;
    private boolean whitespace = false;
    private boolean expandEntityRef = true;
    private boolean ignoreComments = false;
    private boolean coalescing = false;
    private static String foundFactory = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$xml$parsers$DocumentBuilderFactory;

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {}
    }

    protected DocumentBuilderFactory() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static String findFactory(String factoryId, String defaultFactory) {
        block17: {
            block16: {
                try {
                    String systemProp = System.getProperty(factoryId);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JAXP: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException securityException) {}
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f2 = new File(configFile);
                    if (f2.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f2));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println("JAXP: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex2) {
                    if (!debug) break block16;
                    ex2.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                ClassLoader cl2 = (class$javax$xml$parsers$DocumentBuilderFactory != null ? class$javax$xml$parsers$DocumentBuilderFactory : (class$javax$xml$parsers$DocumentBuilderFactory = DocumentBuilderFactory.class$(defaultPropName))).getClassLoader();
                InputStream is = null;
                is = cl2 == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl2.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("JAXP: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("JAXP: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex3) {
                if (!debug) break block17;
                ex3.printStackTrace();
            }
        }
        return defaultFactory;
    }

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityRef;
    }

    public boolean isIgnoringComments() {
        return this.ignoreComments;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.whitespace;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public static DocumentBuilderFactory newInstance() {
        DocumentBuilderFactory factoryImpl;
        String factoryImplName = DocumentBuilderFactory.findFactory(defaultPropName, "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl");
        if (factoryImplName == null) {
            throw new FactoryConfigurationError("No default implementation found");
        }
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (DocumentBuilderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public void setExpandEntityReferences(boolean expandEntityRef) {
        this.expandEntityRef = expandEntityRef;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setIgnoringElementContentWhitespace(boolean whitespace) {
        this.whitespace = whitespace;
    }

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }
}

