/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.text.ParseException;

class MailDateParser {
    int index = 0;
    char[] orig = null;

    public MailDateParser(char[] cArray) {
        this.orig = cArray;
    }

    public void skipUntilNumber() throws ParseException {
        try {
            while (true) {
                switch (this.orig[this.index]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return;
                    }
                }
                ++this.index;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("No Number Found", this.index);
        }
    }

    public void skipWhiteSpace() {
        int n2 = this.orig.length;
        while (this.index < n2) {
            switch (this.orig[this.index]) {
                case '\t': 
                case ' ': {
                    ++this.index;
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public int peekChar() throws ParseException {
        if (this.index < this.orig.length) {
            return this.orig[this.index];
        }
        throw new ParseException("No more characters", this.index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void skipChar(char c10) throws ParseException {
        if (this.index >= this.orig.length) throw new ParseException("No more characters", this.index);
        if (this.orig[this.index] != c10) throw new ParseException("Wrong char", this.index);
        ++this.index;
    }

    public boolean skipIfChar(char c10) throws ParseException {
        if (this.index < this.orig.length) {
            if (this.orig[this.index] == c10) {
                ++this.index;
                return true;
            }
            return false;
        }
        throw new ParseException("No more characters", this.index);
    }

    public int parseNumber() throws ParseException {
        int n2 = this.orig.length;
        boolean bl2 = false;
        int n3 = 0;
        while (this.index < n2) {
            switch (this.orig[this.index]) {
                case '0': {
                    n3 *= 10;
                    bl2 = true;
                    break;
                }
                case '1': {
                    n3 = n3 * 10 + 1;
                    bl2 = true;
                    break;
                }
                case '2': {
                    n3 = n3 * 10 + 2;
                    bl2 = true;
                    break;
                }
                case '3': {
                    n3 = n3 * 10 + 3;
                    bl2 = true;
                    break;
                }
                case '4': {
                    n3 = n3 * 10 + 4;
                    bl2 = true;
                    break;
                }
                case '5': {
                    n3 = n3 * 10 + 5;
                    bl2 = true;
                    break;
                }
                case '6': {
                    n3 = n3 * 10 + 6;
                    bl2 = true;
                    break;
                }
                case '7': {
                    n3 = n3 * 10 + 7;
                    bl2 = true;
                    break;
                }
                case '8': {
                    n3 = n3 * 10 + 8;
                    bl2 = true;
                    break;
                }
                case '9': {
                    n3 = n3 * 10 + 9;
                    bl2 = true;
                    break;
                }
                default: {
                    if (bl2) {
                        return n3;
                    }
                    throw new ParseException("No Number found", this.index);
                }
            }
            ++this.index;
        }
        if (bl2) {
            return n3;
        }
        throw new ParseException("No Number found", this.index);
    }

    public int parseMonth() throws ParseException {
        try {
            switch (this.orig[this.index++]) {
                case 'J': 
                case 'j': {
                    switch (this.orig[this.index++]) {
                        case 'A': 
                        case 'a': {
                            char c10 = this.orig[this.index++];
                            if (c10 != 'N' && c10 != 'n') break;
                            return 0;
                        }
                        case 'U': 
                        case 'u': {
                            char c11 = this.orig[this.index++];
                            if (c11 == 'N' || c11 == 'n') {
                                return 5;
                            }
                            if (c11 != 'L' && c11 != 'l') break;
                            return 6;
                        }
                    }
                    break;
                }
                case 'F': 
                case 'f': {
                    char c12 = this.orig[this.index++];
                    if (c12 != 'E' && c12 != 'e' || (c12 = this.orig[this.index++]) != 'B' && c12 != 'b') break;
                    return 1;
                }
                case 'M': 
                case 'm': {
                    char c13 = this.orig[this.index++];
                    if (c13 != 'A' && c13 != 'a') break;
                    if ((c13 = this.orig[this.index++]) == 'R' || c13 == 'r') {
                        return 2;
                    }
                    if (c13 != 'Y' && c13 != 'y') break;
                    return 4;
                }
                case 'A': 
                case 'a': {
                    char c14 = this.orig[this.index++];
                    if (c14 == 'P' || c14 == 'p') {
                        if ((c14 = this.orig[this.index++]) != 'R' && c14 != 'r') break;
                        return 3;
                    }
                    if (c14 != 'U' && c14 != 'u' || (c14 = this.orig[this.index++]) != 'G' && c14 != 'g') break;
                    return 7;
                }
                case 'S': 
                case 's': {
                    char c15 = this.orig[this.index++];
                    if (c15 != 'E' && c15 != 'e' || (c15 = this.orig[this.index++]) != 'P' && c15 != 'p') break;
                    return 8;
                }
                case 'O': 
                case 'o': {
                    char c16 = this.orig[this.index++];
                    if (c16 != 'C' && c16 != 'c' || (c16 = this.orig[this.index++]) != 'T' && c16 != 't') break;
                    return 9;
                }
                case 'N': 
                case 'n': {
                    char c17 = this.orig[this.index++];
                    if (c17 != 'O' && c17 != 'o' || (c17 = this.orig[this.index++]) != 'V' && c17 != 'v') break;
                    return 10;
                }
                case 'D': 
                case 'd': {
                    char c18 = this.orig[this.index++];
                    if (c18 != 'E' && c18 != 'e' || (c18 = this.orig[this.index++]) != 'C' && c18 != 'c') break;
                    return 11;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new ParseException("Bad Month", this.index);
    }

    public int parseTimeZone() throws ParseException {
        if (this.index >= this.orig.length) {
            throw new ParseException("No more characters", this.index);
        }
        char c10 = this.orig[this.index];
        if (c10 == '+' || c10 == '-') {
            return this.parseNumericTimeZone();
        }
        return this.parseAlphaTimeZone();
    }

    public int parseNumericTimeZone() throws ParseException {
        char c10;
        boolean bl2 = false;
        if ((c10 = this.orig[this.index++]) == '+') {
            bl2 = true;
        } else if (c10 != '-') {
            throw new ParseException("Bad Numeric TimeZone", this.index);
        }
        int n2 = this.parseNumber();
        int n3 = n2 / 100 * 60 + n2 % 100;
        if (bl2) {
            return -n3;
        }
        return n3;
    }

    public int parseAlphaTimeZone() throws ParseException {
        char c10;
        int n2 = 0;
        boolean bl2 = false;
        try {
            switch (this.orig[this.index++]) {
                case 'U': 
                case 'u': {
                    c10 = this.orig[this.index++];
                    if (c10 == 'T' || c10 == 't') {
                        n2 = 0;
                        break;
                    }
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
                case 'G': 
                case 'g': {
                    c10 = this.orig[this.index++];
                    if (!(c10 != 'M' && c10 != 'm' || (c10 = this.orig[this.index++]) != 'T' && c10 != 't')) {
                        n2 = 0;
                        break;
                    }
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
                case 'E': 
                case 'e': {
                    n2 = 300;
                    bl2 = true;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = 360;
                    bl2 = true;
                    break;
                }
                case 'M': 
                case 'm': {
                    n2 = 420;
                    bl2 = true;
                    break;
                }
                case 'P': 
                case 'p': {
                    n2 = 480;
                    bl2 = true;
                    break;
                }
                default: {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Bad Alpha TimeZone", this.index);
        }
        if (bl2) {
            if ((c10 = this.orig[this.index++]) == 'S' || c10 == 's') {
                if ((c10 = this.orig[this.index++]) != 'T' && c10 != 't') {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            } else if (c10 == 'D' || c10 == 'd') {
                if ((c10 = this.orig[this.index++]) == 'T' || c10 != 't') {
                    n2 -= 60;
                } else {
                    throw new ParseException("Bad Alpha TimeZone", this.index);
                }
            }
        }
        return n2;
    }

    int getIndex() {
        return this.index;
    }
}

