/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;

public final class WebContainerListener
implements ContainerListener {
    public static boolean debug = false;
    private static HashSet beforeEvents = new HashSet();
    private static HashSet afterEvents = new HashSet();
    private InvocationManager im;

    public void containerEvent(ContainerEvent event) {
        String type;
        if (debug) {
            System.err.println("**** ContainerEvent: " + event.getType() + "," + event.getContainer() + "," + event.getData());
        }
        if (beforeEvents.contains(type = event.getType())) {
            this.preInvoke((Context)event.getContainer());
        } else if (afterEvents.contains(type)) {
            this.postInvoke((Context)event.getContainer());
        }
    }

    private void preInvoke(Context ctx) {
        final ClassLoader cl2 = ctx.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl2);
                return null;
            }
        });
        ComponentInvocation inv = new ComponentInvocation();
        inv.instance = null;
        inv.container = ctx;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.preInvoke(inv);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            ex2.printStackTrace();
        }
    }

    private void postInvoke(Context ctx) {
        ComponentInvocation inv = new ComponentInvocation();
        inv.instance = null;
        inv.container = ctx;
        try {
            if (this.im == null) {
                this.im = Switch.getSwitch().getInvocationManager();
            }
            this.im.postInvoke(inv);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            ex2.printStackTrace();
        }
    }

    static {
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
    }
}

